/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.01 30/1/90
 *
 * pgm 
 *
 * SetAlgorithm.c
 ******************************************************************************/

#include "myheader.h"
#include "everything.h"
#include <signal.h>
#include <netdb.h> /* to get Interet port for connection */

/*----------------------------------------------------*/
/* THESE PROC TAKE CARE THE FAMILY OF PROVIDED ALGORITHMS */
/* 1- SetAlgorithm() => Set the number of algorithms specified */
/*----------------------------------------------------*/
/*----------------------------------------------*/
/* THIS PROC DISPLAYS AS COMMAND WIDGET ALL THE ALGORITHM FILENAME */
/* AND ALLOWS THE USER TO SELECT WHICH ONE HE WANTS TO USE */
/*-----------------------------------------------------------*/

/* THIS SHOULD BE GLOBAL (see IOTake for MagaliRandWeight */
int algo_need_random ;

/* The server is initialised here */
  extern char server[];

  extern CLIENT *myclient;
extern Widget nCconfig;
extern Widget lload;
extern Arg nCconfig_arg[];
extern Arg lload_arg[];
#define SAMELIMIT 150 

/* Args for top_control menu widget */
Arg algtopcontrol_arg[] = {
                {XtNx, (XtArgVal)0},
                {XtNy, (XtArgVal)0},
		{XtNborderWidth, (XtArgVal) 3},
        };

/* Declaration of the structure for callback argument */
  typedef struct {
  		  Widget dead ;
  		  Widget kill ;
                  int algocounter ;
		 } FirstNice ;         	

 typedef char  aname[100] ;
 
 typedef struct {
		int number_algo ;
	        aname algoname[100] ; 
		}  AlgorithmFamily ;

 AlgorithmFamily algorithmfam ;

/*----------------------------------------*/
/* Try to get the Darpa Internet Port to use for the connection */
u_short inport()
 {
 struct servent *trysvc ;

  trysvc = getservbyname("exec", "tcp") ;
  if (trysvc == (struct servent *) 0)
                 {
   		 Error(61) ;
    		 return ;
		 } ;
  return(trysvc->s_port) ;
 }


/*----------------------------------------*/
/* Set the family at the beginning of the session    */
/*     assign the total number of algorithm          */
/*     assign each name according to the position    */
  void SetAlgorithm() 
  {
  FILE *ftry ;
  aname one_line ;
  char afilename[200] ;
  char *index() ;
  int count ;


   algorithmfam.number_algo = 0 ; 
   sprintf(afilename , "%s/%s" , rc[RC_algorithm_directory] , "algorithms.lib") ;
  if ( !(ftry = fopen(afilename, "r") ) )
      {
      Error(13) ;
      return ;
      }  ;
  count = 0 ;
  while( fgets(one_line, SAMELIMIT , ftry) != NULL  && !feof(ftry) )
     { 
      if (one_line[0] != '\n')  
	 {
          algorithmfam.number_algo = algorithmfam.number_algo +1 ;
          *index(one_line , '\n') = '\0' ;
          strcpy(algorithmfam.algoname[count] , one_line ) ;
          count++ ; 
	 } ; 
       } ;

  }

/*----------------------------------------------*/
/* CALL BACK OF ANY COMMAND  PATTERN               */
/*---------------------------------------------*/
/* ANYALGO_CALLBACK() = */

  void Anyalgo_callback(initiateur, client_data, call_data)
  Widget initiateur;
  FirstNice *client_data;  
  caddr_t call_data;     /* not used  */
  {
  char test[150] ;
  int serv_remote ;
  char my_user[120] ;
  char thehost[120] ;
  char *hp = thehost , **hpp = &hp ;
  FILE *fp ;
  char another[200] ;
  char again[50] ;
  char buf[256];
  Bool algofind ;

/* assign the correct file server according to the algo */
  algofind = False ;

  while (!algofind)
	{
/* case  backprop */
	if ( !strcmp(algorithmfam.algoname[client_data->algocounter] , 
		"Backpropagation"  ) 
	   )
	 {
	sprintf(test , "%s/%s" , 
		rc[RC_rpc_server_directory] , "nc_bpsvc") ;
	  algofind = True ;
	  algo_need_random = 1 ;
	 } ;


/* case hopfield */
	if ( !strcmp(algorithmfam.algoname[client_data->algocounter] , 
		"Hopfield"  ) 
	   )
	 {
	sprintf(test , "%s/%s" , 
			rc[RC_rpc_server_directory] , "nc_hfsvc") ;
	  algofind = True ;
	  algo_need_random = 1 ;
	 } ;

/* case boltzmann */
	if ( !strcmp(algorithmfam.algoname[client_data->algocounter] , 
		"Boltzmann"  ) 
	   )
	  {
	  algofind = True ;
	sprintf(test , "%s/%s" , 
			rc[RC_rpc_server_directory] , "nc_bosvc") ;
	  algofind = True ;
	  algo_need_random = 0 ;
	  } ;

/* case som kohonen */
	if ( !strcmp(algorithmfam.algoname[client_data->algocounter] , 
		"SelfOrganisingMap"  ) 
	   )
	  {
	sprintf(test , "%s/%s" , 
			rc[RC_rpc_server_directory] , "nc_sosvc") ;
	  algofind = True ;
	  algo_need_random = 0 ;
	  } ;

/* case user algorihtm */
/* this error return should dissapear */
	if (!algofind)
	  {
	sprintf(buf , "%s_%s%s" , "nc" ,
		algorithmfam.algoname[client_data->algocounter]  ,
		"svc");
	sprintf(test , "%s/%s" , rc[RC_rpc_server_directory] , 
				 buf );
	  algofind = True ;
	  algo_need_random = 1 ;
	  } ;

  } ;
/* end of the While */

/* Server has been initialised in Take_input(4) from RealSelect...*/
    strcpy(thehost , server) ;
  
/* Kill any existing nc_server on the machine specified */
/* 1- RPC terminate if there was one server running */
/* 2- REXEC ps grep to check that everything will go right */

  if (my_algorithm) 
       if ( !TerminateRpc() )
            {
		Error(62) ;
		return ;
	     } ;

/* I should test that the file does exist before execution */
/* and REMOTELY start the new server */
printf("\n\nTo start up the server, please supply\nyour username and password at the\nappropriate prompts\n\n");

  serv_remote = rexec(hpp, inport(), NULL, NULL, test , (int *) 0) ;

  if (serv_remote < 0 )
          {
	printf("Serv REMOTE is WRONG\n") ;
          Error(60) ;
          return;
          } 
  else
        {
	
/* 2- Create the client */
         Create_client();
      	}

/* Init everything to run correctly */
   connect_session = 0 ; assoc_session = 0 ; param_session = 0 ;
   my_application = True ;
   my_algorithm = True ;
   Add_information(5,algorithmfam.algoname[client_data->algocounter]) ;

/*   XtPopdown(client_data->dead) ;*/
XtUnmapWidget(client_data->dead) ;

  } 

/*---------------------------------------------------*/
/*---------------------------------------------------*/

  void SelectAlgo(dad ) 
  Widget dad;
  {
  Widget  top_control ,
	    control , 
            *everyalgo ;

  FirstNice **AlgoArgument ; /* has to be a pointer because callback*/
	                /* argument are cast and a struct can not be cast */
  int i , counter ;
  char bypass[150] ;
  char *beforebypass ;

extern Arg algtopcontrol_arg[3];
Window junk_win;
int x_root, y_root,garbage;
unsigned int garbage_mask;

 /* ENTER ANY COMMAND WINDOW = HIGHLIGHT */
  static String command_trans = "<EnterWindow>: set()" ;
  XtTranslations command_compiled ;

/* Change the cursor */
  Cursor thecursor ; Display *thedisplay ; Window thewindow ;

/*  Position *relativeX , *relativeY ;
  Position theX ,theY ;
*/

/* obligation for the control widget not to have a NULL size */
        static Arg control_arg[] = {
                {XtNdestroyCallback, (XtArgVal)NULL},
		{XtNborderWidth, (XtArgVal) 0},
                } ;

  
/* Arguments for the children of the Form*/
/* Args for any command widget */
        static Arg anycommand_arg[] = {
                {XtNfromVert, (XtArgVal)NULL},
                {XtNfromHoriz, (XtArgVal)NULL},
                {XtNvertDistance, (XtArgVal)1},
                {XtNhorizDistance, (XtArgVal)2},
/* MIKE CHANGE for foreground */
                {XtNdestroyCallback, (XtArgVal)NULL},
		{XtNborderWidth, (XtArgVal) 0},
                } ;




/* if no algorithm provided do nothing */
      if (algorithmfam.number_algo == 0 )
         return ;




/*  relativeX = 0 ;
  relativeY = 0 ;
 XtTranslateCoords(dad , relativeX , relativeY , &theX , &theY ) ;

theX = theX + (BUTTON_WIDTH - 8) ;
theY = theY + (BUTTON_HEIGHT - 6) ;

 XtSetArg(topcontrol_arg[0],XtNx, theX) ;
 XtSetArg(topcontrol_arg[1],XtNy, theY) ;
*/
        top_control = XtCreatePopupShell("Algo Menu",
                                overrideShellWidgetClass,
                                dad,
                                algtopcontrol_arg,
                                XtNumber(algtopcontrol_arg));


       control = XtCreateManagedWidget("ALGO MENU",
				formWidgetClass,
				top_control,
				control_arg,
				XtNumber(control_arg));

/* Create as many algo  command widget as needed */
    
/* Allocation fo the memory space 1- for the widgets */
/*              2- for the pointer to SCalback */
  everyalgo = (Widget *) calloc( sizeof(Widget) , algorithmfam.number_algo) ;

  AlgoArgument = (FirstNice **) 
           calloc(sizeof(FirstNice *), algorithmfam.number_algo );

  for ( counter = 0 ; counter < algorithmfam.number_algo ; counter++ )
   AlgoArgument[counter] = ( FirstNice *) calloc(sizeof(FirstNice) , 1) ;


/* Assign  the fields of the callback argument */
 for (counter = 0 ; counter < algorithmfam.number_algo ; counter++)
   {
   AlgoArgument[counter]->dead = top_control ;
   AlgoArgument[counter]->kill = NULL ;  /* not used at the moment */
   } ;


/* Creation loop */ 
  for (counter = 0 ; 
       counter < algorithmfam.number_algo ; 
 	counter++) 
   {
    if (counter >= 1 )
    XtSetArg(anycommand_arg[0],XtNfromVert, everyalgo[counter-1]) ;
    else
     XtSetArg(anycommand_arg[0],XtNfromVert, NULL) ;

/* assign the name of that algo */
    sprintf(bypass, " %s " , algorithmfam.algoname[counter])  ;


    everyalgo[counter] = XtCreateManagedWidget(
                             bypass, 
                             commandWidgetClass,
                             control,
                             anycommand_arg,
                             XtNumber(anycommand_arg));

        AlgoArgument[counter]->algocounter = counter ;

        XtAddCallback(everyalgo[counter], XtNcallback,
                Anyalgo_callback, (caddr_t)AlgoArgument[counter]) ;

    }  ;


/* compiled the new translation */
  command_compiled = XtParseTranslationTable(command_trans) ;
  for (counter = 0 ; counter < algorithmfam.number_algo ; counter++) 
    XtOverrideTranslations(everyalgo[counter], command_compiled) ;


/* REALIZE  */
/*  XtPopup(top_control, XtGrabNone) ;*/
XtRealizeWidget(top_control);
XQueryPointer(XtDisplay(top_control), XtWindow(top_control), &junk_win, &junk_win, &x_root, &y_root, &garbage, &garbage, &garbage_mask);
XtSetArg(algtopcontrol_arg[0],XtNx, x_root-20) ;
XtSetArg(algtopcontrol_arg[1],XtNy, y_root-20) ;
XtSetValues(top_control, algtopcontrol_arg, XtNumber(algtopcontrol_arg));
XtMapWidget(top_control);


/* Change the cursor ; becomes an arrow */
  thedisplay = XtDisplay(control) ;
  thewindow = XtWindow(control) ;
  thecursor = XCreateFontCursor(thedisplay , XC_sb_right_arrow) ;
  XDefineCursor(thedisplay, thewindow , thecursor) ;

}

