/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.01 30/1/90
 *
 * pgm 
 *
 * 
 ******************************************************************************/

#include "everything.h"
#include "mymonitor.h"
#include "mike_display.h"

/* The configuration of the loaded nC neural network */
/* NB obtained via RPC call */
extern confres *conf ;
/* Args for top_control menu widget */
Arg selecttopcontrol_arg[] = {
                {XtNx, (XtArgVal)0},
                {XtNy, (XtArgVal)0},
        };

/*--------------------------------------------------*/
/* THIS PROCEDURE DEALS WITH THE CHOICE OF THE COMPONENTS */
/* OF WHICH THE USER WANTS TO SEE THE INTERCONNECTIVITY */
/*--------------------------------------------------*/

 
/*--------------------------------------------------*/
/*  PROC CALLLED FROM RULEDISPLAYPARAMCREATE.C
/*
 * this call back proc creates a menu list widget
 * which allows the user to enter the two numbers refering to the
 * two elements he wants to see the interconnectivity between 
*/
/* Grand_father is LEVEL_DISPLAY */
  void Select( pathway , father, grand_father )
  int pathway[] ;
  Widget father , grand_father ;
  {
   Widget  top_control , 
	 control ;
 
   int count  ;
   FamilyWidget tricky_fami ;

Window junk_win;
int x_root, y_root,garbage;
unsigned int garbage_mask;
extern Arg selecttopcontrol_arg[2];

/* ENTER ANY COMMAND WINDOW = HIGHLIGHT */
  static String command_trans = "<EnterWindow>: set()" ;
  XtTranslations command_compiled ;

/* Change the cursor */
 Cursor thetried_cursor ; Display *thetried_display ; Window thetried_window ;

/*  Position *relativeX , *relativeY ;
  Position theX ,theY ;
*/
/* obligation for the control widget not to have a NULL size */
        static Arg control_arg[] = {
/* MIKE CHANGE for foreground */
                {XtNdestroyCallback, (XtArgVal)NULL},
                } ;



/*  relativeX = 0 ;
  relativeY = 0 ;
 XtTranslateCoords(father, relativeX , relativeY , &theX , &theY ) ;

 XtSetArg(topcontrol_arg[0],XtNx, theX) ;
 XtSetArg(topcontrol_arg[1],XtNy, theY + 35) ;
*/
        top_control = XtCreatePopupShell("Interconnect",
                                overrideShellWidgetClass,
                                father,
                                selecttopcontrol_arg,
                                XtNumber(selecttopcontrol_arg));


             control = XtCreateManagedWidget("connect Menu",
                                formWidgetClass,
                                top_control,
                                control_arg,
                                XtNumber(control_arg) );


/* Set tricky_fami */
tricky_fami.mikeneed = grand_father;
tricky_fami.firstmenu = father ;
tricky_fami.nowmenu = top_control ;
tricky_fami.nowform = control ;

/* ALL of them are called like if it was about net */
/* but this is just because i was too lazy to change */
/* into a generic name  after testing */

/* According to the path pop up the correct menu and numbers allowed */
 switch(GiveLevel(pathway) )
        {
/* system level => select net interconnect */
 case 0 :
  NetInterconnect(pathway, tricky_fami, conf->confres_u) ;
  break ;

/* net level => select layer interconnect */
 case 1 : 
  NetInterconnect(pathway, tricky_fami, conf->confres_u) ;
                  break ;
/* layer level => select cluster interconnect */
 case 2 : 
  NetInterconnect(pathway, tricky_fami, conf->confres_u) ;
                  break ;
/* cluster level => select neuron interconnect */
 case 3 : 
  NetInterconnect(pathway, tricky_fami, conf->confres_u) ;
                  break ;
/* neuron level => no select */
 case 4 : 
         Error(9) ; 
         break ;
        } ;
 

/* REALIZE */
/*	XtPopup(top_control, XtGrabNone);   */
XtRealizeWidget(top_control);
XQueryPointer(XtDisplay(top_control), XtWindow(top_control), &junk_win, &junk_win, &x_root, &y_root, &garbage, &garbage, &garbage_mask);
XtSetArg(selecttopcontrol_arg[0],XtNx, x_root-20) ;
XtSetArg(selecttopcontrol_arg[1],XtNy, y_root-20) ;
XtSetValues(top_control, selecttopcontrol_arg, XtNumber(selecttopcontrol_arg));
XtMapWidget(top_control);


/* Change the cursor ; beomes an arrow */
thetried_display = XtDisplay(control) ;
thetried_window = XtWindow(control) ;
thetried_cursor = XCreateFontCursor(thetried_display , XC_sb_right_arrow) ;
XDefineCursor(thetried_display, thetried_window , thetried_cursor) ;

}
