/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.01 30/1/90
 *
 * pgm 
 *
 * 
 ******************************************************************************/

#include "myheader.h"
#include "everything.h"
#include "mymonitor.h"
#include "mike_display.h"

extern int loadinput ;

/* Args for top_control menu widget */
        Arg Ruletopcontrol_arg[] = {
                {XtNx, (XtArgVal)0},
                {XtNy, (XtArgVal)0},
		{XtNborderWidth, (XtArgVal) 3},
        };

        Arg RDPCanycommand_arg[] = {
                {XtNfromVert, (XtArgVal)NULL},
                {XtNfromHoriz, (XtArgVal)NULL},
                {XtNvertDistance, (XtArgVal)1},
                {XtNhorizDistance, (XtArgVal)2},
                {XtNdestroyCallback, (XtArgVal)NULL},
		{XtNborderWidth, (XtArgVal) 0},
		{XtNjustify, (XtArgVal) XtJustifyLeft},
                } ;




/**----------------------------------------------*/
/*  RULEDISPLAYPARAM_CREATE  PROC		*/
/*   creates :					*/
/*              1- the control  (as level_rule) SEE LEVELRULECREATE.C */
/*		2- the display (as level_display) SEE DISPLAY.C  */
/* 		3- the status  (as level_param) SEE LEVELPARAMCREATE.C  */
/*----------------------------------------------*/

/*
 * GodFather is the level_monitor, form widget, created in LevelMonitorCreate.c
 * GodChild is the level_title, command widget, created in LevelMonitorCreate.c
 *
 *  LATER 
 *   Rule area, form widget (level_rule)
 *     which correspond to an area plenty of buttons boxes related 
 *     to the nC rules of the level
 *
 *   Graphic display area, command widget (level_display) 
 *
 *   Parameter area, form widget   (level_param) 
 *     which correspond to an area plenty of buttons boxes related 
 *     to the nC parameters of the level
 *	SEE ParamCreate.c
 *    
*/
/* to give a visual idea of the widget hierarchy here. */
	Widget /* godfather , */
                        /* godchild */
			level_rule ,
			level_display,
			level_param ;
				/*new_pureinfo_graphic; */

/* Declaration of the struct to pass as param to callback "Coloumap,*/
/*					 Colour and Select and Unselect */
typedef struct  {
                int thepath[4] ;
                Widget themom ;
                Widget themomie ;
                } ForCallback ;


/*-----------------------------------------------------------*/
/* ACTION MYPOPDOWN() = Popdown the (magnify,colourmap,colour,select) */
/*                              alias ?_control            */
/*-----------------------------------------------------------*/
  static void Display_popdown(widpopdown,event,params,num_params)
  Widget widpopdown;
  XEvent *event ;
  String *params ;
  Cardinal *num_params ;
  {
/*  XtPopdown(widpopdown) ;*/
XtUnmapWidget(widpopdown);
  }

/*----------------------------------------------*/
/* CALL BACK OF THE COMMAND "MAGNIFY","COLOURMAP","ASSOC. COLOUR",*/
/*			    " DISPLAY As MATRI CONNECTION DISPLAY */
/*---------------------------------------------*/
/* MAGNIFY_CALLBACK() */
  void Magnify_callback(initiateur, client_data, call_data)
  Widget initiateur;
  Widget client_data;  /* used to get top_control in order to pass it*/
  caddr_t call_data;     /* not used  */
  {
  char trick[100] ;

/*	XtPopdown(client_data) ;*/
XtUnmapWidget(client_data);
/* TRY TO GET THE POPDOWN EVENT BEFORE THE SYSTEM CALL */
/* try to tell that to the server : get an Xserver error */
        sprintf(trick , "xmag -source 150x150 -mag 3 &") ;
	system(trick) ;
  }

/*---------------------------------------------*/
/* COLOURMAP_CALLBACK() */
  void Colourmap_callback(initiateur, client_data, call_data)
  Widget initiateur;
  ForCallback *client_data;  /* used to get all info needed */
  caddr_t call_data;     /* not used  */
  {
  int i ;
 
Colour(client_data->thepath,client_data->themom , client_data->themomie) ;  
/* the mom is the topmenu */
/* the momie is the LEVEL_DISPLAY */
  }

/*---------------------------------------------*/
/* ASSOC. COLOUR_CALLBACK() */
  void Assoc_Colour_callback(initiateur, client_data, call_data)
  Widget initiateur;
  ForCallback *client_data;  /* used to get all info needed */
  caddr_t call_data;     /* not used  */
  {
  int i ;
 
   AssocColour(client_data->thepath, 
               client_data->themom  ) ;  
/* the mom is the topmenu */
  }

/*---------------------------------------------*/
/* SELECT_CALLBACK() => CONNECTION DISPLAY     */
  void Select_callback(initiateur, client_data, call_data)
  Widget initiateur;
  ForCallback *client_data;  /* used to get all info needed */
   			/* for Mike */
  caddr_t call_data;     /* not used  */
  {
  int i ;
 
Select(client_data->thepath,client_data->themom , client_data->themomie) ;  
/* the mom is the topmenu */
/* the momie is the LEVEL_DISPLAY */
  }

/*---------------------------------------------*/
/* UNSELECT_CALLBACK() => REMOVE CONNECTION */
  void Unselect_callback(initiateur, client_data, call_data)
  Widget initiateur;
  ForCallback *client_data;  /* used to get all info needed */
   			/* for Mike */
  caddr_t call_data;     /* not used  */
  {
  int i ; 
  int stu1[4] , stu2[4] ;

  for (i=0 ; i<4 ; i++)
    { stu1[i] = 0 ; stu2[i] = 0; } ;
 
/* the momie is the LEVEL_DISPLAY */
   Unfill_connect_family(client_data->thepath,client_data->themomie ) ;  

/* call refresh window with stupid connpath to mike*/
   refresh_window(client_data->themomie, client_data->thepath , 0 ,
		  stu1 , stu2) ;
  }

/*---------------------------------------------*/
/* EXPAND_CALLBACK() */
/* AT THE MOMENT ONLY FOR    MONOCHROME OPTION */
  void Expand_callback(initiateur, client_data, call_data)
  Widget initiateur;
  ForCallback *client_data;  /* used to get all info needed */
   			/* for Mike */
  caddr_t call_data;     /* not used  */
  {
  int i ;
  float ascale[2] ;
  float anoscale[2] ;
  int fortest1[4] , fortest2[4] ;
  int fortestflag ;

  ascale[0] = 0 ; ascale[1] = 1 ; 
  anoscale[0] = 0 ; anoscale[1] = 1 ; 

/*
 *  GiveNeuronScaleFamily(client_data->thepath , ascale) ; 
 *  FindForMike( client_data->thepath ,
 *               client_data->themomie ,
 *	       &fortestflag ,
 *	       fortest1 ,
 *	       fortest2 
  *	     ) ;
 *  if (fortestflag)
 *    GiveWeightScaleFamily(client_data->thepath, anoscale) ; 
* Call another menu to know what the user wants to change => neuron,weight
 *  Normalise(client_data->thepath ,
 *	    client_data->themom  ,
 *            ascale ,
 *            anoscale 
 *	   ) ;
 */
   TakeTreshold( client_data->themom  , client_data->thepath) ;

  }

/*---------------------------------------------*/
/* EASY_DISPLAY_CALLBACK() */
  void Easy_display_callback(initiateur, client_data, call_data)
  Widget initiateur;
  ForCallback *client_data;  /* used to get all info needed */
   			/* for Mike */
  caddr_t call_data;     /* not used  */
  {
  int i ;
  int fortest1[2] , fortest2[2] ;
  int fortestflag ;

  if (!loadinput) { Error(21) ;  return ;} ;
  Fill_dim_flag(client_data->thepath , client_data->themomie) ;

/* Call Mike for purposes test only ; when MIKE's work done call REFRESH MIKE */

  MattrixMike( client_data->thepath ,
               client_data->themomie ,
	       &fortestflag ,
	       fortest1 ,
	       fortest2 
 	     ) ;

	redraw_graphic_window(client_data->themomie, client_data->thepath);
  }

/*---------------------------------------------*/
/* REMOVE_EASY_DISPLAY_CALLBACK() */
  void Remeasy_callback(initiateur, client_data, call_data)
  Widget initiateur;
  ForCallback *client_data;  /* used to get all info needed */
   			/* for Mike */
  caddr_t call_data;     /* not used  */
  {
  int i ;

  if (!loadinput) { return ;} ;
    Unfill_dim_flag(client_data->thepath , client_data->themomie) ;
    redraw_graphic_window(client_data->themomie, client_data->thepath);
  }

/*----------------------------------------------*/
/*----------------------------------------------*/
/*
 * NEW ACTIONS:<BUTTONPRESS>:POPUP THE MENU (Magnify,Colourmap,Colour)
 *						(ExpandScale OR treshold )
 *				    (matrix display, remove matrix  display)
 *			    	  (connection display, remove connect. display)
 *     USED WITHIN LEVEL_DISPLAY
 */
/*----------------------------------------------*/
  static void Display_popup(thecaller,event,params,num_params)
  Widget thecaller;
  XEvent *event ;
  String *params ;    /* contains the path */
  Cardinal *num_params ;
  {
  Widget top_control , 
	  control , 
	        option_title ,
		magnify , colourmap , colour , 
 		expand_scale , easy_display , rem_easy ,
		select_connect , unselect_connect ;
  int i , matrix_help ;
  int feedpath[4] ;
  ForCallback *HairyArg ;

extern Arg Ruletopcontrol_arg[3];
extern Arg RDPCanycommand_arg[7];
Window junk_win;
int x_root, y_root,garbage;
unsigned int garbage_mask;


/* LEAVE WINDOW IMPLIES DISPLAY_POPDOWN */
  static String trans_displaymenu = "<LeaveWindow>: display_popdown()" ;
    XtTranslations compiled_displaymenu ;
  static XtActionList displaymenuaction[]={{"display_popdown",Display_popdown}};

/* ENTER ANY COMMAND WINDOW = HIGHLIGHT */
  static String command_trans = "<EnterWindow>: set()" ;
  XtTranslations command_compiled ;

/* Change the cursor */
 Cursor thecursor ; Display *thedisplay ; Window thewindow ;

/*  Position *relativeX , *relativeY ;
  Position theX ,theY ;
*/
/* Arguments for the children of the Form*/
/* Args for the title widget */
       static Arg optiontitle_arg[] = {
                {XtNfromVert, (XtArgVal)NULL},
                {XtNfromHoriz, (XtArgVal)NULL},
                {XtNvertDistance, (XtArgVal)1},
                {XtNhorizDistance, (XtArgVal)2},
                {XtNborderWidth, (XtArgVal)3},
                } ;
/* MIKE CHANGE for foreground */
/* Args for any command widget */

/* obligation for the control widget not to have a NULL size */
        static Arg control_arg[] = {
/* MIKE CHANGE */
                {XtNdestroyCallback, (XtArgVal)NULL},
                } ;


/* Assign the int path from the string path !!! */
for ( i = 0 ; i < 4 ; i++)
    { 
  feedpath[i] = atoi(params[i]) ;
    } ;

/*  relativeX = 0 ;
  relativeY = 0 ;
 XtTranslateCoords(thecaller , relativeX , relativeY , &theX , &theY ) ;


 XtSetArg(topcontrol_arg[0],XtNx, theX) ;
 XtSetArg(topcontrol_arg[1],XtNy, theY) ;
*/
        top_control = XtCreatePopupShell("Displayfac",
                                overrideShellWidgetClass,
                                thecaller,
                                Ruletopcontrol_arg,
                                XtNumber(Ruletopcontrol_arg));

             control = XtCreateManagedWidget("Display",
                                formWidgetClass,
                                top_control,
                                control_arg,
                                XtNumber(control_arg) );

/* TITLE menu option */
 XtSetArg(optiontitle_arg[0],XtNfromVert, NULL ) ;
 XtSetArg(optiontitle_arg[1],XtNfromHoriz, NULL) ;
               option_title = XtCreateManagedWidget("         Graphics Options          ",
                                labelWidgetClass,
                                control,
                                optiontitle_arg,
                                XtNumber(optiontitle_arg) );

/* MAGNIFY menu option */
 XtSetArg(RDPCanycommand_arg[0],XtNfromVert, option_title) ;
 XtSetArg(RDPCanycommand_arg[1],XtNfromHoriz, NULL) ;
               magnify = XtCreateManagedWidget("Magnify",
                                commandWidgetClass,
                                control,
                                RDPCanycommand_arg,
                                XtNumber(RDPCanycommand_arg) );
XtAddCallback(magnify, XtNcallback,
                Magnify_callback, (caddr_t)top_control) ;

/* Set  the argument to pass to the following callback */
/* 1- int[4] thepath */
/* 2- Widget themom which represents the topmenu */
/* 3- Widget themomie which represents LEVEL DISPLAY */
   HairyArg  = ( ForCallback *) calloc(sizeof(ForCallback) , 1) ;

  for ( i = 0 ; i < 4 ; i++)
	{
      HairyArg->thepath[i] = feedpath[i] ;
       } ;
  HairyArg->themom = top_control ;
  HairyArg->themomie = thecaller ; /* the caller is level_display */

 if(!monochrome)
 {
/* COLOURMAP menu option */
 XtSetArg(RDPCanycommand_arg[0],XtNfromVert, magnify) ;
 XtSetArg(RDPCanycommand_arg[1],XtNfromHoriz, NULL) ;
               colourmap = XtCreateManagedWidget("Colour Scale",
                                commandWidgetClass,
                                control,
                                RDPCanycommand_arg,
                                XtNumber(RDPCanycommand_arg) );
XtAddCallback(colourmap, XtNcallback,
                Colourmap_callback, (caddr_t)HairyArg) ;
 }
/* ASSOC COLOUR menu option */
	if(monochrome)
	{
		XtSetArg(RDPCanycommand_arg[0],XtNfromVert, magnify) ;
	}
	else 
	{
		XtSetArg(RDPCanycommand_arg[0],XtNfromVert, colourmap) ;
	}
	XtSetArg(RDPCanycommand_arg[1],XtNfromHoriz, NULL) ;
               colour = XtCreateManagedWidget("Assoc. Colour",
                                commandWidgetClass,
                                control,
                                RDPCanycommand_arg,
                                XtNumber(RDPCanycommand_arg) );

XtAddCallback(colour, XtNcallback, Assoc_Colour_callback, (caddr_t)HairyArg) ;

 
/* THRESHOLD menu option */
/* If PGM running with monochrome option then Treshold Menu Option */
 if (monochrome )
    {
    XtSetArg(RDPCanycommand_arg[0],XtNfromVert, colour) ;
    XtSetArg(RDPCanycommand_arg[1],XtNfromHoriz, NULL) ;
               expand_scale = XtCreateManagedWidget("Threshold",
                                commandWidgetClass,
                                control,
                                RDPCanycommand_arg,
                                XtNumber(RDPCanycommand_arg) );

XtAddCallback(expand_scale, XtNcallback,
                Expand_callback, (caddr_t)HairyArg) ;

    } ;

/* MATRIX DISPLAY menu options */
/* If the level = net => display purposes option is needed */
 if (GiveLevel(feedpath) == 1) 
 {
 if (monochrome)
    {
    XtSetArg(RDPCanycommand_arg[0],XtNfromVert, expand_scale) ;
    XtSetArg(RDPCanycommand_arg[1],XtNfromHoriz, NULL) ;
    } 
 else
    {
    XtSetArg(RDPCanycommand_arg[0],XtNfromVert, colour) ;
    XtSetArg(RDPCanycommand_arg[1],XtNfromHoriz, NULL) ;
    } ;

/* if !matrix display pop up  matrix display */
  if (!ToKnowMatrix(feedpath, thecaller))
     { 
	matrix_help = 1 ;     
               easy_display = XtCreateManagedWidget("Matrix Display",
                                commandWidgetClass,
                                control,
                                RDPCanycommand_arg,
                                XtNumber(RDPCanycommand_arg) );
	XtAddCallback(easy_display, XtNcallback,
                Easy_display_callback, (caddr_t)HairyArg) ;
      }
  else
      {
	matrix_help = 0 ;     
               rem_easy = XtCreateManagedWidget("Linear Display",
                                commandWidgetClass,
                                control,
                                RDPCanycommand_arg,
                                XtNumber(RDPCanycommand_arg) );
	XtAddCallback(rem_easy, XtNcallback,
               Remeasy_callback, (caddr_t)HairyArg) ;
      } ;
/* end of if !matrix */

  } ; 
/* end of if */


/* CONNECTIVITY DISPLAY menu options */
/* If the level = neuron => no interconnectivity is needed */
  if (GiveLevel(feedpath) !=4) 
  {
  if (GiveLevel(feedpath) == 1 )
     {
     if (matrix_help)
        {
        XtSetArg(RDPCanycommand_arg[0],XtNfromVert, easy_display) ;
        }
     else
        {
        XtSetArg(RDPCanycommand_arg[0],XtNfromVert, rem_easy) ;
        }
      }
  else
  {
  if (monochrome)
    {
    XtSetArg(RDPCanycommand_arg[0],XtNfromVert, expand_scale) ;
    }
  else
    {
    XtSetArg(RDPCanycommand_arg[0],XtNfromVert, colour);
    }
  }
	
  XtSetArg(RDPCanycommand_arg[1],XtNfromHoriz, NULL) ;
  select_connect = XtCreateManagedWidget("Connection Display",
      					commandWidgetClass,
                      			control,
                       			RDPCanycommand_arg,
                       			XtNumber(RDPCanycommand_arg) );

  XtAddCallback(select_connect, XtNcallback, 
		Select_callback, (caddr_t)HairyArg) ;
  
	}

/* If the level = neuron => no uninterconnectivity is needed */
  if (GiveLevel(feedpath) !=4) 
   {
  XtSetArg(RDPCanycommand_arg[0],XtNfromVert, select_connect) ;
  XtSetArg(RDPCanycommand_arg[1],XtNfromHoriz, NULL) ;
  unselect_connect= XtCreateManagedWidget("Remove Connection Display",
		commandWidgetClass,
 		control,
       		RDPCanycommand_arg,
       		XtNumber(RDPCanycommand_arg) );

  XtAddCallback(unselect_connect, XtNcallback, 
		Unselect_callback, (caddr_t)HairyArg) ;
  }

/* Add the new action to the action table of ? do not know, yet */
  XtAddActions(displaymenuaction,1) ;
  compiled_displaymenu = XtParseTranslationTable(trans_displaymenu) ;
  XtOverrideTranslations(top_control,compiled_displaymenu ) ;

  command_compiled = XtParseTranslationTable(command_trans) ;
  XtOverrideTranslations(magnify, command_compiled) ;
if(!monochrome)
{
  XtOverrideTranslations(colourmap, command_compiled) ;
}
  XtOverrideTranslations(colour, command_compiled) ;
 if (monochrome)
  XtOverrideTranslations(expand_scale, command_compiled) ;
 if (GiveLevel(feedpath) == 1) 
  {
   if (matrix_help)
  XtOverrideTranslations(easy_display, command_compiled) ;
   else
   XtOverrideTranslations(rem_easy, command_compiled) ;
  } ;
 if (GiveLevel(feedpath) !=4) 
  {
  XtOverrideTranslations(select_connect, command_compiled) ;
  XtOverrideTranslations(unselect_connect, command_compiled) ;
  } ;


/* REALISE */
/*  XtPopup(top_control, XtGrabNone) ;*/
XtRealizeWidget(top_control);
XQueryPointer(XtDisplay(top_control), XtWindow(top_control), &junk_win, &junk_win, &x_root, &y_root, &garbage, &garbage, &garbage_mask);
XtSetArg(Ruletopcontrol_arg[0],XtNx, x_root-20) ;
XtSetArg(Ruletopcontrol_arg[1],XtNy, y_root-20) ;
XtSetValues(top_control, Ruletopcontrol_arg, XtNumber(Ruletopcontrol_arg));
if((DisplayCells(XtDisplay(top_control), DefaultScreen(XtDisplay(top_control)))) > 2)
{
	XSetWindowColormap(XtDisplay(top_control), XtWindow(top_control), pgm_cmap);
}
XtMapWidget(top_control);


/* Change the cursor ; beomes an arrow */
  thedisplay = XtDisplay(control) ;
  thewindow = XtWindow(control) ;
  thecursor = XCreateFontCursor(thedisplay , XC_sb_right_arrow) ;
  XDefineCursor(thedisplay, thewindow , thecursor) ;

}

/*-------------------------------------------------------------*/
/* CREATION OF THE RULES, DISPLAY AND PARAM ACCORDING TO THE SCALE */

void RuleDisplayParam_create(chemin,godfather,godchild)
int *chemin ; /* give the overall path choosen */
Widget godfather, godchild ; /* need godfather as the father */
			     /* need godchild to position the rule */
{

String *trick_path ;

/* to get the path as a param to Display_popup action */
static String *new_trans ;

XtTranslations new_compiled;

/* Declaration of the new action */
static XtActionList popupaction[] = { {"display_popup" , Display_popup } } ;

/* Args for level_rule widget */
	static Arg levelrule_arg[] = {
		{XtNfromVert, (XtArgVal)NULL}, 
 	        {XtNvertDistance, (XtArgVal)1},
/* MIKE CHANGE back and fore */
                {XtNdestroyCallback, (XtArgVal)NULL},
	};

/* Args for level_display widget */
	static Arg leveldisplay_arg[] = {
/*                {XtNcallback, (XtArgVal)leveldisplaycallback}, */
 	        {XtNvertDistance, (XtArgVal)1},
		{XtNfromVert, (XtArgVal)NULL}, 
                {XtNhighlightThickness, (XtArgVal)0},
		{XtNresizable, (XtArgVal)True}, 
		{XtNheight, (XtArgVal)MONITOR_HEIGHT}, 
		{XtNwidth, (XtArgVal)MONITOR_WIDTH},  
/* MIKE CHANGE back and fore */
                {XtNdestroyCallback, (XtArgVal)NULL},
	};

/*------------------------------*/
/* CREATION OF THE RULE_LEVEL   */
/*------------------------------*/
/* Arguments are : path */

 XtSetArg(levelrule_arg[0],XtNfromVert, godchild) ;
	
          level_rule = XtCreateManagedWidget("the rule form",
				formWidgetClass,
				godfather,
				levelrule_arg,
				XtNumber(levelrule_arg)); 

 Rule_create(chemin, level_rule) ; 

/*------------------------------*/
/* CREATION OF THE DISPLAY_LEVEL   */
/*------------------------------*/
/* COMMENTS at the moment level_display is created here but should be created */
/* within Display.c will do when MIKE work is done */

 XtSetArg(leveldisplay_arg[2],XtNfromVert, level_rule) ;
	
          level_display = XtCreateManagedWidget("",
				commandWidgetClass,
				godfather,
				leveldisplay_arg,
				XtNumber(leveldisplay_arg)); 

/*---------------------------------------------*/
/* CREATE THE LEVEL DISPLAY ACCORDING TO MIKE */
/* GIVE THE PATH AND LEVEL_DISPLAY AS AN ARGGUMENT */
  Display_create(chemin , level_display) ;

/*-------------------------------------------*/
/*
 * Filled the family of existing Level window
 * This is for later use
 * 1- to find the level to execute the rules
 * 2- then to give to Mike the order of updating with the widget
 *    concerned (ie the concerned level_display)
 */
/*-------------------------------------------*/
  Filled_family(chemin, level_display) ;

/* Fill the association family */
/* colourmap <=> state  , error , target  default = state */
  FillAssocFamily(chemin , 0 ) ;
/* Fill the threshold family */
  FillThreshold(chemin , 0.5 ) ;


/*-----------------------------------------*/
/* ADD THE NEW TRANSLATION WITHIN THE TABLE TO POP UP MAGNIFY+++ MENU*/
/*-----------------------------------------*/

/* Alocate memory space */
trick_path = (String *) calloc(sizeof(String) , 20) ;
new_trans = (String *) calloc(sizeof(String) , 200) ;

/*set trick path to chemin */
trick_path[0] = chemin[0] ; trick_path[1] = chemin[1] ;
trick_path[2] = chemin[2] ; trick_path[3] = chemin[3] ;

/* Declare the new action which will contains PARAM */
/*      trick_path     */
sprintf(trick_path,"%d %d %d %d",chemin[0],chemin[1],chemin[2],chemin[3] ) ;

sprintf(new_trans , "<Btn1Up>:display_popup(%s)" , trick_path ) ;

 XtAddActions(popupaction,1) ; 
new_compiled = XtParseTranslationTable(new_trans); 
XtOverrideTranslations(level_display, new_compiled); 

/*------------------------------*/
/* CREATION OF THE PARAM LEVEL   */
/*------------------------------*/
 Param_create(chemin, godfather, level_display , level_param) ; 

}
