/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 3/3/90
 *
 * pgm 
 *
 * RuleCreate.c
 ******************************************************************************/

#include "mymonitor.h"
#include "myheader.h"
#include "everything.h"

/*-------------------------------------------------------*/
/* This file creates, dynamically the rule-button-boxes */
/* DYNAMIC = RPC CALL done in LevelRuleCreate.c */
/* and here I got the result of the RPC Call    */
/*-------------------------------------------------------*/
/* COMMENTS = Only "straight" execution is implemented at the moment */
/* RESTRICTIONS = Only 6 rules per line and 12 allowed per level */


#define LENGHT_RULE_NAME 60
#define RULES_PER_LINE  5 
 
/* Declaration of the struct to pass param to each callback */
typedef struct  {
		int rule_number ;
		int rule_path[4] ;
		int thepointer ;  
		char rule_name[60] ;
				 } SCalback;

/*-----------------------------------------------------*/
/* ARGUMENT FOR ANY RULES	*/
/*-----------------------------------------------------*/

/* Args for any rule widget */
	Arg anyrule_arg[] = {
		{XtNfromHoriz, (XtArgVal)NULL},
		{XtNfromVert, (XtArgVal)NULL},
		{XtNhighlightThickness, (XtArgVal)2},
                {XtNdestroyCallback, (XtArgVal)NULL},
		{XtNhorizDistance, (XtArgVal)10},
		{XtNvertDistance, (XtArgVal)8},

/* Test on 21 November */
/* {XtNwidth, (XtArgVal)RULE_WIDTH}, 
   {XtNheight, (XtArgVal)RULE_HEIGHT},  */
	};

/*-----------------------------------------------------*/
/* This function tests if the name given (char[60])    */
/* contains the reserved word "learn" and "recall"     */
/* which indicates that a pattern is needed for the rule*/

 int NameTest(aname)
 char aname[60] ;
 {
 int i ;

 for (i = 0 ; i < LENGHT_RULE_NAME ; i++)
  {
  if (aname[i] == 'l')  
     if (aname[i+1] == 'e')
        if (aname[i+2] == 'a')
           if (aname[i+3] == 'r')
             if (aname[i+4] == 'n')
              return(1) ;
  if (aname[i] == 'r')  
     if (aname[i+1] == 'e')
        if (aname[i+2] == 'c')
           if (aname[i+3] == 'a')
             if (aname[i+4] == 'l')
             if (aname[i+5] == 'l')
              return(2) ;
  } ;
  return(0) ;
 } 

/*-----------------------------------------------------*/
/* CALLBACK FOR SYSTEM , NET , LAYER , CLUSTER , NEURON RULES	*/
/*-----------------------------------------------------*/
/* RESTRICTIONS = The execution of a rule assumes that a pattern */
/* 		  or a file of patterns has been loaded if the   */
/* 		  rule needs it 				 */
/* RESTRICTIONS = to know if a rule needs input pattern I just */
/* check if the name of that rule contains "learn" or "recall" */
/* and ONLY AT SYSTEM and NET LEVEL */

/* The following callbacks control the execution of the rule  */
/* of the NN at any level */

/*-----------------------------------------------------*/
/* EXECUTE System */
/* RESTRICTIONS = to know if a rule needs input pattern I just */
/* check if the name of that rule contains "learn" or "recall" */
  void Execution_system_rule(w, client_data, call_data)
  Widget w;
  SCalback *client_data;  /* pointer to a SCalback structure */
		    /* gives 1- rule-number of the level */
		    /*       2- rule-path = the complete path */
		    /*       3- thepointer = the pointer in "nC memory"*/
  caddr_t call_data;    /* not used */
  {

  if (overallstatus != 'R')
  {
  overallstatus = 'R' ;

/* the following has NEVER BEEN TESTED */
/* if rule = learn or recall then ask pattern */
  if ( NameTest(client_data->rule_name) == 1 )  /* learn */
   {
         overallstatus = 'R' ;
         ExecWithPattern(w , client_data->thepointer ,
                             client_data->rule_path  ,
                         1) ;
/* Now done in the Exec function  overallstatus = 'S' ;   */
   }
  else
   {
     if ( NameTest(client_data->rule_name) == 2 )  /* recall*/
     {
            overallstatus = 'R' ;
            ExecWithPattern(w , client_data->thepointer ,
                             client_data->rule_path  ,
                            0) ;
/* Now done in the Exec function  overallstatus = 'S' ;   */
      }
     else
      {
       overallstatus = 'R' ;
       MagaliExecute(client_data->thepointer) ;
/* After execution call UpdateLevelWindow to call MIKE REFRESH */
       UpdateLevelWindow(client_data->rule_path , 1) ;
       UpdateParamWindow(client_data->rule_path) ;
       overallstatus = 'S' ;
       } ;
    } ;
   }
/* end of if overallstatus */
   else Error(6) ;

  }


/*-----------------------------------------------------*/
/*EXECUTE Net */
/* RESTRICTIONS = to know if a rule needs input pattern I just */
/* check if the name of that rule contains "learn" or "recall" */
  void Execution_net_rule(w, client_data, call_data)
  Widget w;
  SCalback *client_data;  /* pointer to a SCalback structure */
  		    /* gives 1- rule-number of the level */
		    /*       2- rule-path = the complete path */
		    /*       3- thepointer = the pointer in "nC memory"*/
  caddr_t call_data;    /* not used */
  {
  int i , total ;
  Display *stupid_display ; 

  if (overallstatus != 'R')
  {
  overallstatus = 'R' ;

/* if rule = learn or recall then ask pattern */

  if ( NameTest(client_data->rule_name) == 1 )  /* learn */
   {  
         overallstatus = 'R' ;
         ExecWithPattern(w , client_data->thepointer , 
			     client_data->rule_path  ,
			 1) ; 
/* Now done in the Exec function  overallstatus = 'S' ;   */
   }  
  else 
   {
     if ( NameTest(client_data->rule_name) == 2 )  /* recall*/
     {  
            overallstatus = 'R' ;
            ExecWithPattern(w , client_data->thepointer , 
			     client_data->rule_path  ,
			    0) ; 
/* Now done in the Exec function  overallstatus = 'S' ;   */
      }
     else
      {  
       overallstatus = 'R' ;
       MagaliExecute(client_data->thepointer) ;
/* After execution call UpdateLevelWindow to call MIKE REFRESH */
       UpdateLevelWindow(client_data->rule_path , 1) ;
       UpdateParamWindow(client_data->rule_path) ;
       overallstatus = 'S' ;
       } ;
    } ;
   }  
/* end of if overallstatus */
   else Error(6) ; 

  }

/*EXECUTE Layer */
  void Execution_layer_rule(w, client_data, call_data)
  Widget w;
  SCalback *client_data;  /* pointer to a SCalback structure */
		    /* gives 1- rule-number of the level */
		    /*       2- rule-path = the complete path */
		    /*       3- thepointer = the pointer in "nC memory"*/
  caddr_t call_data;    /* not used */
  {

	if (overallstatus != 'R')
                {
	overallstatus = 'R' ;
        MagaliExecute(client_data->thepointer) ;
/* After execution call UpdateLevelWindow to call MIKE REFRESH */
        UpdateLevelWindow(client_data->rule_path , 1) ;
        UpdateParamWindow(client_data->rule_path) ;
	overallstatus = 'S' ;
		} 
	else Error(6) ;

  }

/* EXECUTE Cluster */
  void Execution_cluster_rule(w, client_data, call_data)
  Widget w;
  SCalback *client_data;  /* pointer to a SCalback structure */
		    /* gives 1- rule-number of the level */
		    /*       2- rule-path = the complete path */
		    /*       3- thepointer = the pointer in "nC memory"*/
  caddr_t call_data;    /* not used */
  {

	if (overallstatus != 'R')
                {
	overallstatus = 'R' ;
        MagaliExecute(client_data->thepointer) ;
/* After execution call UpdateLevelWindow to call MIKE REFRESH */
        UpdateLevelWindow(client_data->rule_path , 1) ;
        UpdateParamWindow(client_data->rule_path) ;
	overallstatus = 'S' ;
		} 
	else Error(6) ;

  }

/* EXECUTE Neuron */
  void Execution_neuron_rule(w, client_data, call_data)
  Widget w;
  SCalback *client_data;  /* pointer to a SCalback structure */
		    /* gives 1- rule-number of the level */
		    /*       2- rule-path = the complete path */
		    /*       3- thepointer = the pointer in "nC memory"*/
  caddr_t call_data;    /* not used */
  {

	if (overallstatus != 'R')
                {
	overallstatus = 'R' ;
        MagaliExecute(client_data->thepointer) ;
/* After execution call UpdateLevelWindow to call MIKE REFRESH */
        UpdateLevelWindow(client_data->rule_path , 1) ;
        UpdateParamWindow(client_data->rule_path) ;
	overallstatus = 'S' ;
		} 
	else Error(6) ;

  }
/*----------------------------------------------------*/
/*----------------------------------------------------*/
/* THE PROCEDURES SYSTEM_CREATE 			*/
/* 		  NET_CREATE	 			*/
/* 		  LAYER_CREATE 				*/
/* 		  CLUSTER_CREATE 			*/
/* 		  NEURON_CREATE 			*/
/*----------------------------------------------------*/

/*COMMENT=Tuesday 24 October Changes of the structure that the RPC gives back*/
/* It nows contains the name (as previously) AND THE RULE POINTER */
/* That rule pointer will be sent back when Execution is called */
/* This is a "hacky" way i.e. to pass a pointer to a memory space unknown */
/* by the PGM but it is the only way at the moment */
/* More => If the type of pointer was correct then the pointer passed by RPC */
/* would have been re-referenciated in order to "truly" point somewhere */
/* But because of stupid C, where int = pointer you can not be elegant */
/*----------------------------------------------------*/
/* 		SYSTEM_CREATE 			*/

  void System_create(theparent, rule_info)
  Widget theparent ; /* the widget is the level_rule created in Rule_create.c */
  fnarray *rule_info;
  {
  Widget /* level_rule ie theparent */
	 	*any_rule  , stupid ; 

  int counter , other ;
extern Arg anyrule_arg[6];

/* to give as callback argument = path + rule_number */
  SCalback **CalArgument ;

/* If no rule create a fake one */
  if (rule_info->fnarray_len == 0)
    { 
    XtSetArg(anyrule_arg[0],XtNfromHoriz, NULL) ; 
    XtSetArg(anyrule_arg[1],XtNfromVert, NULL) ; 
    stupid =  XtCreateManagedWidget("No Rules at this level",
                                commandWidgetClass,
                                theparent,
                                anyrule_arg,
                                XtNumber(anyrule_arg));
    XtSetArg(anyrule_arg[6],XtNwidth, RULE_WIDTH) ; 
    return ;
    } ;

/* otherwise rules exist create button-rules and their callback */

/* Allocation fo the memory space 1- for the widgets */
/*              2- for the pointer to SCalback */
  any_rule = (Widget *) calloc(sizeof(Widget), rule_info->fnarray_len);
  CalArgument= (SCalback **) calloc(sizeof(SCalback *),rule_info->fnarray_len);
  for ( counter = 0 ; counter < rule_info->fnarray_len ; counter++ )
    CalArgument[counter] = ( SCalback *) calloc(sizeof(SCalback) , 1) ;

/* initialise path for the call back here all to -1 => system */
 for ( other = 0 ; other < rule_info->fnarray_len ; other++ )
  for ( counter = 0 ; counter < 4 ; counter++ )
    CalArgument[other]->rule_path[counter] = -1 ;

/* Creation of the button rules widget + callback and arg */
for (counter = 0 ; counter < rule_info->fnarray_len; counter++ )
      {

/* position correctly the rule button boxes */
      if (counter <= RULES_PER_LINE)
         {
        XtSetArg(anyrule_arg[1],XtNfromVert, NULL) ;
	if (counter >= 1) 
          XtSetArg(anyrule_arg[0],XtNfromHoriz, any_rule[counter-1]) ; 
	else 
           XtSetArg(anyrule_arg[0],XtNfromHoriz, NULL) ; 
         }
      else
	 {
       XtSetArg(anyrule_arg[1],XtNfromVert, 
		any_rule[counter - RULES_PER_LINE -1]) ;
/* does not work at the moment => Russian approach */
       if (counter == 6 || counter == 11)
            XtSetArg(anyrule_arg[0],XtNfromHoriz, NULL)  ;
       else
           XtSetArg(anyrule_arg[0],XtNfromHoriz, any_rule[counter-1])  ;
       };
         
      

/* changes [counter] BECOMES [counter].rule_name */
any_rule[counter] = XtCreateManagedWidget(
                             rule_info->fnarray_val[counter].rule_name,
			     commandWidgetClass,
			     theparent,
			     anyrule_arg,
			     XtNumber(anyrule_arg));

	CalArgument[counter]->rule_number = counter ;
        CalArgument[counter]->thepointer = 
                  rule_info->fnarray_val[counter].rule_pointer;
        strcpy( CalArgument[counter]->rule_name ,
                  rule_info->fnarray_val[counter].rule_name) ;

	XtAddCallback(any_rule[counter], XtNcallback,
                Execution_system_rule, (caddr_t)CalArgument[counter]) ;

	}  ;
 
}

/*----------------------------------------------------*/
/* 		NET_CREATE 			*/
/* NET LEVEL ONLY Friday test for the number of rules */

void Net_create(theparent , netpath , rule_info)
Widget theparent ; /* the widget is the level_rule created in Rule_create.c */
int netpath[] ;
fnarray *rule_info ;
{
Widget /* level_rule ie theparent */
	 	*any_rule , stupid ; 

  int counter  , other ;
extern Arg anyrule_arg[6];

  SCalback **toknow  ;

/* If no rule create a fake one */
  if (rule_info->fnarray_len == 0)
    { 
    XtSetArg(anyrule_arg[0],XtNfromHoriz, NULL) ; 
    XtSetArg(anyrule_arg[1],XtNfromVert, NULL) ; 
    stupid =  XtCreateManagedWidget("No Rules at this level",
                                commandWidgetClass,
                                theparent,
                                anyrule_arg,
                                XtNumber(anyrule_arg));
    return ;
    } ;
 
/* Allocation fo the memory space 1- for the widgets */
/* 		2- for the pointer to SCalback */ 
  any_rule = (Widget *) calloc(sizeof(Widget), rule_info->fnarray_len);
  
   toknow = (SCalback **) calloc(sizeof(SCalback *) , rule_info->fnarray_len) ;

   for ( counter = 0 ; counter < rule_info->fnarray_len ; counter++ ) 
   toknow[counter] = ( SCalback *) calloc(sizeof(SCalback) , 1) ;


/* initialise path for the call back */
 for ( other = 0 ; other < rule_info->fnarray_len ; other++ ) 
 for ( counter = 0 ; counter < 4 ; counter++ ) 
  toknow[other]->rule_path[counter] = netpath[counter] ;

/* Creation of the button rules widget + callback and arg */
  for (counter = 0 ; counter < rule_info->fnarray_len ; counter++ )
      {

/* position correctly the rule button boxes */
    if ( counter <= RULES_PER_LINE )
      {
        XtSetArg(anyrule_arg[1],XtNfromVert, NULL) ;
         if (counter  == 0) 
          {
           XtSetArg(anyrule_arg[0],XtNfromHoriz, NULL)  ;
          } 
         else
           XtSetArg(anyrule_arg[0],XtNfromHoriz, any_rule[counter-1])  ;
       }
    else
      {
       XtSetArg(anyrule_arg[1],XtNfromVert, 
		any_rule[counter - RULES_PER_LINE -1]) ;
/* does not work at the moment => Russian approach */
       if (counter == 6 || counter == 11)
            XtSetArg(anyrule_arg[0],XtNfromHoriz, NULL)  ;
       else
           XtSetArg(anyrule_arg[0],XtNfromHoriz, any_rule[counter-1])  ;
       };
	      

/* changes [counter] BECOMES [counter].rule_name */
   any_rule[counter] = XtCreateManagedWidget(
                             rule_info->fnarray_val[counter].rule_name,
				commandWidgetClass,
				theparent,
				anyrule_arg,
				XtNumber(anyrule_arg));

	toknow[counter]->rule_number = counter ;
	toknow[counter]->thepointer = 
                  rule_info->fnarray_val[counter].rule_pointer;
        strcpy ( toknow[counter]->rule_name ,  
                  rule_info->fnarray_val[counter].rule_name) ; 

	XtAddCallback(any_rule[counter], XtNcallback,
                Execution_net_rule, (caddr_t)toknow[counter]) ;

	}  ;
}

/*----------------------------------------------------*/
/* 		LAYER_CREATE 			*/

void Layer_create(theparent , layerpath , rule_info)
Widget theparent ; /* the widget is the level_rule created in Rule_create.c */
int layerpath[] ;
fnarray *rule_info;
{
Widget /* level_rule ie theparent */
	 	*any_rule , stupid ; 
extern Arg anyrule_arg[6];

int counter ;
int other ;

SCalback **CalArgument ;

/* If no rule create a stupid one */
if (rule_info->fnarray_len == 0)
    { 
    XtSetArg(anyrule_arg[0],XtNfromHoriz, NULL) ; 
    XtSetArg(anyrule_arg[1],XtNfromVert, NULL) ; 
    stupid =  XtCreateManagedWidget("No Rules at this level",
                                commandWidgetClass,
                                theparent,
                                anyrule_arg,
                                XtNumber(anyrule_arg));
    return ;
    } ;

/* otherwise rules exist create button-rules and their callback */

/* Allocation fo the memory space 1- for the widgets */
/*              2- for the pointer to SCalback */
  any_rule = (Widget *) calloc(sizeof(Widget), rule_info->fnarray_len);
  CalArgument= (SCalback **) calloc(sizeof(SCalback *),rule_info->fnarray_len);
  for ( counter = 0 ; counter < rule_info->fnarray_len ; counter++ )
   CalArgument[counter] = ( SCalback *) calloc(sizeof(SCalback) , 1) ;


/* initialise path for the call back here => layerpath */
 for ( other = 0 ; other < rule_info->fnarray_len ; other++ )
 for ( counter = 0 ; counter < 4 ; counter++ )
  CalArgument[other]->rule_path[counter] = layerpath[counter] ;
  any_rule = (Widget *) calloc(sizeof(Widget), rule_info->fnarray_len);


for (counter = 0 ; counter < rule_info->fnarray_len; counter++ )
      {

/* position correctly the rule button boxes */
    if ( counter <= RULES_PER_LINE )
      {
        XtSetArg(anyrule_arg[1],XtNfromVert, NULL) ;
         if (counter  == 0) 
          {
           XtSetArg(anyrule_arg[0],XtNfromHoriz, NULL)  ;
          } 
         else
           XtSetArg(anyrule_arg[0],XtNfromHoriz, any_rule[counter-1])  ;
       }
    else
      {
       XtSetArg(anyrule_arg[1],XtNfromVert, 
		any_rule[counter - RULES_PER_LINE -1]) ;
/* does not work at the moment => Russian approach */
       if (counter == 6 || counter == 11)
            XtSetArg(anyrule_arg[0],XtNfromHoriz, NULL)  ;
       else
           XtSetArg(anyrule_arg[0],XtNfromHoriz, any_rule[counter-1])  ;
       };

/* changes [counter] BECOMES [counter].rule_name */
     any_rule[counter] = XtCreateManagedWidget(
                             rule_info->fnarray_val[counter].rule_name,
				commandWidgetClass,
				theparent,
				anyrule_arg,
				XtNumber(anyrule_arg));

	CalArgument[counter]->rule_number = counter ;
	CalArgument[counter]->thepointer = 
                  rule_info->fnarray_val[counter].rule_pointer;
        strcpy( CalArgument[counter]->rule_name , 
                  rule_info->fnarray_val[counter].rule_name) ;

	XtAddCallback(any_rule[counter], XtNcallback,
                Execution_layer_rule, (caddr_t)CalArgument[counter]) ;

      }  ;
}


/*----------------------------------------------------*/
/* 		CLUSTER_CREATE 			*/

void Cluster_create(theparent , clusterpath , rule_info)
Widget theparent ; /* the widget is the level_rule created in Rule_create.c */
int clusterpath[] ;
fnarray *rule_info ;

{
Widget /* level_rule ie theparent */
	 	*any_rule , stupid ; 

extern Arg anyrule_arg[6];
int counter , other ;

/* to give as callback argument = path + rule_number */
SCalback **CalArgument ;

/* If no rule create a stupid one */
if (rule_info->fnarray_len == 0)
    { 
    XtSetArg(anyrule_arg[0],XtNfromHoriz, NULL) ; 
    XtSetArg(anyrule_arg[1],XtNfromVert, NULL) ; 
    stupid =  XtCreateManagedWidget("No Rules at this level",
                                commandWidgetClass,
                                theparent,
                                anyrule_arg,
                                XtNumber(anyrule_arg));
    return ;
    } ;
 

/* otherwise rules exist create button-rules and their callback */
/* Allocation fo the memory space 1- for the widgets */
/*              2- for the pointer to SCalback */
  any_rule = (Widget *) calloc(sizeof(Widget), rule_info->fnarray_len);

  CalArgument= (SCalback **) calloc(sizeof(SCalback *),rule_info->fnarray_len);

  for ( counter = 0 ; counter < rule_info->fnarray_len ; counter++ )
   CalArgument[counter] = ( SCalback *) calloc(sizeof(SCalback) , 1) ;


/* initialise path for the call back here all to => clusterpath */
 for ( other = 0 ; other < rule_info->fnarray_len ; other++ )
 for ( counter = 0 ; counter < 4 ; counter++ )
  CalArgument[other]->rule_path[counter] = clusterpath[counter] ;
any_rule = (Widget *) calloc(sizeof(Widget), rule_info->fnarray_len);


for (counter = 0 ; counter < rule_info->fnarray_len ; counter++ )
      {

/* position correctly the rule button boxes */
    if ( counter <= RULES_PER_LINE )
      {
        XtSetArg(anyrule_arg[1],XtNfromVert, NULL) ;
         if (counter  == 0) 
          {
           XtSetArg(anyrule_arg[0],XtNfromHoriz, NULL)  ;
          } 
         else
           XtSetArg(anyrule_arg[0],XtNfromHoriz, any_rule[counter-1])  ;
       }
    else
      {
       XtSetArg(anyrule_arg[1],XtNfromVert, 
		any_rule[counter - RULES_PER_LINE -1]) ;
/* does not work at the moment => Russian approach */
       if (counter == 6 || counter == 11)
            XtSetArg(anyrule_arg[0],XtNfromHoriz, NULL)  ;
       else
           XtSetArg(anyrule_arg[0],XtNfromHoriz, any_rule[counter-1])  ;
       };

/* changes [counter] BECOMES [counter].rule_name */
	any_rule[counter] = XtCreateManagedWidget(
                             rule_info->fnarray_val[counter].rule_name,
				commandWidgetClass,
				theparent,
				anyrule_arg,
				XtNumber(anyrule_arg));

	CalArgument[counter]->rule_number = counter ;
	CalArgument[counter]->thepointer = 
                  rule_info->fnarray_val[counter].rule_pointer;
        strcpy( CalArgument[counter]->rule_name , 
                  rule_info->fnarray_val[counter].rule_name) ;

	XtAddCallback(any_rule[counter], XtNcallback,
                Execution_cluster_rule, (caddr_t)CalArgument[counter]) ;

	}  ;

}


/*----------------------------------------------------*/
/* 		NEURON_CREATE 			*/

void Neuron_create(theparent , neuronpath , rule_info)
Widget theparent ; /* the widget is the level_rule created in Rule_create.c */
int neuronpath[] ;
fnarray *rule_info;
{
Widget /* level_rule ie theparent */
	 	*any_rule , stupid ; 

extern Arg anyrule_arg[6];
int counter , other ;

SCalback **CalArgument ;

/* If no rule create a fake one */
if (rule_info->fnarray_len == 0)
    { 
    XtSetArg(anyrule_arg[0],XtNfromHoriz, NULL) ; 
    XtSetArg(anyrule_arg[1],XtNfromVert, NULL) ; 
    stupid =  XtCreateManagedWidget("No Rules at this level",
                                commandWidgetClass,
                                theparent,
                                anyrule_arg,
                                XtNumber(anyrule_arg));
    return ;
    } ;

/* otherwise rules exist create button-rules and their callback */

/* Allocation fo the memory space 1- for the widgets */
/*              2- for the pointer to SCalback */
  any_rule = (Widget *) calloc(sizeof(Widget), rule_info->fnarray_len);

  CalArgument= (SCalback **) calloc(sizeof(SCalback *),rule_info->fnarray_len);

  for ( counter = 0 ; counter < rule_info->fnarray_len ; counter++ )
   CalArgument[counter] = ( SCalback *) calloc(sizeof(SCalback) , 1) ;


/* initialise path for the call back here to => neuronpath  */
 for ( other = 0 ; other < rule_info->fnarray_len ; other++ )
 for ( counter = 0 ; counter < 4 ; counter++ )
  CalArgument[other]->rule_path[counter] = neuronpath[counter] ;


for (counter = 0 ; counter < rule_info->fnarray_len; counter++ )
      {

/* position correctly the rule button boxes */
    if ( counter <= RULES_PER_LINE )
      {
        XtSetArg(anyrule_arg[1],XtNfromVert, NULL) ;
         if (counter  == 0) 
          {
           XtSetArg(anyrule_arg[0],XtNfromHoriz, NULL)  ;
          } 
         else
           XtSetArg(anyrule_arg[0],XtNfromHoriz, any_rule[counter-1])  ;
       }
    else
      {
       XtSetArg(anyrule_arg[1],XtNfromVert, 
		any_rule[counter - RULES_PER_LINE -1]) ;
/* does not work at the moment => Russian approach */
       if (counter == 6 || counter == 11)
            XtSetArg(anyrule_arg[0],XtNfromHoriz, NULL)  ;
       else
           XtSetArg(anyrule_arg[0],XtNfromHoriz, any_rule[counter-1])  ;
       };

/* changes [counter] BECOMES [counter].rule_name */
   any_rule[counter] = XtCreateManagedWidget(
                             rule_info->fnarray_val[counter].rule_name,
				commandWidgetClass,
				theparent,
				anyrule_arg,
				XtNumber(anyrule_arg));

	CalArgument[counter]->rule_number = counter ;
	CalArgument[counter]->thepointer = 
                  rule_info->fnarray_val[counter].rule_pointer;
        strcpy( CalArgument[counter]->rule_name , 
                  rule_info->fnarray_val[counter].rule_name) ;

	XtAddCallback(any_rule[counter], XtNcallback,
                Execution_neuron_rule, (caddr_t)CalArgument[counter]) ;

	}  ;
}
