/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 3/3/90
 *
 * pgm 
 *
 * Pgmtarget_control.c
 ******************************************************************************/

#include "everything.h"
#include "myheader.h" 

/*----------------------------------------------*/
/* THIS PROC DEALS WITH                         */
/*      1- target button                        */
/*      2- The effect = server name, server exec*/
/*----------------------------------------------*/

/*----------------------------------------------*/
/* EXTERN for the 1- father widget		*/
/* 	          2- neighbour(s) within the form	*/
/* 		  3- the created widget itself 	*/
/*				REALSELECT         */
extern Widget simulation ;
extern Widget highlevel;
extern Widget pgmtarget;


/*----------------------------------------------*/
/* CALL BACK FOR THE COMMAND "Target Machine"  */
/*---------------------------------------------*/
  void Targetmachine_callback(initiateur, client_data, call_data)
  Widget initiateur;
  caddr_t client_data;  /* the select button widget */
  caddr_t call_data;     /* not used  */
  {

  Take_input(initiateur, 4) ;
  
  }

/*----------------------------------------------
 * CREATION OF THE TARGET command widget (proc name= Pgmtarget)
 * MAIN FUNCTION = Button1 Press causes the pop up of a menu 
/*----------------------------------------------*/

/*-----------------------------------------------------*/
/* ARGUMENTS FOR TARGET widget				*/
/*-----------------------------------------------------*/

/* Args for target widget */
        static Arg pgmtarget_arg[] = {
                {XtNcallback, (XtArgVal)NULL},
                {XtNhighlightThickness, (XtArgVal)3},
/* MIKE CHANGE for foreground */
                {XtNdestroyCallback, (XtArgVal)NULL},
                {XtNfromVert, (XtArgVal)NULL},
                {XtNvertDistance, (XtArgVal)2},
                {XtNfromHoriz, (XtArgVal)NULL},
                {XtNhorizDistance, (XtArgVal) DISTANCE_HORIZ},
                {XtNwidth, (XtArgVal)BUTTON_WIDTH},
                {XtNheight, (XtArgVal)BUTTON_HEIGHT},
        };

/*-----------------------------------------------------*/
/* CREATION OF THE CREATE BUTTON 			*/
/*-----------------------------------------------------*/

void Target()
{

/* BTN1UP = DEFAULT + RESET otherwise does not unhighlight */
/* Declaration of the translation table for init */
  static String menu_trans = "<Btn1Up>: notify() unset() reset()" ;
  XtTranslations menu_compiled ;


 XtSetArg(pgmtarget_arg[3],XtNfromVert , highlevel) ;
 XtSetArg(pgmtarget_arg[5],XtNfromHoriz , NULL) ;

        pgmtarget = XtCreateManagedWidget(" Target ",
                                commandWidgetClass,
                                simulation,
                                pgmtarget_arg,
                                XtNumber(pgmtarget_arg));

/* Compilation of the translation table for select */
  menu_compiled = XtParseTranslationTable(menu_trans) ;
  XtOverrideTranslations(pgmtarget, menu_compiled) ;


/* "Compile" the call back */
XtAddCallback(pgmtarget, XtNcallback,
        Targetmachine_callback,(caddr_t)pgmtarget) ;

} 
