/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 3/3/90
 *
 * pgm 
 *
 * ParamFamilyFilled.c
 ******************************************************************************/

#include "myheader.h"
#include "mymonitor.h"

/* CAUTION => This DEFINE should be the one in FamilyFilled,c */
#define MAX_CAUTION_WIDGET 25 
		/* maximum number of level window which can be open */

/*----------------------------------------------------*/
/* THESES PROC TAKE CARE ABOUT THE FAMILY OF PARAM WIDGET TO */
/* UPDATE DURING THE EXECUTION                        */
/* 1- FilledParamFamily => updates the family of opened Param Windows */
/* 2- CloseParam  => deletes from theparamfamily the one which has been closed */
/* 3- UpdateParamWindow => finds the param window to update and sends orders */ 
/*----------------------------------------------------*/

typedef Widget *widgetset ;
typedef struct 
	{
	 int assoc_path[4] ;     /* should contain the path of the widget */
         widgetset  assocwidget ; /* should contain the set of widget id associated */
         int param_number ;      /* should contain the number of param at this level */
        } FamilyParam ;


 FamilyParam theparamfamily[MAX_CAUTION_WIDGET] ;

/* Set theparam family */

  void SetParamFamily() 
  {
  int wid ;
  int counter ;
  param_session = 1 ;
  for ( wid = 0 ; wid < MAX_CAUTION_WIDGET ; wid++) 
       for (counter = 0 ; counter < 4 ; counter++)
        theparamfamily[wid].assoc_path[counter] = -2 ;

  }

/*----------------------------------------*/
/* THIS PROC filled the array of existing level windows */

  void FillParamFamily(a_path , a_number, param_widgets) 
  int a_path[4] ;
  int a_number ;   /* number of param for that widget */
  Widget *param_widgets ;  /* the set of param widget id */
  {
  int wid , counter ;
  
  if (!param_session) SetParamFamily() ; 

/* Assign to a path and a widget the first non-assignided element of */
/* thefamily array */

  for ( wid = 0 ; wid < MAX_CAUTION_WIDGET ; wid++) 
     if (theparamfamily[wid].assoc_path[0] == -2  )
	{
        theparamfamily[wid].param_number = a_number ;

/* alloc the set of param widget */
        theparamfamily[wid].assocwidget = 
		(Widget *) calloc (sizeof(Widget) , a_number) ;
/* assign them */
       for (counter = 0 ; counter < a_number ; counter++)
        theparamfamily[wid].assocwidget[counter] = param_widgets[counter] ;

        for (counter = 0 ; counter < 4 ; counter++) 
          {
	  theparamfamily[wid].assoc_path[counter] = a_path[counter] ;
          } ;
        return ; /* get out of the for loop */
 	} ;	
   }


/*----------------------------------------*/
/* THIS PROC deletes from thefamily  the one which has just been closed */
/* PRBE => ADD THEE WIDGET ID COZ TWO WINDOW CAN HAVE THE SAME PATH */
  void CloseParamFamily(a_path) 
  int a_path[4] ;
  {
  int wid_nbe , compo ;
  int i , end ;

/* find the entry to be deleted */
for (wid_nbe = 0 ; wid_nbe < MAX_CAUTION_WIDGET ; wid_nbe++)
 {
 if (
theparamfamily[wid_nbe].assoc_path[0] == a_path[0]  
 &&
theparamfamily[wid_nbe].assoc_path[1]  == a_path[1] 
 && 
theparamfamily[wid_nbe].assoc_path[2] == a_path[2]  
 && 
theparamfamily[wid_nbe].assoc_path[3] == a_path[3]
   )
    end = wid_nbe ;
 }
/* Delete one entry => shift the array */
  for (wid_nbe = end +1 ; wid_nbe < MAX_CAUTION_WIDGET ; wid_nbe++)
   {
/* PROBLEM How to shift the widget id which does not have the same size */
   theparamfamily[wid_nbe -1].assocwidget = 
    theparamfamily[wid_nbe ].assocwidget  ;

/* shift param number */
   theparamfamily[wid_nbe -1].param_number = 
		theparamfamily[wid_nbe].param_number ;

/* shift the paths */
  for (i = 0 ; i < 4 ; i++ )
   theparamfamily[wid_nbe -1].assoc_path[i] =  
      theparamfamily[wid_nbe].assoc_path[i]  ;
  }

 }


/*----------------------------------------*/
/* THIS PROC according to a path              */
/*      1- Update all ParamWindow            */

  void UpdateParamWindow(a_path) 
  int a_path[4] ; /* this is the path where the rule has been called from */
  {
  int wid_nbe , counter ;
  Widget voisin ;

/* For all Widgets */
for (wid_nbe = 0 ; wid_nbe < MAX_CAUTION_WIDGET ; wid_nbe++)
    {
/* if they have been assign ie there is param window */
    if (theparamfamily[wid_nbe].assoc_path[0] != -2 )
     {
/* For every param widget of that entry */
      NEWGetUse_param(
  		    theparamfamily[wid_nbe].assoc_path,
  		    theparamfamily[wid_nbe].param_number 
		  ) ;
       } ;
     } ;
 
   }

  void GiveWidgetId(a_path , theindex , widgetid) 
  int a_path[4] ; /* this is the path where the rule has been called from */
  int theindex ;
  Widget *widgetid ;
  {
  int wid_nbe , counter ;
  Widget voisin ;

/* For all Widgets */
for (wid_nbe = 0 ; wid_nbe < MAX_CAUTION_WIDGET ; wid_nbe++)
    {
    if ( (theparamfamily[wid_nbe].assoc_path[0] == a_path[0] ) && 
         (theparamfamily[wid_nbe].assoc_path[1] == a_path[1] ) && 
         (theparamfamily[wid_nbe].assoc_path[2] == a_path[2] ) && 
         (theparamfamily[wid_nbe].assoc_path[3] == a_path[3] )  
       )
       *widgetid = theparamfamily[wid_nbe].assocwidget[theindex]  ;

    } ;
 
}
