/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 3/3/90
 *
 * pgm 
 *
 * ParamCreate.c
 ******************************************************************************/

#include "mymonitor.h"
#include "everything.h"


/*-----------------------------------------------------*/
/* This file creates, dynamically A param button boxe associated */
/* with each level  */
/* DYNAMIC = RPC CALL done in LevelParamCreate.c */
/* and here I got the result of the RPC Call */
/*-----------------------------------------------------*/
/* BACK ON TUESDAY 31 OCTOBER */
/* I do not need the following callbacks but can be usefull for recording */
/* purposes */

#define PARAMS_PER_LINE 3 

/*-----------------------------------------------------*/
/* ARGUMENT FOR  ANY  PARAM WIDGET			*/
/*-----------------------------------------------------*/
/* CAUTION => NO MORE STATIC ; SEE FILE GetUseParam.c */
/* Args for command widget */
	Arg anyparam_arg[] = {
		{XtNfromVert, (XtArgVal)NULL},
		{XtNfromHoriz, (XtArgVal)NULL},
		{XtNlabel, (XtArgVal)NULL}, 
		{XtNvertDistance, (XtArgVal)8},
		{XtNhorizDistance, (XtArgVal)10},
/* test on the 20 November */
/* {XtNwidth, (XtArgVal)TEXT_WIDTH}, 
   {XtNheight, (XtArgVal)PARAM_HEIGHT},  */
		{XtNresize, (XtArgVal)False}, 
	};

/* Declaration of the struct to pass param to each callback */
typedef struct  {
                int param_index ;  /* index of the param within  */
				   /* the array of parameters */
                int param_path[4] ;
                Widget param_voisin  ;
                                 } ParamCallback;

/*----------------------------------------------------*/
/* CALLBACK FOR SYSTEM , NET , LAYER , CLUSTER AND NEURON */
/*----------------------------------------------------*/
/* ASK SYSTEM */
  void Ask_system_param(w, client_data, call_data)
  Widget w;   /* no use */
  ParamCallback *client_data;  /* pointer to a structure */
                    /* gives 1- index of the concerned param */
                    /*       2- param-path = the complete path */
  caddr_t call_data;    /* not used */
  {
	Error(300) ;
  }

/* ASK NET */
  void Ask_net_param(w, client_data, call_data)
  Widget w;   /* w is the widget where to change display */
  ParamCallback *client_data;  /* pointer to a structure */
                    /* gives 1- index of the concerned param */
                    /*       2- param-path = the complete path */
  caddr_t call_data;    /* not used */
  {
/*        printf("The user ask to record param IN NET \n" );
 *        printf("The index is %i" , client_data->param_index);
 *        printf("The PARAM path is %i %i %i %i\n" , 
 *		client_data->param_path[0] , client_data->param_path[1] , 
 *		client_data->param_path[2] , client_data->param_path[3] );
 */
	Error(301) ;
  }

/* ASK LAYER */
  void Ask_layer_param(w, client_data, call_data)
  Widget w;   /* w is the widget where to change display */
  ParamCallback *client_data;  /* pointer to a structure */
                    /* gives 1- index of the concerned param */
                    /*       2- param-path = the complete path */
  caddr_t call_data;    /* not used */
  {
	Error(302) ;
  }

/* ASK CLUSTER */
  void Ask_cluster_param(w, client_data, call_data)
  Widget w;   /* w is the widget where to change display */
  ParamCallback *client_data;  /* pointer to a structure */
                    /* gives 1- index of the concerned param */
                    /*       2- param-path = the complete path */
  caddr_t call_data;    /* not used */
  {
	Error(303) ;
  }

/* ASK  NEURON */
  void Ask_neuron_param(w, client_data, call_data)
  Widget w;   /* w is the widget where to change display */
  ParamCallback *client_data;  /* pointer to a structure */
                    /* gives 1- index of the concerned param */
                    /*       2- param-path = the complete path */
  caddr_t call_data;    /* not used */
  {
	Error(304) ;
  }

/*----------------------------------------------------*/
/*----------------------------------------------------*/
/* PROCEDURES <LEVEL>_PARAM (  PARENT )       */
/*----------------------------------------------------*/

/*----------------------------------------------------*/
/* 		SYSTEM PARAMETERS			*/

  void System_param(thepapa , param_info )
  Widget thepapa ;
  iarray *param_info ;

  {
  Widget /* level_param is the parent */
	*any_param , stupid ;

  String *trick ;
  int counter , another ;

  ParamCallback **toyou ;
  
  
/* If no params create a stupid one */
  if (param_info->iarray_len == 0)
    {
    XtSetArg(anyparam_arg[0],XtNfromVert, NULL) ;
    XtSetArg(anyparam_arg[1],XtNfromHoriz, NULL) ;
    stupid =  XtCreateManagedWidget("No User Parameter at this level",
                                commandWidgetClass,
                                thepapa,
                                anyparam_arg,
                                XtNumber(anyparam_arg));
    return ;
    } ;

/* otherwise there is parameters */

/* Allocation of space for the widget */
  any_param = (Widget *) calloc(sizeof(Widget), param_info->iarray_len);
  trick = (String *) calloc(sizeof(String) , 100) ;
  toyou = (ParamCallback **) calloc(sizeof(ParamCallback) ,
                                          param_info->iarray_len) ;
  for ( counter = 0 ; counter < param_info->iarray_len ; counter++ )
     toyou[counter] = (ParamCallback *) calloc(sizeof(ParamCallback) , 1) ;

/* Initialise the path for the callback */
for (another= 0 ; another< param_info->iarray_len ; another++)
for (counter = 0 ; counter < 4 ; counter++)
    toyou[another]->param_path[counter] = -1 ;

/* creation loop */
for(counter=0 ; counter < param_info->iarray_len ; counter++)
 {

/* position correctly the param button boxes */
      if (counter <= PARAMS_PER_LINE)
      {
        XtSetArg(anyparam_arg[0],XtNfromVert, NULL) ;
        if (counter >= 1)
         {
          XtSetArg(anyparam_arg[1],XtNfromHoriz, any_param[counter-1]) ;
          toyou[counter]->param_voisin = any_param[counter-1] ;
         }
        else
         {
           XtSetArg(anyparam_arg[1],XtNfromHoriz, NULL) ;
           toyou[counter]->param_voisin = NULL ;
         }
     }
     else
     {
       XtSetArg(anyparam_arg[0],XtNfromVert,
                any_param[counter - PARAMS_PER_LINE -1]) ;
       if (counter == PARAMS_PER_LINE+1  || counter == 2 * (PARAMS_PER_LINE +1))
         {
            XtSetArg(anyparam_arg[1],XtNfromHoriz, NULL)  ;
            toyou[counter]->param_voisin = NULL ;
         }
       else
         {
           XtSetArg(anyparam_arg[1],XtNfromHoriz, any_param[counter-1])  ;
           toyou[counter]->param_voisin = any_param[counter-1] ;
         } ;
     } ;



   sprintf(trick , "%s  = %f" , param_info->iarray_val[counter].name ,
                 param_info->iarray_val[counter].value) ; 

   any_param[counter] = 
       XtCreateManagedWidget(trick ,
                                commandWidgetClass,
				thepapa,
				anyparam_arg,
				XtNumber(anyparam_arg));

/* Give all info to the callback and create it */
   toyou[counter]->param_index = counter ;
        XtAddCallback(any_param[counter], XtNcallback,
                Ask_system_param, (caddr_t)toyou[counter]) ;
   } ;
/* When all param widget have been created Call to fill the param family */
  FillParamFamily(
		toyou[0]->param_path ,
		param_info->iarray_len ,
		any_param
                ) ;


}


/*----------------------------------------------------*/
/* 		NET PARAMETERS			*/
/* TEST ON THE UPDATING WEDNESDAY 8pm */
void Net_param(thepapa , netpath , param_info)
Widget thepapa ; 
int netpath[] ;
iarray *param_info ;
{

  Widget /* level_param is the parent */
	*any_param , stupid ;

  String *trick ;
  int counter , another ;

  ParamCallback **toyou ;

  
  
/* If no param create a stupid one */
  if (param_info->iarray_len == 0)
    {
    XtSetArg(anyparam_arg[1],XtNfromHoriz, NULL) ;
    stupid =  XtCreateManagedWidget("No User Parameter at this level",
                                commandWidgetClass,
                                thepapa,
                                anyparam_arg,
                                XtNumber(anyparam_arg));
    return ;
    } ;

/* otherwise there is parameters */

/* Allocation of space for the widget , the label , thecallback */
  any_param = (Widget *) calloc(sizeof(Widget), param_info->iarray_len);
  trick = (String *) calloc(sizeof(String) , 100) ;
  toyou = (ParamCallback **) calloc(sizeof(ParamCallback) , 
				  	  param_info->iarray_len ) ;
  for ( counter = 0 ; counter < param_info->iarray_len ; counter++ )
     toyou[counter] = (ParamCallback *) calloc(sizeof(ParamCallback) , 1) ;

/* Initialise the path for the callback */
for (another= 0 ; another< param_info->iarray_len ; another++)
for (counter = 0 ; counter < 4 ; counter++)
    toyou[another]->param_path[counter] = netpath[counter] ;

/* creation loop */ 
for(counter=0 ; counter < param_info->iarray_len ; counter++)
 {
/* position correctly the param button boxes */
      if (counter <= PARAMS_PER_LINE)
      {
        XtSetArg(anyparam_arg[0],XtNfromVert, NULL) ;
        if (counter >= 1)
         {
          XtSetArg(anyparam_arg[1],XtNfromHoriz, any_param[counter-1]) ;
          toyou[counter]->param_voisin = any_param[counter-1] ;
         }
        else
         {
           XtSetArg(anyparam_arg[1],XtNfromHoriz, NULL) ;
           toyou[counter]->param_voisin = NULL ;
         }
     }
     else
     {
       XtSetArg(anyparam_arg[0],XtNfromVert,
                any_param[counter - PARAMS_PER_LINE -1]) ;
       if (counter == PARAMS_PER_LINE+1  || counter == 2 * (PARAMS_PER_LINE +1))
         {
            XtSetArg(anyparam_arg[1],XtNfromHoriz, NULL)  ;
            toyou[counter]->param_voisin = NULL ;
         }
       else
         {
           XtSetArg(anyparam_arg[1],XtNfromHoriz, any_param[counter-1])  ;
           toyou[counter]->param_voisin = any_param[counter-1] ;
         } ;
     } ;


   sprintf(trick , "%s  = %f" , param_info->iarray_val[counter].name ,
                 param_info->iarray_val[counter].value) ; 


   any_param[counter] = XtCreateManagedWidget(trick ,
                                commandWidgetClass,
				thepapa,
				anyparam_arg,
				XtNumber(anyparam_arg));

/* Give all info to the callback and create it */
   toyou[counter]->param_index = counter ;
        XtAddCallback(any_param[counter], XtNcallback,
                Ask_net_param, (caddr_t)toyou[counter]) ;

   } ;

/* When all param widget have been created Call to fill the param family */
  FillParamFamily(
		netpath ,
		param_info->iarray_len ,
		any_param
                ) ;

}
/*----------------------------------------------------*/
/* 		LAYER PARAMETERS			*/
/* SHOULD USE RPC INFO */
void Layer_param(thepapa , layerpath , param_info)
Widget thepapa ; 
int layerpath[] ;
iarray *param_info ;
{

  Widget /* level_param is the parent */
	*any_param , stupid ;

  String *trick ;
  int counter , another ;
 
  ParamCallback **toyou ;
 
  
/* If no params create a stupid one */
  if (param_info->iarray_len == 0)
    {
    XtSetArg(anyparam_arg[0],XtNfromVert, NULL) ;
    XtSetArg(anyparam_arg[1],XtNfromHoriz, NULL) ;
    stupid =  XtCreateManagedWidget("No User Parameter at this level",
                                commandWidgetClass,
                                thepapa,
                                anyparam_arg,
                                XtNumber(anyparam_arg));
    return ;
    } ;

/* otherwise there is parameters */

/* Allocation of space for the widget */
  any_param = (Widget *) calloc(sizeof(Widget), param_info->iarray_len);
  trick = (String *) calloc(sizeof(String) , 100) ;
  toyou = (ParamCallback **) calloc(sizeof(ParamCallback) ,
                                          param_info->iarray_len) ;
  for ( counter = 0 ; counter < param_info->iarray_len ; counter++ )
     toyou[counter] = (ParamCallback *) calloc(sizeof(ParamCallback) , 1) ;

/* Initialise the path for the callback */
for (another= 0 ; another< param_info->iarray_len ; another++)
for (counter = 0 ; counter < 4 ; counter++)
    toyou[another]->param_path[counter] = layerpath[counter] ;
 
for(counter=0 ; counter < param_info->iarray_len ; counter++)
 {
/* position correctly the param button boxes */
      if (counter <= PARAMS_PER_LINE)
      {
        XtSetArg(anyparam_arg[0],XtNfromVert, NULL) ;
        if (counter >= 1)
         {
          XtSetArg(anyparam_arg[1],XtNfromHoriz, any_param[counter-1]) ;
          toyou[counter]->param_voisin = any_param[counter-1] ;
         }
        else
         {
           XtSetArg(anyparam_arg[1],XtNfromHoriz, NULL) ;
           toyou[counter]->param_voisin = NULL ;
         }
     }
     else
     {
       XtSetArg(anyparam_arg[0],XtNfromVert,
                any_param[counter - PARAMS_PER_LINE -1]) ;
       if (counter == PARAMS_PER_LINE+1  || counter == 2 * (PARAMS_PER_LINE +1))
         {
            XtSetArg(anyparam_arg[1],XtNfromHoriz, NULL)  ;
            toyou[counter]->param_voisin = NULL ;
         }
       else
         {
           XtSetArg(anyparam_arg[1],XtNfromHoriz, any_param[counter-1])  ;
           toyou[counter]->param_voisin = any_param[counter-1] ;
         } ;
     } ;

   sprintf(trick , "%s  = %f" , param_info->iarray_val[counter].name ,
                 param_info->iarray_val[counter].value) ; 

   any_param[counter] = 
       XtCreateManagedWidget(trick ,
                                commandWidgetClass,
				thepapa,
				anyparam_arg,
				XtNumber(anyparam_arg));

/* Give all info to the callback and create it */
   toyou[counter]->param_index = counter ;
        XtAddCallback(any_param[counter], XtNcallback,
                Ask_layer_param, (caddr_t)toyou[counter]) ;

   } ;
/* When all param widget have been created Call to fill the param family */
  FillParamFamily(
		layerpath ,
		param_info->iarray_len ,
		any_param
                ) ;
}

/*----------------------------------------------------*/
/* 		CLUSTER PARAMETERS			*/
/* SHOULD USE RPC INFO */
void Cluster_param(thepapa , clusterpath , param_info)
Widget thepapa ; 
int clusterpath[] ;
iarray *param_info ;
{

  Widget /* level_param is the parent */
	*any_param , stupid ;

  String *trick ;
  int counter , another ;
 
  ParamCallback **toyou ;
  
  
/* If no params create a stupid one */
  if (param_info->iarray_len == 0)
    {
    XtSetArg(anyparam_arg[0],XtNfromVert, NULL) ;
    XtSetArg(anyparam_arg[1],XtNfromHoriz, NULL) ;
    stupid =  XtCreateManagedWidget("No User Parameter at this level",
                                commandWidgetClass,
                                thepapa,
                                anyparam_arg,
                                XtNumber(anyparam_arg));
    return ;
    } ;

/* otherwise there is parameters */

/* Allocation of space for the widget */
  any_param = (Widget *) calloc(sizeof(Widget), param_info->iarray_len);
  trick = (String *) calloc(sizeof(String) , 100) ;
  toyou = (ParamCallback **) calloc(sizeof(ParamCallback) ,
                                          param_info->iarray_len) ;
  for ( counter = 0 ; counter < param_info->iarray_len ; counter++ )
     toyou[counter] = (ParamCallback *) calloc(sizeof(ParamCallback) , 1) ;

/* Initialise the path for the callback */
for (another= 0 ; another< param_info->iarray_len ; another++)
for (counter = 0 ; counter < 4 ; counter++)
    toyou[another]->param_path[counter] = clusterpath[counter] ;

/* Creation loop */ 
for(counter=0 ; counter < param_info->iarray_len ; counter++)
 {

/* position correctly the param button boxes */
      if (counter <= PARAMS_PER_LINE)
      {
        XtSetArg(anyparam_arg[0],XtNfromVert, NULL) ;
        if (counter >= 1)
         {
          XtSetArg(anyparam_arg[1],XtNfromHoriz, any_param[counter-1]) ;
          toyou[counter]->param_voisin = any_param[counter-1] ;
         }
        else
         {
           XtSetArg(anyparam_arg[1],XtNfromHoriz, NULL) ;
           toyou[counter]->param_voisin = NULL ;
         }
     }
     else
     {
       XtSetArg(anyparam_arg[0],XtNfromVert,
                any_param[counter - PARAMS_PER_LINE -1]) ;
       if (counter == PARAMS_PER_LINE+1  || counter == 2 * (PARAMS_PER_LINE +1))
         {
            XtSetArg(anyparam_arg[1],XtNfromHoriz, NULL)  ;
            toyou[counter]->param_voisin = NULL ;
         }
       else
         {
           XtSetArg(anyparam_arg[1],XtNfromHoriz, any_param[counter-1])  ;
           toyou[counter]->param_voisin = any_param[counter-1] ;
         } ;
     } ;


   sprintf(trick , "%s  = %f" , param_info->iarray_val[counter].name ,
                 param_info->iarray_val[counter].value) ; 

   any_param[counter] = 
       XtCreateManagedWidget(trick ,
                                commandWidgetClass,
				thepapa,
				anyparam_arg,
				XtNumber(anyparam_arg));

/* Give all info to the callback and create it */
   toyou[counter]->param_index = counter ;
        XtAddCallback(any_param[counter], XtNcallback,
                Ask_cluster_param, (caddr_t)toyou[counter]) ;

   } ;
/* When all param widget have been created Call to fill the param family */
  FillParamFamily(
		clusterpath ,
		param_info->iarray_len ,
		any_param
                ) ;
}

/*----------------------------------------------------*/
/* 		NEURON/SYNAPSE PARAMETERS			*/
/* SHOULD USE RPC INFO */
void Neuron_param(thepapa , neuronpath , param_info)
Widget thepapa ; 
int neuronpath[] ;
iarray *param_info ;
{

  Widget /* level_param is the parent */
	*any_param , stupid ;

  String *trick ;
  int counter , another ;
 
  ParamCallback **toyou ;
  
  
/* If no params create a stupid one */
  if (param_info->iarray_len == 0)
    {
    XtSetArg(anyparam_arg[0],XtNfromVert, NULL) ;
    XtSetArg(anyparam_arg[1],XtNfromHoriz, NULL) ;
    stupid =  XtCreateManagedWidget("No User Parameter at this level",
                                commandWidgetClass,
                                thepapa,
                                anyparam_arg,
                                XtNumber(anyparam_arg));
    return ;
    } ;

/* otherwise there is parameters */

/* Allocation of space for the widget */
  any_param = (Widget *) calloc(sizeof(Widget), param_info->iarray_len);
  trick = (String *) calloc(sizeof(String) , 100) ;
  toyou = (ParamCallback **) calloc(sizeof(ParamCallback) ,
                                          param_info->iarray_len) ;
  for ( counter = 0 ; counter < param_info->iarray_len ; counter++ )
     toyou[counter] = (ParamCallback *) calloc(sizeof(ParamCallback) , 1) ;

/* Initialise the path for the callback */
for (another= 0 ; another< param_info->iarray_len ; another++)
for (counter = 0 ; counter < 4 ; counter++)
    toyou[another]->param_path[counter] = neuronpath[counter] ;

/* Creation loop */ 
for(counter=0 ; counter < param_info->iarray_len ; counter++)
 {
/* position correctly the param button boxes */
      if (counter <= PARAMS_PER_LINE)
      {
        XtSetArg(anyparam_arg[0],XtNfromVert, NULL) ;
        if (counter >= 1)
         {
          XtSetArg(anyparam_arg[1],XtNfromHoriz, any_param[counter-1]) ;
          toyou[counter]->param_voisin = any_param[counter-1] ;
         }
        else
         {
           XtSetArg(anyparam_arg[1],XtNfromHoriz, NULL) ;
           toyou[counter]->param_voisin = NULL ;
         }
     }
     else
     {
       XtSetArg(anyparam_arg[0],XtNfromVert,
                any_param[counter - PARAMS_PER_LINE -1]) ;
       if (counter == PARAMS_PER_LINE+1  || counter == 2 * (PARAMS_PER_LINE +1))
         {
            XtSetArg(anyparam_arg[1],XtNfromHoriz, NULL)  ;
            toyou[counter]->param_voisin = NULL ;
         }
       else
         {
           XtSetArg(anyparam_arg[1],XtNfromHoriz, any_param[counter-1])  ;
           toyou[counter]->param_voisin = any_param[counter-1] ;
         } ;
     } ;

   sprintf(trick , "%s  = %f" , param_info->iarray_val[counter].name ,
                 param_info->iarray_val[counter].value) ; 

   any_param[counter] = 
       XtCreateManagedWidget(trick ,
                                commandWidgetClass,
				thepapa,
				anyparam_arg,
				XtNumber(anyparam_arg));

/* Give all info to the callback and create it */
   toyou[counter]->param_index = counter ;
        XtAddCallback(any_param[counter], XtNcallback,
                Ask_neuron_param, (caddr_t)toyou[counter]) ;

   } ;
/* When all param widget have been created Call to fill the param family */
  FillParamFamily(
		neuronpath ,
		param_info->iarray_len ,
		any_param
                ) ;
}
