/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 3/3/90
 *
 * pgm 
 *
 * NewScale.c
 ******************************************************************************/

#include "everything.h"
#include "mymonitor.h"
#include "mike_display.h"

/*--------------------------------------------------*/
/* THIS PROCEDURE DEALS WITH THE CHOICE OF A SCALE  */
/* FOR THE NEXT LEVEL WINDOW 			    */
/* Should , now integrate a new menu to choose the  */
/*   element of the level concerned 		    */
/* IT CALLS MONITORCREATE(GIVE THE FULL PATH) 	    */
/*--------------------------------------------------*/

/* *  Global variables */
Widget top_control ;   /* need it to pop it down */

/* Args for top_control menu widget */
        static Arg scaletopcontrol_arg[] = {
                {XtNx, (XtArgVal)0},
                {XtNy, (XtArgVal)0},
		{XtNborderWidth, (XtArgVal) 4},
        };
/*----------------------------------------------*/
/* CALL BACK OF ALL THE COMMANDS ASSOCIATED WITH OPEN */
/*---------------------------------------------*/
/* SYSTEM_CALLBACK() = 				*/

  void System_Choice_callback(initiateur, client_data, call_data)
  Widget initiateur;
  Widget client_data;  /* used to pop down the father ie open,close */
  caddr_t call_data;     /* not used  */
  {
  int path[4] , i ;
 
  for ( i = 0 ; i<=3 ; i++) { path[i] = -1 ; } ;

/*	XtPopdown(top_control) ;
	XtPopdown(client_data) ;
*/
XtUnmapWidget(top_control);
XtUnmapWidget(client_data);

 	Monitor_create(path) ;

/* COMMENTS : Remember that if the Xtpopdown is after */
/* the call to Monitor_create then strange thingd happends */
/* such as the interior of the window dissapears */
/* Scale choosen =  Neuron and Synapses */
  }
 
/* NET_CALLBACK() = 				*/

  void Net_Choice_callback(initiateur, client_data, call_data)
  Widget initiateur;
  Widget client_data;  /* used to pop down the father ie open,close */
  caddr_t call_data;     /* not used  */
  {
  int help_path[4] , i ;

  for (i = 0 ; i < 4 ; i++)
     help_path[i] = -1 ; 
  
/* If there is only one net then do not ask */
/* Create and Fil the assoc family with colourmap <=> state ie 0 */
   if (GiveNumber(help_path) == 1)
      {
XtUnmapWidget(top_control);
XtUnmapWidget(client_data);
/*	XtPopdown(top_control) ;
	XtPopdown(client_data) ;
*/
        help_path[0] = 0 ; /* Display first and only net */
        Monitor_create(help_path) ;
        FillAssocFamily(help_path , 0) ;
        FillThreshold(help_path , 0.5) ;
       }
  else
/* the following function should get the number of the net to be displayed */
	Component(top_control , client_data, 1 ) ;
  }

/* LAYER_CALLBACK() = 				*/

  void Layer_Choice_callback(initiateur, client_data, call_data)
  Widget initiateur;
  Widget client_data;  /* used to pop down the father ie open,close */
  caddr_t call_data;     /* not used  */
  {

	Component(top_control , client_data , 2 ) ;
  }

/* CLUSTER_CALLBACK() = 				*/

  void Cluster_Choice_callback(initiateur, client_data, call_data)
  Widget initiateur;
  Widget client_data;  /* used to pop down the father ie open,close */
  caddr_t call_data;     /* not used  */
  {

	Component(top_control , client_data , 3 ) ;
  }

/* NEURON_CALLBACK() = 				*/

  void Neuron_Choice_callback(initiateur, client_data, call_data)
  Widget initiateur;
  Widget client_data;  /* used to pop down the father ie open,close */
  caddr_t call_data;     /* not used  */
  {

	Component(top_control , client_data , 4 ) ;
  }

/*--------------------------------------------------*/
/*  PROC CALLLED FROM LEVELMONITORCREATE
/*
 * this call back proc creates a menu list widget
 * which allows the user to set the scale of the
 * new graphic env.
*/
void Newscale(father)
/* 
 *the widget father represent the top shell menu 
 */
Widget father ;
{
 Widget /* top_control , */
	 control ,
		system_level , net_level , layer_level , 
		cluster_level , neuron_level ;

/* ENTER ANY COMMAND WINDOW = HIGHLIGHT */
  static String command_trans = "<EnterWindow>: set()" ;
  XtTranslations command_compiled ;
extern Arg scaletopcontrol_arg[3];
Window junk_win;
int x_root, y_root,garbage;
unsigned int garbage_mask;


/* Change the cursor */
 Cursor thetried_cursor ; Display *thetried_display ; Window thetried_window ;

/*  Position *relativeX , *relativeY ;
  Position theX ,theY ;
*/
/* Arguments for the children of the Form*/
/* Args for any command widget */
        static Arg anycommand_arg[] = {
                {XtNfromVert, (XtArgVal)NULL},
                {XtNfromHoriz, (XtArgVal)NULL},
                {XtNvertDistance, (XtArgVal)1},
                {XtNhorizDistance, (XtArgVal)2},
/* MIKE CHANGE for foreground */
                {XtNdestroyCallback, (XtArgVal)NULL},
                {XtNwidth, (XtArgVal)SCALE_MENU_WIDTH},
		{XtNborderWidth, (XtArgVal) 0},
                } ;

/* obligation for the control widget not to have a NULL size */
        static Arg control_arg[] = {
/* MIKE CHANGE */
                {XtNdestroyCallback, (XtArgVal)NULL},
                } ;


/*  relativeX = 0 ;
  relativeY = 0 ;
 XtTranslateCoords(father, relativeX , relativeY , &theX , &theY ) ;

 XtSetArg(topcontrol_arg[0],XtNx, theX) ;
 XtSetArg(topcontrol_arg[1],XtNy, theY + 25) ;
*/
        top_control = XtCreatePopupShell("Scale",
                                overrideShellWidgetClass,
                                father,
                                scaletopcontrol_arg,
                                XtNumber(scaletopcontrol_arg));


             control = XtCreateManagedWidget("Scale Menu",
                                formWidgetClass,
                                top_control,
                                control_arg,
                                XtNumber(control_arg) );

 XtSetArg(anycommand_arg[0],XtNfromVert, NULL ) ;
 XtSetArg(anycommand_arg[1],XtNfromHoriz, NULL) ;
               system_level = XtCreateManagedWidget(" System",
                                commandWidgetClass,
                                control,
                                anycommand_arg,
                                XtNumber(anycommand_arg) );
XtAddCallback(system_level, XtNcallback,
		System_Choice_callback, (caddr_t)father) ;

 XtSetArg(anycommand_arg[0],XtNfromVert, system_level) ;
 XtSetArg(anycommand_arg[1],XtNfromHoriz, NULL) ;
               net_level = XtCreateManagedWidget(" Net",
                                commandWidgetClass,
                                control,
                                anycommand_arg,
                                XtNumber(anycommand_arg) );
XtAddCallback(net_level, XtNcallback,
		Net_Choice_callback, (caddr_t)father) ;

 XtSetArg(anycommand_arg[0],XtNfromVert, net_level) ;
 XtSetArg(anycommand_arg[1],XtNfromHoriz, NULL) ;
               layer_level = XtCreateManagedWidget(" Layer",
                                commandWidgetClass,
                                control,
                                anycommand_arg,
                                XtNumber(anycommand_arg) );
XtAddCallback(layer_level, XtNcallback,
		Layer_Choice_callback, (caddr_t)father) ;

 XtSetArg(anycommand_arg[0],XtNfromVert, layer_level) ;
 XtSetArg(anycommand_arg[1],XtNfromHoriz, NULL) ;
               cluster_level = XtCreateManagedWidget(" Cluster",
                                commandWidgetClass,
                                control,
                                anycommand_arg,
                                XtNumber(anycommand_arg) );
XtAddCallback(cluster_level, XtNcallback,
		Cluster_Choice_callback, (caddr_t)father) ;


 XtSetArg(anycommand_arg[0],XtNfromVert, cluster_level) ;
 XtSetArg(anycommand_arg[1],XtNfromHoriz, NULL) ;
               neuron_level = XtCreateManagedWidget(" Neuron",
                                commandWidgetClass,
                                control,
                                anycommand_arg,
                                XtNumber(anycommand_arg) );
XtAddCallback(neuron_level, XtNcallback,
		Neuron_Choice_callback, (caddr_t)father) ;

/* compiled the new translation */
  command_compiled = XtParseTranslationTable(command_trans) ;
  XtOverrideTranslations(system_level, command_compiled) ;
  XtOverrideTranslations(net_level, command_compiled) ;
  XtOverrideTranslations(layer_level, command_compiled) ;
  XtOverrideTranslations(cluster_level, command_compiled) ;
  XtOverrideTranslations(neuron_level, command_compiled) ;

/* REALIZE */
/*	XtPopup(top_control, XtGrabExclusive);   */
XtRealizeWidget(top_control);
XQueryPointer(XtDisplay(top_control), XtWindow(top_control), &junk_win, &junk_win, &x_root, &y_root, &garbage, &garbage, &garbage_mask);
XtSetArg(scaletopcontrol_arg[0],XtNx, x_root-20) ;
XtSetArg(scaletopcontrol_arg[1],XtNy, y_root-20) ;
XtSetValues(top_control, scaletopcontrol_arg, XtNumber(scaletopcontrol_arg));
XtMapWidget(top_control);


/* Change the cursor ; beomes an arrow */
thetried_display = XtDisplay(control) ;
thetried_window = XtWindow(control) ;
thetried_cursor = XCreateFontCursor(thetried_display , XC_sb_right_arrow) ;
XDefineCursor(thetried_display, thetried_window , thetried_cursor) ;

}
