/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 3/3/90
 *
 * pgm 
 *
 * NEWGetWeight.c
  ******************************************************************************/

#include "everything.h"
#include <ctype.h>  /* This one is for STATE etc.. to be known here */
#include "rpcheader.h"  /* OR IS IT THIS ONE ?? */

#define rpc_free(x, p) if(p)xdr_free(x, p)

/*----------------------------------------------------------*/
/* THIS PROC CALLS THE RPC WHICH GIVES THE WEIGHT */
/* COMMENTS : To get the weights you have to access */
/* 	      the RPC at the NEURON TO level */
/* 			 the CLUSTER FROM level */
/*----------------------------------------------------------*/

/* EXTERN for the RPC */
extern char server[] ;
extern CLIENT *myclient ;
static rec *weightres;

/* The configuration of the loaded nC neural network */
/* NB obtained via RPC call */
extern confres *conf ;

/* Global Variables => Highest and Lowest value */
static  float highest = 0 ;
static  float lowest = 0 ;

/*----------------------------------------------------------*/
/* Get the weight according to the path */

  void Getweight(topath, frompath , tofill , start_point)
  int topath[4] ;   /* Neuron TO */
  int frompath[4] ; /* Cluster FROM */
  float tofill[] ;
  int start_point ; /* to know at which point to fill the array */
  {
  int i ;
  int floating_number ;
/* declaration for RPC only */
  twoindx rpcpara; 

/* set the argument to be given to the RPC */
 for (i = 0 ; i < 4 ; i++)
  {
  rpcpara.toindx[i] = topath[i] ;
  rpcpara.fromindx[i] = frompath[i] ;
  } ;


/* free before calling */
rpc_free(xdr_rec, weightres);

/* call to the RPC */
weightres = rgetanyweight_1(&rpcpara, myclient);

/* check the result */
/* 1- error from the client-server system */
 if (weightres == NULL ) 
     {
   clnt_perror(myclient, server);
   return;
       } ;
/* 2- error from the RPC itself */
if (weightres->errorn == -1)
       {
       Error(200) ;
       return ;
       } ;

if (weightres->errorn != 0 && weightres->errorn != -1)
        {
       Error(200) ;
       return ;
       } ;


/* Here I should have the information in RES pointer to type rec  */
   /*  do whatever necessary  */

 floating_number = weightres->rec_u.sttwgt.farray_len ;


/* try to get the real staff ie VALUE themselves */
  for (i = 0 ; i < floating_number ; i++)
     {
     tofill[start_point] = weightres->rec_u.sttwgt.farray_val[i] ;
     if (tofill[start_point] != 1000000)
       {
       if (highest < tofill[start_point]) highest = tofill[start_point] ;
       if (lowest > tofill[start_point]) lowest = tofill[start_point] ;
       } ;
     start_point++ ;
     } ;

/* if the scale is none => put a default one */
  if (highest == lowest) highest = lowest +1 ;

}

/*----------------------------------------------------------*/
/* According to the level set everything for GetWeight	    */
 void SetToWeight(wayfrom , wayto, togive)
 int wayfrom[4] ;     /* path of the first component => FROM */ 
 int wayto[4] ;     /* path of the second component => TO */ 
 float togive[] ;
 {
 int rpcto[4] ,rpcfrom[4] , fillpath[4] , Fescapepath[4] ;
 int net , layer , cluster , neuron ;
 int i , fromcluster , from_nbe_clusters ; 
 int total_synapses ; /* comments = no needs at the moment but who knows */
 int beginning ; /* to know at which point we have to fill the array coz */
                 /* we are feeding at cluster level => more than one call */
 float *escape ;
 
  total_synapses = 0 ; beginning = 0 ;

  switch( GiveLevel(wayto) )
   {
 case 2 :
/* layer level => synapses between two layers */
/*			FROM layer described by the "wayfrom" */
/* 			TO layer described by the "wayto" */


/* find the total number of synapses */
 total_synapses = GiveTotal(2,wayto) ;
 total_synapses = total_synapses  * GiveTotal(2,wayfrom) ;
/* total synapses = nbe of neurons layer "wayto" x nb of neurons "wayfrom"*/

     net = wayto[0] ; layer = wayto[1] ;
 

/* rpcto has to be the TO neuron  path */
     rpcto[0] = wayto[0]; rpcto[1] = wayto[1]; rpcto[3] = -1 ;

/* rpcfrom has to be the FROM CLUSTER path */
     rpcfrom[0] = wayfrom[0]; rpcfrom[1] = wayfrom[1]; 
     rpcfrom[2] = 0 ; rpcfrom[3] = 0 ;
 
/* fromclusters = nbe of clusters within layer FROM */ 
    from_nbe_clusters = 
conf->confres_u.sys->rpcsys_val[rpcfrom[0]].rpcnet_val[rpcfrom[1]].rpclay_len ;


/* for all cluster within TO  layer */
   for ( cluster = 0 ; 
    cluster < conf->confres_u.sys->rpcsys_val[net].rpcnet_val[layer].rpclay_len;
	cluster++)
   {

/* for all neuron within cluster within TO layer */
     for (neuron = 0 ; 
neuron < conf->confres_u.sys->rpcsys_val[net].rpcnet_val[layer].rpclay_val[cluster].rpcclu_len ;
        neuron++)
     {
/* for all clusters FROM */
    for (rpcfrom[2] = 0 ; rpcfrom[2] < from_nbe_clusters ; rpcfrom[2]++) 
        {
      rpcto[2] = cluster ; rpcto[3] = neuron ;
      Getweight(rpcto ,rpcfrom ,  togive, beginning) ;
      beginning = GiveTotal(3,rpcfrom) + beginning ;
        } ;
     } ;
   } ; 

/* Set the highest and lowest values  for the layer */
/* buut this has been called at the net level => fill the net entry */
      fillpath[0] = wayto[0] ; fillpath[1] = -1 ;
      fillpath[2] = -1 ; fillpath[3] = -1 ;
      FillWeightScaleFamily(fillpath , lowest , highest) ;
      break ;


 case 3 :
/* cluster level => synapses between two clusters */

/*  => neurons(Cluster From) + neurons(Cluster To) */

/* rpcto has to be the TO neuron  path */
     rpcto[0] = wayto[0]; rpcto[1] = wayto[1]; 
     rpcto[2] = wayto[2] ; rpcto[3] = -1 ;

/* rpcfrom has to be the FROM CLUSTER path */
     rpcfrom[0] = wayfrom[0]; rpcfrom[1] = wayfrom[1]; 
     rpcfrom[2] = wayfrom[2] ; rpcfrom[3] = -1 ;

  total_synapses = GiveTotal(3,wayto) ;
  total_synapses = total_synapses * GiveTotal(3,wayfrom) ;


/* for all neuron within that cluster send RPC Weights request */
 for (neuron = 0 ; neuron < GiveTotal(3,wayto) ; neuron++)
      {
      rpcto[3] = neuron ;
      Getweight(rpcto , rpcfrom , togive, beginning ) ;
      beginning = GiveTotal(3,rpcfrom) + beginning ;
      } ; 

/* Set the highest and lowest values  for the cluster */
/* buut this has been called at the layer level => fill the layer entry */
      fillpath[0] = wayto[0] ; fillpath[1] = wayto[1] ;
      fillpath[2] = -1 ; fillpath[3] = -1 ;
      FillWeightScaleFamily(fillpath , lowest , highest) ;

      break ;

 case 4 :
/* neuron level => call for just one neuron */
/* PROBLEM Which path is FROM */
/* Escape from => path for the cluster where the FROM NEURON is */
        Fescapepath[0] = wayfrom[0] ; /* same net */
        Fescapepath[1] = wayfrom[1] ; /* same layer */
        Fescapepath[2] = wayfrom[2] ; /* same cluster */
        Fescapepath[3] = -1  ; /* No Neuron */

    	escape = (float *) calloc(sizeof(float) , GiveTotal(3 , Fescapepath) ) ;

       Getweight(wayto, wayfrom, escape, 0) ; 
       togive[0] = escape[wayfrom[3]] ;


/* Set the highest and lowest values  for the neuron */
/* buut this has been called at the cluster level => fill the cluster entry */
      FillWeightScaleFamily(Fescapepath , lowest , highest) ;
      break ;

 default : Error(200) ;
           break ;

/* End of case */
   } ;

 }

