/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 3/3/90
 *
 * pgm 
 *
 * MagaliPattern.c
 ******************************************************************************/

#include "everything.h"

#define rpc_free(x, p) if(p)xdr_free(x, p)

/*----------------------------------------------------------*/
/* THIS PROC CALLS THE RPC WHICH LOADS A PATTERN  DESCRIPTORS */
/*				LOADS AN INPUT 			*/
/* 				LOADS AN INPUT AND TARGET    */
/*----------------------------------------------------------*/

/* EXTERN for the RPC */
extern char server[] ;
extern CLIENT *myclient ;


 static patres *resultpat ;

/*----------------------------------------------------------*/
/* argument "WHAT"					    */
     /* 0 => read input only */
     /* 1 => read input AND target */
     /* 2 => read input AND target AND Fill_dim_family */
     /*      which means that the matrix size is set once when */
     /*      the user init_pattern 			       */		
/*----------------------------------------------------------*/
  void MagaliPattern(afile , anindex , what) 
  char *afile ;
  int anindex ;
  int what ; 
  {
  char help ;
  int i ;
/* for RPC purposes */
 patfile for_rpc ; 

/* Assign the filename */
  strcpy(for_rpc.name , afile) ;

/* free before calling */
/* NO FREE */
/*  rpc_free(xdr_rec, resultpat);*/

/* Assign the index */
  for_rpc.index = anindex  ;

/* according to what proceed */
  switch (what)
   {
   case 0 :
           resultpat = rreadinp_1(&for_rpc, myclient); 
	   break ;
   case 1 :
  	   resultpat = rreadall_1(&for_rpc, myclient); 
	   break ;
   case 2 :
  	   resultpat = rreadall_1(&for_rpc, myclient); 
	   break ;
   default :
	   printf("SHOULD NEVER be here \n") ;
	   break ;
   } ;

/* check the result */
/* 1- error from the client-server system */
  if (resultpat == NULL) 
       {
  clnt_perror(myclient, server);
   return;
      } ;
/* 2- failure of the RPC */
/*  if (*resultpat)
 *     {
 *     printf("MagaliPattern Failed\n") ;
 *     return ;
 *     } ;
 */

  if (resultpat->width[0] == -400)
      {
      Error(208) ;
      return ;
      } ;
     
  if (what == 2)
    Fill_dim_family(resultpat->width , resultpat->height) ;

}
