/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 3/3/90
 *
 * pgm 
 *
 * LevelRuleCreate.c
 ******************************************************************************/

#include "everything.h"
#include "mymonitor.h"
#include "rpcheader.h"

#define rpc_free(x, p) if(p)xdr_free(x, p)

extern char server[];
extern CLIENT *myclient;

/*--------------------------------------------*/
/*  RULE_CREATE PROC 				*/
/*   creates :                                  */
/*            the rule display area (level_rule)	*/
/*         	rules widget (rule[i]), command widget  */
/* 		the number of rules widget created depends */
/*			1- on the level displayed 	*/
/*			2- on the NN application	*/
/*----------------------------------------------*/
/* FOR THE MOMENT FIXED NUMBER OF RULES */
/*   AND FIXED DEFINITION OF THE NAMES OF THOSE RULES */


/* to give a visual idea of the widget hierarchy here. */
/*    Widget  godfather (level_monitor) */
		/* godchild (level_title)  */
		/* level_rule */
			/* the rules command widget */	


/*----------------------------------------------------*/
/*----------------------------------------------------*/
/*  		THE PROC  Rule_create     		*/
/*----------------------------------------------------*/
/* This proc. creates
 *	1- the level_rule, form widget 
 * 		which will include all the rule-button boxes 
 *		created within <Level_name>_create()
 */
void Rule_create(theway, aboutcreate)
int theway[] ; /* Gives the full path for that level rule window */
Widget aboutcreate ;  /* it is level rule => */
			/* the one which is about to be created */
{
/* Declaration for RPC call */
  strctname rpcpara;
  int	i;
  static rec *rule_result ;


/* According to the level call the procedures which creates the rule-button */
/* Here I only need the level not the full path */

/* Call the RPC to get Rule information */
 rpcpara.indx[0] = 0;
 for (i=0; i<4; i++)
    rpcpara.indx[i+1] = theway[i];
 rpcpara.indx[5] = -1;
 rpcpara.namecode = N_RULE;

 rpc_free(xdr_rec, rule_result);

/* The CALL */
/* Thursday 1pm => RPC; Server seems to break then which leads to destroy */
/*                everything*/
/* info == rpcint_clnt.c line 107 retrun(NULL)     */
/*         GetStatus.c line 106                    */
/* one process has a state = <defunct>             */


 rule_result = rnetstat_1(&rpcpara, myclient);

 if (!rule_result) {
    clnt_perror(myclient, server);
    return;
 }
/* the RPC has not return what we asked for */
 if (rule_result->errorn == -1) {
    Error(207) ;
    return;
 }

/* the RPC failed */
 if (rule_result->errorn != 1) {
    Error(207) ;
    return;
 }
 
 switch ( GiveLevel(theway) )
	{
	case 0 :  
    System_create(aboutcreate, &rule_result->rec_u.names ) ;
		  break ;
	case 1 : 
    Net_create(aboutcreate, theway, &rule_result->rec_u.names) ;
		  break ;
	case 2 : 
   Layer_create(aboutcreate, theway, &rule_result->rec_u.names) ;
		  break ;
	case 3 : 
Cluster_create(aboutcreate, theway, &rule_result->rec_u.names) ;
		  break ;
	case 4 : 
Neuron_create(aboutcreate, theway, &rule_result->rec_u.names) ;
		  break ;
	} ; 

}

