/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.01 30/1/90
 *
 * pgm 
 *
 * IOTake.c
 ******************************************************************************/

#include "everything.h"
#include "myheader.h"
#include "graypix.bm"
#include "mike_display.h"

/* SHOULD BE IN AN MY HEADER.H */
#define MAX_PATTERNS 25

extern Bool end_application ;
extern char application_filename[200] ;

/* Sunday 19 March => changes */
extern int algo_need_random ;

/*----------------------------------------------------*/
/* THIS PROC TAKES CARE OF THE INPUT FROM THE USER */
/*  HERE THE USER TYPES FILENAME TO LOAD 	   */
/*----------------------------------------------------*/

/* Extern for RPC */
  extern CLIENT *myclient;
  extern char server[];
  extern int editorid ;  /* To use it in main while exiting PGM */


/* Extern for Parser Application program */
  extern FILE *yyin ;

/* Extern for Widget */
extern Widget patset, pgmrun;
extern Arg patset_arg[], pgmrun_arg[];


/* Args for toptop_totake, shell widget */
Arg toptoptotake_arg[] = {
                {XtNx, (XtArgVal)NULL},
                {XtNy, (XtArgVal)NULL},
                {XtNlabel, (XtArgVal)"IO menu"},
		{XtNmappedWhenManaged, (XtArgVal)False},
		{XtNborderWidth, (XtArgVal) 4},
        };

Arg totake_arg[] = {
                {XtNvertDistance, (XtArgVal)1},
                {XtNfromVert, (XtArgVal)NULL},
                {XtNlabel, (XtArgVal)NULL},
                {XtNvalue, (XtArgVal)""},
                {XtNheight, (XtArgVal)IO_TAKE_HEIGHT},
                {XtNwidth, (XtArgVal)IO_TAKE_WIDTH},
                {XtNdestroyCallback, (XtArgVal)NULL},
		{XtNborderWidth, (XtArgVal) 0},
		{XtNjustify, (XtArgVal) XtJustifyCenter},

        };

  int i ;

/*----------------------------------------------------*/
/* GLOBAL  VARIABLES */
/* About Widgets */
  Widget  to_take ; /* because needed in the callbacks to get the filename */ 
  int general_what ; /* because I do not know how to add a parameter */
		/* to an action */

/* GLOBAL  VARIABLES */
/* About RPC */
  fname sys_filename, str;  /* Filename */
  confres *conf;      /* conf is the information from the RPC */

/*----------------------------------------------------*/
/* CONFIRM CALLBACK TO KILL THE DIALOG WIDGET AND MORE*/
  void Confirm_totake(initiateur, client_data, call_data)
  Widget initiateur;
  caddr_t client_data;  /* used to pass the shell widget */
  caddr_t call_data;     /* not used  */
  {

/* cast the type */
  Widget theonetokill = (Widget)client_data ;

  char *thefile ;
  char editor_text[512] ; /* to run PCT editor */
  char another[200] ;

 thefile = XtDialogGetValueString(to_take) ;
  switch (general_what) 
	{

/*----------------------------------------------*/
/* LOAD AN APPLICATION ONLY */
  case 0 : 

/* test on the filename */
   if ( !CorrectName(0, thefile) )
        {
	XtUnmapWidget(theonetokill);
        return;
        }

/* NB An algorithm and configuration have been already loaded */
/* Test in BatchInteract_control.c */
	my_application = True ;
	end_application = False ;

/* Refer the filename as to be from the correct directory  */

        sprintf(another , "%s/%s" , rc[RC_application_directory], thefile) ;


/* Keep the application filename in memory */
  	strcpy(application_filename , thefile) ;

/* start the lex stuff with the filename "another" */
/* it seems like I am able to open a filename " " */
   if (!(yyin = fopen(another, "r")))
        {
               Error(81) ;
	XtUnmapWidget(theonetokill);
               return;
        }
/* display the appli file name */
/* Refer the filename as to be from the correct directory */
           Add_information(8, thefile) ;
           Add_information(3, another) ;

/* change Batch button into Interactive and the callback as well */
/* change Run and Pause and the callback as well to Step and Continuous */
	 BatchUnmap() ;


	XtUnmapWidget(theonetokill);
/*     	XtPopdown(theonetokill) ;*/
	 break ;

/*----------------------------------------------*/
/* LOAD NN SYSTEM  				*/
/* Load a NN system => Call Init if algo loaded */
  case 1 : 

/* test on the filename */
   if ( !CorrectName(1, thefile) )
        {
	XtUnmapWidget(theonetokill);
        return;
        }

/*	fflush(stdout);*/
	if (!my_algorithm)
	{ 
		Error(4) ; 
		return ; 
	}
	my_configuration = True ;

/* Refer the filename as to be from pgm directory */
	sprintf(another , "%s/%s" , rc[RC_nn_save_directory], thefile) ;

/* BEFORE        switch ( ChangInit((thefile)) */
        switch ( ChangInit(another) )
	{
	case -1 : Error(299) ; return ;
	case 0  : return ;
        } ; 
/* RPC Call to get the configuration of the NN system */
	    conf = rsysconf_1(str, myclient);
	    if (!conf) 
		{
	       clnt_perror(myclient, server);
		return;
	        }
	    if (conf->errorn != 0)
		{
		Error(203) ;
		return;
	        }
	    show_rpconf(conf->confres_u.sys, str);
/* Display the associated config */
	    Add_information(3, str) ;
/* Display fact that weight and states values are the one in the system */
/*	file called thefile */
	    Add_information(2, thefile) ;

		XtUnmapWidget(theonetokill);
/*		XtUnrealizeWidget(theonetokill);*/
/*       	 XtPopdown(theonetokill) ;*/
/*		PopDown(theonetokill);*/
		
	XtSetArg(patset_arg[9], XtNsensitive, (XtArgVal) True);
	XtSetValues(patset, patset_arg, 10);
	XtSetArg(pgmrun_arg[9], XtNsensitive, (XtArgVal) True);
	XtSetValues(pgmrun, pgmrun_arg, 10);

	
	 break ;

/*----------------------------------------------*/
/* LOAD A CONFIG  				*/
  case 2 : 
/* EFFECT of ChangLoad = only load a filename */
/* EFFECT of ChangInit = Load and CONNECT and BUILD RULES */
/* => if config than it loads with 0 weights and states */
/*              ChangLoad(thefile) ; */ 

/* test on the filename */
   if ( !CorrectName(2, thefile) )
        {
	XtUnmapWidget(theonetokill);
        return;
        } ;
  my_configuration = True ;

/* Refer the filename as to be from pgm directory */
	sprintf(another , "%s/%s" , rc[RC_configuration_directory], thefile) ;
/* BEFORE        switch ( ChangInit((thefile)) */
        switch ( ChangInit(another) )

	{
	case -1 : Error(299) ; return ;
	case 0  : return ;
        } ; 

/* RPC Call to get the configuration of the nC system */
/* Gives back (conf)  */
	    conf = rsysconf_1(str, myclient);
	    if (!conf) 
		{
	       clnt_perror(myclient, server);
		return;
	        }
	    if (conf->errorn != 0)
		{
		Error(203) ;
		return;
	        }
	    show_rpconf(conf->confres_u.sys, str);
	    Add_information(3, str) ;
	    Add_information(6, thefile) ;
/* Mike stuff */
	XtSetArg(patset_arg[9], XtNsensitive, (XtArgVal) True);
	XtSetValues(patset, patset_arg, 10);
	XtSetArg(pgmrun_arg[9], XtNsensitive, (XtArgVal) True);
	XtSetValues(pgmrun, pgmrun_arg, 10);

/* By default Randomize the weights */
/* Sunday March 19 => changes */
   if (algo_need_random)
    	    MagaliRandWeight() ;

		XtUnmapWidget(theonetokill);
/*       	 XtPopdown(theonetokill) ;*/
/*		PopDown(theonetokill);*/
	 break ;

/*----------------------------------------------*/
/* LOAD INPUT 					*/
  case 3 : 
 /*      3 => load Input Specification file */
/* SetInput takes the filename (ie thefile) and then retrieve from */
/* it the number of patterns in that file and read the first pat */

/* test on the filename */
   if ( !CorrectName(3, thefile) )
        {
	XtUnmapWidget(theonetokill);
        return;
        } ;

  if (!my_algorithm || !my_configuration)
	{
	Error(14) ;
	return ;
	} ;

  loadinput = 1 ;

/* Refer the filename as to be from pgm pattern directory */
        sprintf(another , "%s/%s" , rc[RC_pattern_directory], thefile) ;
  	  SetInput(another) ;
	  Add_information(1,thefile) ;
  XtUnmapWidget(theonetokill);
/*       	  XtPopdown(theonetokill) ;*/
 
/* if too many patterns specified then can cause trouble for the menu */
/* where those patterns are accessible later on */
  if ( TotalPattern() > MAX_PATTERNS )
     Error(30) ;

	  break ;
	 
/*----------------------------------------------*/
/* GET THE TARGET MACHINE NAME 			*/
  case 4 : 
/* test on the filename */
   if ( !CorrectName(4, thefile) )
        {
	XtUnmapWidget(theonetokill);
        return;
        } ;
   strcpy(server , thefile ) ;
   Add_information(7,server) ;
XtUnmapWidget(theonetokill);
/*       	 XtPopdown(theonetokill) ;*/

         break ;

/*----------------------------------------------*/
/* INIT STATES AND WEIGHTS 			*/
  case 5 : 
/*      5 => States and Weights init file */
         load_weight = 3 ; load_state= 3 ;
          Add_information(2,"DONE VIA FILE") ;
         /* SHOULD REALLY LOAD THE INITIALISATION  */
XtUnmapWidget(theonetokill);
/*       	 XtPopdown(theonetokill) ;*/
/*		PopDown(theonetokill);*/

         break ;

/*----------------------------------------------*/
/* SAVE NN SYSTEM 				*/
  case 6 : 
/*      6 => Save Status => call the RPC Save */

/* test on the filename */
   if ( !CorrectName(1, thefile) )
        {
	XtUnmapWidget(theonetokill);
        return;
        } ;

        sprintf(another , "%s/%s" , rc[RC_nn_save_directory], thefile) ;
         ChangSave(another) ;
/*       	 XtPopdown(theonetokill) ;*/
XtUnmapWidget(theonetokill);
          break ;


/*----------------------------------------------*/
/* EDITOR   */
  case 7 : 
 /*      7 => Call your favorite editor  */
  /* The name of the file to edit is in "thefile" */
/* according to the ending put the correct reference to the path */
  switch ( WhatName(thefile) )
	{
	case 0 :
        sprintf(another , "%s/%s" , rc[RC_application_directory], thefile) ;
		break ;
	case 1 :
        sprintf(another , "%s/%s" , rc[RC_nn_save_directory], thefile) ;
		break ;
	case 2 :
        sprintf(another , "%s/%s" , rc[RC_configuration_directory], thefile) ;
		break ;
	case 3 :
        sprintf(another , "%s/%s" , rc[RC_pattern_directory], thefile) ;
		break ;

	default :
        sprintf(another , "%s/%s" , rc[RC_working_directory], thefile) ;
		break ;
	} ;

         sprintf(editor_text , "xterm -n \"Pygmalion Editor\" -T \"Pygmalion Editor\" -e `printenv EDITOR` %s&" , another) ;

         if ((editorid = fork()) == 0) 
            { 
    	    system(editor_text) ;
	    _exit(0);
  	    }
	 if (editorid == -1) 
 	    {
	    perror("Can't execute pygmalion editor\n");
	    return;
	    }
/*       	 XtPopdown(theonetokill) ;*/
XtUnmapWidget(theonetokill);

          break ;

/*----------------------------------------------*/
/* USER ALGORITHM */
  case 8 : 
 /*      8 => Run your own nC algorithm  */
  /* The name of the file to compile and link is in "thefile" */


/*       	 XtPopdown(theonetokill) ;*/
XtUnmapWidget(theonetokill);

          break ;

/* End of Switch */
	} ;

/* End of Confirm_callback */
  }

/* CANCEL CALLBACK TO KILL THE DIALOG WIDGET */
  void Cancel_totake(initiateur, client_data, call_data)
  Widget initiateur;
  caddr_t client_data;  /* used to pass the shell widget */
  caddr_t call_data;     /* not used  */
  {
/* cast the type */
Widget theonetokill = (Widget)client_data ;

XtUnmapWidget(theonetokill);
/*        XtPopdown(theonetokill) ;*/
/*		PopDown(theonetokill);*/

  }

/*----------------------------------------------*/
/* TAKE THE FILENAME TO LOAD 			*/
/*----------------------------------------------*/
/* mother = the widget which initiates this proc 
 * what = which kind of file to load :
 * Tuesday 17 changes  
 *      0 => application file ;
 *      1 => algorithm file ;
 *      2 => configuration file ;
 *      3 => load Input Stimuli file
 *      4 => Take the target machine name
 *      5 => States and Weights init file
 *      6 => Save Status
 *      7 => Call your favorite editor  
 *      8 => Load user-algorithm  
 */

XtTranslations umm_compiled;
static XtActionList my_confirm_action[] = {{"Mikeconfirm_totake", Confirm_totake}};

void Take_input(mother,what)
Widget mother ;
int what ;     
{
Widget  toptop_totake ,
	  top_totake ,
		cancel_totake, 
		confirm_totake ;
		/* to_take */

Window junk_win;
int x_root, y_root,garbage;
unsigned int garbage_mask;
extern Arg totake_arg[9];
extern Arg toptoptotake_arg[5];

/* Change the cursor */
 Cursor thecursor ; Display *thedisplay ; Window thewindow ;

  Position *relativeX , *relativeY ;
  Position theX ,theY ;

/*----------------------------------------------*/
/* ARGUMENTS 					*/ 
/*----------------------------------------------*/

/* Args for top_totake, form widget */
static Arg toptotake_arg[] = {
                {XtNlabel, (XtArgVal)"bof"},
                {XtNdestroyCallback, (XtArgVal)NULL},
	} ;

static Arg canceltotake_arg[] = {
                {XtNfromVert, (XtArgVal)NULL},
                {XtNvertDistance, (XtArgVal)1},
                {XtNheight, (XtArgVal)BUTTON_HEIGHT},
                {XtNwidth, (XtArgVal)BUTTON_WIDTH},
        };


static Arg confirmtotake_arg[] = {
                {XtNfromVert, (XtArgVal)NULL},
                {XtNfromHoriz, (XtArgVal)NULL},
                {XtNvertDistance, (XtArgVal)1},
                {XtNhorizDistance, (XtArgVal) (IO_TAKE_WIDTH-BUTTON_WIDTH) },
                {XtNheight, (XtArgVal)BUTTON_HEIGHT},
                {XtNwidth, (XtArgVal)BUTTON_WIDTH},
        };

/* Args for to_take, dialog widget */
static char texte0[] = "Enter Application Filename" ;
static char texte1[] = "Enter NN System Name" ;
static char texte2[] = "Enter Configuration Filename" ;
static char texte3[] = "Enter Input Descriptors" ;
static char texte4[] = "Enter Target Machine Name" ;
static char texte5[] = "Enter States&Weight Filename" ;
static char texte6[] = "Enter System-Status Filename" ;
static char texte7[] = "Enter The Filename to Edit" ;
static char texte8[] = "Enter Your Algorithm filename" ;
static String *umm_trans ;


/*  relativeX = 0 ;
  relativeY = 0 ;
 XtTranslateCoords(mother, relativeX , relativeY , &theX , &theY) ;
 
 XtSetArg(toptoptotake_arg[0],XtNx, theX) ;
 XtSetArg(toptoptotake_arg[1],XtNy, theY + 5) ;
*/

/* The following line does not help with my problem */
/* XtSetKeyboardFocus(mother,XtNameToWidget(mother,"INIT MENU") ) ; */


/*----------------------------------------------*/
/* CREATE 					*/ 
/*----------------------------------------------*/
    toptop_totake = XtCreatePopupShell("toptoptakeinput",
                                overrideShellWidgetClass,
                                mother,
                                toptoptotake_arg,
                                XtNumber(toptoptotake_arg));




       top_totake = XtCreateManagedWidget("toptakeinput",
                                formWidgetClass,
                                toptop_totake,
                                toptotake_arg,
                                XtNumber(toptotake_arg));

/* According to the type of file to load display a */
/* different text */
	switch (what)
  	{
  	case 0: XtSetArg(totake_arg[2],XtNlabel, texte0 ) ;
          	break ;

  	case 1: XtSetArg(totake_arg[2],XtNlabel, texte1 ) ;
          	break ;

  	case 2: XtSetArg(totake_arg[2],XtNlabel, texte2 ) ;
		break ;
		
  	case 3: XtSetArg(totake_arg[2],XtNlabel, texte3 ) ;
          	break ;
		
  	case 4: XtSetArg(totake_arg[2],XtNlabel, texte4 ) ;
          	break ;
		
  	case 5: XtSetArg(totake_arg[2],XtNlabel, texte5 ) ;
          	break;
		
  	case 6: XtSetArg(totake_arg[2],XtNlabel, texte6 ) ;
          	break ;
		
  	case 7: XtSetArg(totake_arg[2],XtNlabel, texte7 ) ;
          	break ;
		
  	case 8: XtSetArg(totake_arg[2],XtNlabel, texte8 ) ;
          	break ;
  	};

          to_take = XtCreateManagedWidget("takeinput",
                                dialogWidgetClass,
                                top_totake,
                                totake_arg,
                                XtNumber(totake_arg));

/* now try to focus on the input part of those widgets */
 XtSetKeyboardFocus(toptop_totake , to_take ) ; 

 XtSetArg(canceltotake_arg[0],XtNfromVert, to_take ) ;

	  cancel_totake = XtCreateManagedWidget("CANCEL",
                                commandWidgetClass,
                                top_totake,
                                canceltotake_arg,
                                XtNumber(canceltotake_arg));

 XtSetArg(confirmtotake_arg[0],XtNfromVert, to_take ) ;
 XtSetArg(confirmtotake_arg[1],XtNfromHoriz, cancel_totake ) ;

	   confirm_totake = XtCreateManagedWidget("OK",
                                commandWidgetClass,
                                top_totake,
                                confirmtotake_arg,
                                XtNumber(confirmtotake_arg));


/* Add the callback in order to have the widget toptop_totake */
/* known by the callback in order to Pop it down */

/*this should get the return key as an ok, but it doesnt work! */

umm_trans = (String *) calloc(sizeof(String) , 200) ;
sprintf(umm_trans , "<Key>Return:Mikeconfirm_totake()");
XtAddActions(my_confirm_action, 1);
umm_compiled = XtParseTranslationTable(umm_trans);
XtOverrideTranslations(to_take, umm_compiled);

  XtAddCallback(confirm_totake, XtNcallback,
                Confirm_totake, (caddr_t)toptop_totake) ;


/* Add the callback in order to have the widget toptop_totake */
/* known by the callback in order to Pop it down */
  XtAddCallback(cancel_totake, XtNcallback,
                Cancel_totake, (caddr_t)toptop_totake) ;


/* set general what */
 	general_what = what ;

/* REALIZE */
/* XtPopup(toptop_totake, XtGrabNone) ;*/
/*PopUp(toptop_totake, toptoptotake_arg);*/
XtRealizeWidget(toptop_totake);
/*XCreateBitmapFromData(XtDisplay(to_take), XtWindow(to_take), graypix_bits, graypix_width, graypix_height, my_fg.pixel, my_bg.pixel, DefaultDepth(XtDisplay(to_take), DefaultScreen(XtDisplay(to_take))));*/
XQueryPointer(XtDisplay(toptop_totake), XtWindow(toptop_totake), &junk_win, &junk_win, &x_root, &y_root, &garbage, &garbage, &garbage_mask);
XtSetArg(toptoptotake_arg[0],XtNx, x_root-20) ;
XtSetArg(toptoptotake_arg[1],XtNy, y_root-20) ;
XtSetValues(toptop_totake, toptoptotake_arg, XtNumber(toptoptotake_arg));
/*XtSetArg(totake_arg[9], XtNbackgroundPixmap, graypix);*/
/*XtSetValues(to_take, totake_arg, XtNumber(totake_arg));*/
XtMapWidget(toptop_totake);


/* Change the cursor ; beomes an arrow */
  thedisplay = XtDisplay(confirm_totake) ;
  thewindow = XtWindow(confirm_totake) ;
  thecursor = XCreateFontCursor(thedisplay , XC_hand2 ) ;
  XDefineCursor(thedisplay, thewindow , thecursor) ;

  thedisplay = XtDisplay(cancel_totake) ;
  thewindow = XtWindow(cancel_totake) ;
  thecursor = XCreateFontCursor(thedisplay , XC_pirate ) ;
  XDefineCursor(thedisplay, thewindow , thecursor) ;

}

