/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.01 30/1/90
 *
 * pgm 
 *
 * Highlevel_control.c 
 ******************************************************************************/

#include "everything.h"
#include "myheader.h" 

/*----------------------------------------------*/
/* THIS PROC DEALS WITH HLL BUTTON                        */
/*      1- create button                        */
/*      2- The effect = NONE			*/
/*----------------------------------------------*/

/*----------------------------------------------*/
/* EXTERN for the 1- father widget		*/
/* 	          2- neighbour(s) within the form	*/
/* 		  3- the created widget itself 	*/
/*				REALSELECT         */
extern Widget simulation ;
extern Widget title_simulation ;
extern Widget highlevel;

extern Arg highlevel_arg[9];
extern Arg hlltopcontrol_arg[3];
extern Arg hllcontrol_arg[1];
extern Arg anycommand_arg[6];

/* Args for hll widget */
        Arg highlevel_arg[] = {
                {XtNcallback, (XtArgVal)NULL},
                {XtNhighlightThickness, (XtArgVal)3},
/* MIKE CHANGE for foreground */
                {XtNdestroyCallback, (XtArgVal)NULL},
                {XtNfromVert, (XtArgVal)NULL},
                {XtNvertDistance, (XtArgVal)2},
                {XtNfromHoriz, (XtArgVal)NULL},
                {XtNhorizDistance, (XtArgVal) DISTANCE_HORIZ},
                {XtNwidth, (XtArgVal)BUTTON_WIDTH},
		{XtNheight, (XtArgVal)BUTTON_HEIGHT},
	        };
/* Args for any command widget */
        Arg anycommand_arg[] = {
/*                {XtNfromVert, (XtArgVal)NULL},*/
                {XtNfromHoriz, (XtArgVal)NULL},
                {XtNvertDistance, (XtArgVal)1},
                {XtNhorizDistance, (XtArgVal)2},
                {XtNdestroyCallback, (XtArgVal)NULL},
                {XtNwidth, (XtArgVal)INIT_MENU_WIDTH +INIT_MENU_WIDTH/2},
		{XtNborderWidth, (XtArgVal) 0},
                } ;


/* obligation for the control widget not to have a NULL size */
        Arg hllcontrol_arg[] = {
/* MIKE CHANGE */
                {XtNdestroyCallback, (XtArgVal)NULL},
                } ;

/* Args for top_control menu widget */
	Arg hlltopcontrol_arg[] = {
/*                {XtNx, (XtArgVal)NULL},*/
                {XtNy, (XtArgVal)NULL},
		{XtNmappedWhenManaged, (XtArgVal)False},
		{XtNborderWidth, (XtArgVal) 3},
        };



/* GENERAL SHOULD NOT BE MAIN.c BUT IN myheader.h */
/* high level langage used */
extern char hlang[200] ;

/*-----------------------------------------------------------*/
/* ACTION MYPOPDOWN() = Popdown the ( algo , config ) */
/*                              alias ?_control            */
/*-----------------------------------------------------------*/
void MypopdownMenu(thewidget, event, params ,num_params)
Widget thewidget;
XEvent *event ;
String *params ;
Cardinal *num_params ;
{
 XtPopdown(thewidget) ;
}
void NullStaff(thewidget, event, params ,num_params)
Widget thewidget;
XEvent *event ;
String *params ;
Cardinal *num_params ;
{
}

/* CALLBACK for the nC menu option of the HLL command */
/* nC has been chosen as the HLL language */
  void Ucl_callback(initiateur, client_data, call_data)
  Widget initiateur;
  Widget client_data;  /* used as thepopup */
  caddr_t call_data;     /* not used  */
  {
  char stupid[200] ;


/*  XtPopdown(client_data) ;*/
XtUnmapWidget(client_data);
/* if there is no nC top window popped then call to pop it */
/* otherwise error (if != nore or was) */
  if ( (hlang[0] == 'n' && hlang[1] == 'o' ) ||
       (hlang[0] == 'w' && hlang[1] == 'a' ) 
     )
     {
  strcpy(hlang,"nC") ;
  Add_information(0,hlang) ;
  nCtop_proc(client_data) ;
     } 
  else
    Error(23) ;

  } ;

/* CALLBACK for the N menu option of the HLL command */
/* N  has been chosen as the HLL language */
  void Thomson_callback(initiateur, client_data, call_data)
  Widget initiateur;
  Widget client_data;  /* used as thepopup */
  caddr_t call_data;     /* not used  */
  {

XtUnmapWidget(client_data);
    Error(22) ;

  } ;
/*----------------------------------------------*/
/* CALL BACK OF THE COMMAND HLL 		*/
/*---------------------------------------------*/
/* DISPLAY WITH AS A COMMAND WIDGET ALL NAMES OF PROVIDED HLL */
/* AND ALLOW THE USER TO SELECT ONE OF THOSE */

  void Highlevel_callback(caller, client_data, call_data)
  Widget caller;
  Widget client_data;  /* the caller */
  caddr_t call_data;     /* not used  */
  {
  Widget  hlltop_control ,
            hll_control ,
             nc_choice , n_choice ;
Window junk_win;
int x_root, y_root,garbage;
unsigned int garbage_mask;
/* LEAVE WINDOW = POP down (nC , N ) MENU DOWN */
  static String menu_trans = "<LeaveWindow>:  mypopmenudown()" ;
  XtTranslations menu_compiled ;
  static XtActionList mymenupopdown[]={{"mypopmenudown",MypopdownMenu}} ;


/* Enter in a menu option = highlight */
  static String command_trans = "<EnterWindow>: set()" ;
  XtTranslations command_compiled ;

/* Change the cursor */
  Cursor thecursor ; Display *thedisplay ; Window thewindow ;

  Position *relativeX , *relativeY ;
  Position theX ,theY ;

/* Arguments for the children of the Form*/
/*  relativeX = 0 ;
  relativeY = 0 ;
 XtTranslateCoords(caller , relativeX , relativeY , &theX , &theY ) ;

theX = theX + (BUTTON_WIDTH - 8) ;
theY = theY + (BUTTON_HEIGHT - 6) ;
*/

        hlltop_control = XtCreatePopupShell("HLL Top Menu",
                                overrideShellWidgetClass,
                                caller,
                                hlltopcontrol_arg,
                                XtNumber(hlltopcontrol_arg));

       hll_control = XtCreateManagedWidget("Hll menu",
                                formWidgetClass,
                                hlltop_control,
                                hllcontrol_arg,
                                XtNumber(hllcontrol_arg));

 XtSetArg(anycommand_arg[0],XtNfromVert, NULL ) ;
 XtSetArg(anycommand_arg[1],XtNfromHoriz, NULL) ;
          nc_choice = XtCreateManagedWidget("    nC    ",
                                commandWidgetClass,
                                hll_control,
                                anycommand_arg,
                                XtNumber(anycommand_arg) );
XtAddCallback(nc_choice, XtNcallback,
               Ucl_callback , (caddr_t)hlltop_control) ;


 XtSetArg(anycommand_arg[0],XtNfromVert, nc_choice) ;
 XtSetArg(anycommand_arg[1],XtNfromHoriz, NULL) ;
               n_choice =
                  XtCreateManagedWidget("    N     ",
                                commandWidgetClass,
                                hll_control,
                                anycommand_arg,
                                XtNumber(anycommand_arg) );
XtAddCallback(n_choice, XtNcallback,
               Thomson_callback , (caddr_t)hlltop_control) ;

/* translation table to leave = pop down */
  XtAddActions(mymenupopdown,1) ;
  menu_compiled = XtParseTranslationTable(menu_trans) ;
  XtOverrideTranslations(hlltop_control, menu_compiled) ;

  command_compiled = XtParseTranslationTable(command_trans) ;
  XtOverrideTranslations(nc_choice, command_compiled) ;
  XtOverrideTranslations(n_choice, command_compiled) ;

/*PopUp(hlltop_control, hlltopcontrol_arg, 0, 1);*/
XtRealizeWidget(hlltop_control);
XQueryPointer(XtDisplay(hlltop_control), XtWindow(hlltop_control), &junk_win, &junk_win, &x_root, &y_root, &garbage, &garbage, &garbage_mask);
XtSetArg(hlltopcontrol_arg[0],XtNx, x_root-20) ;
XtSetArg(hlltopcontrol_arg[1],XtNy, y_root-20) ;
XtSetValues(hlltop_control, hlltopcontrol_arg, XtNumber(hlltopcontrol_arg));
XtMapWidget(hlltop_control);



/* Change the cursor ; becomes an arrow */
  thedisplay = XtDisplay(hll_control) ;
  thewindow = XtWindow(hll_control) ;
  thecursor = XCreateFontCursor(thedisplay , XC_sb_right_arrow) ;
  XDefineCursor(thedisplay, thewindow , thecursor) ;

  }

/*----------------------------------------------
 * CREATION OF THE HLL command widget (proc name= Highlevel)
 * LATER
 * MAIN FUNCTION = Button1 Press causes the pop up of a menu 
/*----------------------------------------------*/

/*-----------------------------------------------------*/
/* ARGUMENTS FOR HLL widget				*/
/*-----------------------------------------------------*/


/*-----------------------------------------------------*/
/* CREATION OF THE HLL BUTTON 			*/
/*-----------------------------------------------------*/

void Highlevel()
{

/* BTN1UP = DEFAULT + RESET otherwise does not unhighlight */
/* Declaration of the translation table for init */
  static String menu_trans = "<Btn1Up>: notify() unset() reset()" ;
  XtTranslations menu_compiled ;


 XtSetArg(highlevel_arg[3],XtNfromVert , title_simulation) ;
 XtSetArg(highlevel_arg[5],XtNfromHoriz , NULL) ;

        highlevel = XtCreateManagedWidget(" HLL ",
                                commandWidgetClass,
                                simulation,
                                highlevel_arg,
                                XtNumber(highlevel_arg));

/* Compilation of the translation table for select */
  menu_compiled = XtParseTranslationTable(menu_trans) ;
  XtOverrideTranslations(highlevel, menu_compiled) ;


/* "Compile" the call back */
XtAddCallback(highlevel, XtNcallback,
        Highlevel_callback,(caddr_t)highlevel) ;

} 
