/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 3/3/90
 *
 * pgm 
 *
 * GetUseParam.c
 ******************************************************************************/

#include "everything.h"
#include "mymonitor.h"
#include "rpcheader.h"

#define rpc_free(x, p) if(p)xdr_free(x, p)

/* THIS PROC CALLS THE RPC WHICH GIVES ALL INFORMATION */
/* ABOUT THE PARAMETERS LIST OF THE LEVEL CONCERNED    */
/* AND THE CHANGES THE DISPLAY IN THE ACCORDANCE OF THE RESULT */

extern char server[];
extern CLIENT *myclient;

/* CAUTION CAUTION  CAUTION  CAUTION  CAUTION  */
/* THE ARGUMENT FOR THE PARAM WIDGET ARE NO MORE STATIC */
/* this in order to be accessible and modifiable in this file */

  extern Arg anyparam_arg[6] ;

#define SAMEPARAMS_PER_LINE 3

/*-------------------------------------------------*/
void GetUse_param(theway, concerned , whichparam , neighbour)
int theway[] ;
Widget concerned ;
int whichparam ;  /* to know which param to update */
Widget neighbour ;
{
  String *trick ;

/* Declaration for RPC call */
  strctname rpcpara;
  int   i;
  static rec *param_result ;

  int num ;
  char *firstname ;

/* CALL the RPC to get param information */
 rpcpara.indx[0] = 0;
 for (i=0; i<4; i++)
    rpcpara.indx[i+1] = theway[i];
 rpcpara.indx[5] = -1;
 rpcpara.namecode = N_PARA ;

 rpc_free(xdr_rec, param_result);


 param_result = rnetstat_1(&rpcpara, myclient);

 if (!param_result) {
    clnt_perror(myclient, server);
    return;
 }
/* the RPC has not return what we asked for */
 if (param_result->errorn == -1) {
    Error(206) ;
    return; 
 }
/* the RPC failed */
 if (param_result->errorn != 1) 
    {
    Error(206) ;
   return; 
    }

  num = param_result->rec_u.dontkno.iarray_len ;

/* In this proc I am sure that this Level has parameters */
/* Indeed this function is called from one of them */
/* Here I have all the info => in param_result->rec_u.dontkno.iarray_val */ 
/* I need to change the display of the  "CONCERNED" widget */

   trick = (String *) calloc(sizeof(String) , 100) ;

/* if I  use Realize then I "lost" the callback of the widget 
 concerned */
/*  XtUnrealizeWidget(concerned) ; */
/*  XtRealizeWidget(concerned) ; */
  XtUnmanageChild(concerned) ;
  sprintf(trick , "%s  = %f" , 
         param_result->rec_u.dontkno.iarray_val[whichparam].name ,
         param_result->rec_u.dontkno.iarray_val[whichparam].value) ;

  XtSetArg(anyparam_arg[2], XtNlabel, trick) ;

  if (neighbour != NULL)
  XtSetArg(anyparam_arg[1], XtNfromHoriz, neighbour) ;
  else
  XtSetArg(anyparam_arg[1], XtNfromHoriz, NULL) ;
      
  XtSetValues(concerned , anyparam_arg,XtNumber(anyparam_arg));
  XtManageChild(concerned) ;
 
 } ; 

/*-------------------------------------------------*/
void NEWGetUse_param(theway, number )
int theway[] ;
int number ;
{
  String *trick ;

/* Declaration for RPC call */
  strctname rpcpara;
  int   i , counter ;
  static rec *param_result ;

Widget theid ;
Widget thevoisin ;

/* CALL the RPC to get param information */
 rpcpara.indx[0] = 0;
 for (i=0; i<4; i++)
    rpcpara.indx[i+1] = theway[i];
 rpcpara.indx[5] = -1;
 rpcpara.namecode = N_PARA ;

 rpc_free(xdr_rec, param_result);

 param_result = rnetstat_1(&rpcpara, myclient);

 if (!param_result) {
    clnt_perror(myclient, server);
    return;
 }
/* the RPC has not return what we asked for */
 if (param_result->errorn == -1) {
    Error(206) ;
    return; 
 }
/* the RPC failed */
 if (param_result->errorn != 1) 
    {
    Error(206) ;
   return; 
    }

   trick = (String *) calloc(sizeof(String) , 100) ;

for (counter = 0 ; counter < number ; counter++)
  {
  GiveWidgetId(theway , counter , &theid) ;
  
  XtUnmanageChild(theid) ;

  sprintf(trick , "%s  = %f" , 
         param_result->rec_u.dontkno.iarray_val[counter].name ,
         param_result->rec_u.dontkno.iarray_val[counter].value) ;
  XtSetArg(anyparam_arg[2], XtNlabel, trick) ;

  if (counter == 0 || counter == SAMEPARAMS_PER_LINE + 1 ||
      counter == 2 * (SAMEPARAMS_PER_LINE + 1)  )
    {
    XtSetArg(anyparam_arg[1], XtNfromHoriz, NULL) ;
    if (counter == 0 ) 
       XtSetArg(anyparam_arg[0], XtNfromVert, NULL) ;
    else
      {
       GiveWidgetId(theway , counter-1-SAMEPARAMS_PER_LINE , &thevoisin) ;
       XtSetArg(anyparam_arg[0], XtNfromVert, thevoisin ) ;
      } ;
    }
  else
   {
    GiveWidgetId(theway , counter-1 , &thevoisin) ;
    XtSetArg(anyparam_arg[1], XtNfromHoriz, thevoisin) ;
    if (counter <= SAMEPARAMS_PER_LINE) 
       XtSetArg(anyparam_arg[0], XtNfromVert, NULL) ;
    else 
     {
       GiveWidgetId(theway , counter-1-SAMEPARAMS_PER_LINE , &thevoisin) ;
       XtSetArg(anyparam_arg[0], XtNfromVert, thevoisin ) ;
      } ;
   } ;
      
  XtSetValues(theid, anyparam_arg,XtNumber(anyparam_arg));
  XtManageChild(theid) ;
  } ; 

 } ; 
