/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 3/3/90
 *
 * pgm 
 *
 * GetBitWeight.c
 ******************************************************************************/

#include "everything.h"
#include <ctype.h>  /* This one is for STATE etc.. to be known here */
#include "rpcheader.h"  /* OR IS IT THIS ONE ?? */

#define rpc_free(x, p) if(p)xdr_free(x, p)

/* MONDAY 10 DECEMBER => TRIAL WITH BIT ARRAY */

/*----------------------------------------------------------*/
/* THIS PROC CALLS THE RPC WHICH GIVES THE BITWEIGHT */
/* COMMENTS :  	      the RPC at the NEURON TO level */
/* 			 the CLUSTER FROM level */
/*----------------------------------------------------------*/

/* EXTERN for the RPC */
extern char server[] ;
extern CLIENT *myclient ;
static rec *bitres;

/* The configuration of the loaded nC neural network */
/* NB obtained via RPC call */
extern confres *conf ;


/*----------------------------------------------------------*/
/* Get the bit-weight according to the path */

  void SetToBit(frompath, topath , bitfill )
  int frompath[4] ; /* Cluster FROM */
  int topath[4] ;   /* Neuron TO */
  unsigned bitfill[] ;
  {
  int i ,  int_number , bit_number ;
/* declaration for RPC only */
  twoindx rpcpara; 

/* set the argument to be given to the RPC */
 for (i = 0 ; i < 4 ; i++)
  {
  rpcpara.toindx[i] = topath[i] ;
  rpcpara.fromindx[i] = frompath[i] ;
  } ;


/* free before calling */
rpc_free(xdr_rec, bitres);

/* call to the RPC */
  bitres = rgetbitweight_1(&rpcpara, myclient) ;


/* check the result */
/* 1- error from the client-server system */
 if (bitres == NULL ) 
     {
   clnt_perror(myclient, server);
   return;
       } ;
/* 2- error from the RPC itself */
if (bitres->errorn == -1)
       {
       Error(200) ;
       return ;
       } ;

if (bitres->errorn != 3 && bitres->errorn != -1)
        {
       Error(200) ;
       return ;
       } ;


/* Here I should have the information in RES pointer to type rec  */
   /*  do whatever necessary  */

/* this is only the number of int to code all bits */
 int_number = bitres->rec_u.bitconnect.bitweight_len ;


/* for all the int */
  for (i = 0 ; i < int_number ; i++)
     {
     bitfill[i] = bitres->rec_u.bitconnect.bitweight_val[i] ;
printf("In GetBit int value %u" , bitfill[i]) ;
     } ;
printf("\n" ) ;
}

