/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.01 30/1/90
 *
 * pgm 
 *
 * 
 ******************************************************************************/

#include "mymonitor.h"

  
/*--------------------------------------------------*/
/*--------------------------------------------------*/
/*  CHANGING THE SCALE FOR				*/
/*		       1- STATES AND COLOURMAP     */
/*		       2- WEIGHTS AND COLOURMAP     */
/*--------------------------------------------------*/
/*--------------------------------------------------*/
/* Structure to be known by the callbacks */

  typedef struct
	     {
		int laroute[4] ;
		Widget kill ;
		Widget hurt ;
		float normneuron[2] ;
		float normweight[2] ;
	      } ScaleStruct ;

  static ScaleStruct  *NiceBip ;
Arg normchoice_arg[] = {
                {XtNx, (XtArgVal)0},
                {XtNy, (XtArgVal)0},
                {XtNwidth, (XtArgVal)BIG_COLOUR_WIDTH},
                {XtNheight, (XtArgVal)BIG_COLOUR_HEIGHT},
                {XtNdestroyCallback, (XtArgVal)NULL},
	};


/*--------------------------------------------------*/
/* CALLBACK PROCS */


/*--------------------------------------------------*/
/*  the user chooses  to change the  NEURON SCALE */
  void Neuron_change(initiateur, client_data, call_data)
  Widget initiateur;
  caddr_t client_data;  
  caddr_t call_data;     /* not used  */
  {

/* Call to change the scale */
 TakeNewScale(NiceBip->kill , NiceBip->hurt, 0, NiceBip->laroute) ;
   free(NiceBip) ;
  }

/*--------------------------------------------------*/
/*  the user chooses  to change the  WEIGHT SCALE */
  void Weight_change(initiateur, client_data, call_data)
  Widget initiateur;
  caddr_t client_data;  
  caddr_t call_data;     /* not used  */
  {
/* Send order to Mike to changes its weights scale */
   FillWeightScaleFamily(
		NiceBip->laroute ,
		NiceBip->normweight[0] ,
		NiceBip->normweight[1]
		        ) ;
/*   XtPopdown(NiceBip->kill) ;*/
/*(   XtPopdown(NiceBip->hurt) ;*/
XtUnmapWidget(NiceBip->kill) ;
XtUnmapWidget(NiceBip->hurt) ;
   free(NiceBip) ;
  }

/*--------------------------------------------------*/
/*  the user chooses  to keep the scale as it is   */
  void Cancel_norm(initiateur, client_data, call_data)
  Widget initiateur;
  caddr_t client_data;  /* not used  */
  caddr_t call_data;     /* not used  */
  {
/*   XtPopdown(NiceBip->kill) ;
   XtPopdown(NiceBip->hurt) ;
*/
XtUnmapWidget(NiceBip->kill) ;
XtUnmapWidget(NiceBip->hurt) ;
free(NiceBip) ;
  }


/*--------------------------------------------------*/
/* THIS PROC TAKES CARE OF THE CHANGES OF THE SCALE */
  
  void Normalise(theway , father , scaleneuron , scaleweight)
  int theway[4] ;
  float scaleneuron[2] ;
  float scaleweight[2] ;
  Widget father ; /* it is the menu  */
  {
  Widget  top_norm_choice , norm_choice ,
	 norm_neuron ,
 		norm_weight , cancel ;
  int counter ;
  char bypass[1000] ;
extern Arg normchoice_arg[5];
Window junk_win;
int x_root, y_root,garbage;
unsigned int garbage_mask;

/* ENTER ANY COMMAND WINDOW = HIGHLIGHT */
  static String command_trans = "<EnterWindow>: set()" ;
  XtTranslations command_compiled ;

/* Change the cursor */
 Cursor thecursor ; Display *thedisplay ; Window thewindow ;

/* Args to get the location */
/*  Position *relativeX , *relativeY ;
  Position theX , theY ;
*/
/* Args for colour_choice list widget */

/* Args for red-green and blue, command widget */
  static Arg anynorm_arg[] = {
                {XtNfromVert, (XtArgVal)NULL},
                {XtNlabel, (XtArgVal)NULL},
                {XtNfromHoriz, (XtArgVal)NULL},
                {XtNhorizDistance, (XtArgVal)1},
                {XtNvertDistance, (XtArgVal)1},
                {XtNheight, (XtArgVal)COLOUR_HEIGHT},
        };


/* Take the location of the father menu to pop it up properly */
/*  relativeX = 0 ;
  relativeY = 0 ;
  XtTranslateCoords(father ,relativeX ,relativeY ,&theX ,&theY);
  XtSetArg(normchoice_arg[0],XtNx, theX) ;
  XtSetArg(normchoice_arg[1],XtNy, theY) ;
*/
	top_norm_choice = XtCreatePopupShell("TOP", 
				overrideShellWidgetClass,
				father,
				normchoice_arg,
			 	XtNumber(normchoice_arg));


	norm_choice = XtCreateManagedWidget("ASSOC", 
				formWidgetClass,
				top_norm_choice,
				normchoice_arg,
			 	XtNumber(normchoice_arg));

/* Init NiceBip */
  NiceBip =(ScaleStruct *) calloc(sizeof(ScaleStruct), 1 ) ;
/* initialise path for the call back */
 for ( counter = 0 ; counter < 4 ; counter++ )
  {
  NiceBip->laroute[counter] = theway[counter] ;
  } ;
 NiceBip->kill = father ;
 NiceBip->hurt = top_norm_choice ;
 for ( counter = 0 ; counter < 2 ; counter++ )
  {
  NiceBip->normneuron[counter] = scaleneuron[counter] ;
  NiceBip->normweight[counter] = scaleweight[counter] ;
  } ;

 XtSetArg(anynorm_arg[0],XtNfromVert,NULL) ;

 sprintf(bypass , "Neuron(%f <-> %f)" , 
             scaleneuron[0] , 
	     scaleneuron[1]
        ) ;
 XtSetArg(anynorm_arg[1],XtNlabel, bypass) ;

   norm_neuron = XtCreateManagedWidget("",
				commandWidgetClass,
				norm_choice,
				anynorm_arg,
				XtNumber(anynorm_arg));

XtAddCallback(norm_neuron, XtNcallback,
		Neuron_change, (caddr_t)NULL) ;


 XtSetArg(anynorm_arg[0],XtNfromVert,norm_neuron) ;

 sprintf(bypass , "Synapse(%f <-> %f)" , 
             scaleweight[0] , 
	     scaleweight[1]
        ) ;
 XtSetArg(anynorm_arg[1],XtNlabel, bypass) ;

   norm_weight = XtCreateManagedWidget("",
				commandWidgetClass,
				norm_choice,
				anynorm_arg,
				XtNumber(anynorm_arg));

XtAddCallback(norm_weight, XtNcallback,
		Weight_change, (caddr_t)NULL) ;

 XtSetArg(anynorm_arg[0],XtNfromVert, norm_weight) ;


 sprintf(bypass , " Keep the current scale " ) ; 
 XtSetArg(anynorm_arg[1],XtNlabel, bypass) ;

   cancel = XtCreateManagedWidget(" Keep the current scale  ",
				commandWidgetClass,
				norm_choice,
				anynorm_arg,
				XtNumber(anynorm_arg));

XtAddCallback(cancel, XtNcallback,
		Cancel_norm, (caddr_t)NULL) ;

/* compiled the new translation */
  command_compiled = XtParseTranslationTable(command_trans) ;
  XtOverrideTranslations(norm_neuron, command_compiled) ;
  XtOverrideTranslations(norm_weight, command_compiled) ;
  XtOverrideTranslations(cancel, command_compiled) ;

/* 
 * Use of XtGrabExclusive 
 * in order to oblige the user to choose an association USEFULL ???
 */
/* CHANGE */
/*	XtPopup(top_norm_choice, XtGrabNone);   */
XtRealizeWidget(top_norm_choice);
XQueryPointer(XtDisplay(top_norm_choice), XtWindow(top_norm_choice), &junk_win, &junk_win, &x_root, &y_root, &garbage, &garbage, &garbage_mask);
XtSetArg(normchoice_arg[0],XtNx, x_root-20) ;
XtSetArg(normchoice_arg[1],XtNy, y_root-20) ;
XtSetValues(top_norm_choice, normchoice_arg, XtNumber(normchoice_arg));
XtMapWidget(top_norm_choice);

/* Change the cursor ; beomes an arrow */
thedisplay = XtDisplay(top_norm_choice) ;
thewindow = XtWindow(top_norm_choice) ;
thecursor = XCreateFontCursor(thedisplay , XC_sb_right_arrow) ;
XDefineCursor(thedisplay, thewindow , thecursor
) ;


}

