/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 3/3/90
 *
 * pgm 
 *
 * ComponentScale.c
 ******************************************************************************/

#include "everything.h"
#include "mymonitor.h"
#include "mike_display.h"

/*--------------------------------------------------*/
/* THIS PROCEDURE DEALS WITH THE CHOICE OF THE COMPONENT */
/* IT IS CALLED FROM NEWSCALE.C AND TAKES THE FULL PATH  */
/*--------------------------------------------------*/
/* COMMENTS */
/* Always pop up max number of the level concerned  number-button-boxes */
/*          because I assume the user can open from any Level Window */
/* 	    any other Level Window */

Arg comptopcontrol_arg[] = {
                {XtNx, (XtArgVal)0},
                {XtNy, (XtArgVal)0},
        };

/*--------------------------------------------------*/
/* *  Global variables */
int thenewpath[4] ;
int last ;
Bool level_normal[4]  ;
/* Bool "level_normal" */
/* "where" shows 0 => net index in the path */
/*		 1 => layer index in the path */
/*		 2 => cluster index in the path */
/*		 3 => neurons index in the path */

/*--------------------------------------------------*/
/* set the new path all to -1 */
void SetPath()
 {
int i ;

 for( i = 0 ; i<=3 ; i++) { thenewpath[i] = -1 ; } ;
 }

/*----------------------------------------------*/
/* CALL BACK OF ALL THE COMMANDS ASSOCIATED WITH OPEN+SCALE */
/*---------------------------------------------*/
/* ENTER_CALLBACK() = 				*/

  void enter_callback(initiateur, client_data, call_data)
  Widget initiateur;
  Widget client_data;  /* used to get topcontrol to pop it down */
  caddr_t call_data;     /* not used  */
  {
/* Feb 01 => labelling changes according if normal or not substract one */
  switch (last)
     {
     case 1 : /* net level */
	if (!level_normal[0]) thenewpath[0] = thenewpath[0] - 1 ;
        break ;
     case 2 : /* layer level */
	if (!level_normal[0]) thenewpath[0] = thenewpath[0] - 1 ;
	if (!level_normal[1]) thenewpath[1] = thenewpath[1] - 1 ;
        break ;
     case 3 : /* cluster level */
	if (!level_normal[0]) thenewpath[0] = thenewpath[0] - 1 ;
	if (!level_normal[1]) thenewpath[1] = thenewpath[1] - 1 ;
	if (!level_normal[2]) thenewpath[2] = thenewpath[2] - 1 ;
        break ;
     case 4 : /* neuron level */
	if (!level_normal[0]) thenewpath[0] = thenewpath[0] - 1 ;
	if (!level_normal[1]) thenewpath[1] = thenewpath[1] - 1 ;
	if (!level_normal[2]) thenewpath[2] = thenewpath[2] - 1 ;
	if (!level_normal[3]) thenewpath[3] = thenewpath[3] - 1 ;
        break ;
    } ;       
 
/* check if the path given is right */
     if ( CheckPath(thenewpath,last) )
        {
	Monitor_create(thenewpath) ;
/* Fil the assoc family with colourmap <=> state ie 0 */
        FillAssocFamily(thenewpath , 0) ;
        FillThreshold(thenewpath , 0.5) ;
/*	XtPopdown(client_data) ;*/
XtUnmapWidget(client_data) ;
        } 
     else XtUnmapWidget(client_data) ;
  }

/* ZERO_COMPONENT_CALLBACK() = 				*/
  void zero_component_callback(initiateur, where, call_data)
  Widget initiateur;
  int where ;  /* used to know what scale has been selected */
  caddr_t call_data;     /* not used  */
  {

/* accumulate in the newpath[where] the int coze can be > 9 */
     if ( thenewpath[where] != -1)  
        thenewpath[where] = thenewpath[where] * 10  + 0  ;
     else {
          if (level_normal[where]) thenewpath[where] = 0 ;    
	  else { Error(25) ; return ; } ;
          } ;

  }
 
/* ONE_COMPONENT_CALLBACK() = 				*/
  void one_component_callback(initiateur, where , call_data)
  Widget initiateur;
  int where;  /* used to know what scale has been selected */
  caddr_t call_data;     /* not used  */
  {
/* accumulate in the newpath[where] the int coze can be > 9 */
     if ( thenewpath[where] != -1)  
        thenewpath[where] = thenewpath[where] * 10  + 1  ;
     else   thenewpath[where] = 1 ;    
  }

/* TWO_COMPONENT_CALLBACK() = 				*/
  void two_component_callback(initiateur, where, call_data)
  Widget initiateur;
  int where ;  /* used to know what scale has been selected */
  caddr_t call_data;     /* not used  */
  {
/* accumulate in the newpath[where] the int coze can be > 9 */
     if ( thenewpath[where] != -1)  
        thenewpath[where] = thenewpath[where] * 10  + 2  ;
     else   thenewpath[where] = 2 ;    
  }

/* THREE_COMPONENT_CALLBACK() = 				*/
  void three_component_callback(initiateur, where, call_data)
  Widget initiateur;
  int where ;  /* used to know what scale has been selected */
  caddr_t call_data;     /* not used  */
  {
/* accumulate in the newpath[where] the int coze can be > 9 */
     if ( thenewpath[where] != -1)  
        thenewpath[where] = thenewpath[where] * 10  + 3  ;
     else   thenewpath[where] = 3 ;    
  }
/* FOUR_COMPONENT_CALLBACK() = 				*/
  void four_component_callback(initiateur, where , call_data)
  Widget initiateur;
  int where ;  /* used to know what scale has been selected */
  caddr_t call_data;     /* not used  */
  {
/* accumulate in the newpath[where] the int coze can be > 9 */
     if ( thenewpath[where] != -1)  
        thenewpath[where] = thenewpath[where] * 10  + 4  ;
     else   thenewpath[where] = 4 ;    
  }
/* FIVE_COMPONENT_CALLBACK() = 				*/
  void five_component_callback(initiateur, where, call_data)
  Widget initiateur;
  int where ;  /* used to know what scale has been selected */
  caddr_t call_data;     /* not used  */
  {
/* accumulate in the newpath[where] the int coze can be > 9 */
     if ( thenewpath[where] != -1)  
        thenewpath[where] = thenewpath[where] * 10  + 5  ;
     else   thenewpath[where] = 5 ;    

  }
/* SIX_COMPONENT_CALLBACK() = 				*/
  void six_component_callback(initiateur, where, call_data)
  Widget initiateur;
  int where ;  /* used to know what scale has been selected */
  caddr_t call_data;     /* not used  */
  {
/* accumulate in the newpath[where] the int coze can be > 9 */
     if ( thenewpath[where] != -1)  
        thenewpath[where] = thenewpath[where] * 10  + 6  ;
     else   thenewpath[where] = 6 ;    
  }
/* SEVEN_COMPONENT_CALLBACK() = 				*/
  void seven_component_callback(initiateur, where , call_data)
  Widget initiateur;
  int where ;  /* used to know what scale has been selected */
  caddr_t call_data;     /* not used  */
  {
/* accumulate in the newpath[where] the int coze can be > 9 */
     if ( thenewpath[where] != -1)  
        thenewpath[where] = thenewpath[where] * 10  + 7  ;
     else   thenewpath[where] = 7 ;    
  }
/* EIGHT_COMPONENT_CALLBACK() = 				*/
  void height_component_callback(initiateur, where , call_data)
  Widget initiateur;
  int where ;  /* used to know what scale has been selected */
  caddr_t call_data;     /* not used  */
  {
/* accumulate in the newpath[where] the int coze can be > 9 */
     if ( thenewpath[where] != -1)  
        thenewpath[where] = thenewpath[where] * 10  + 8  ;
     else   thenewpath[where] = 8 ;    
  }

/* NEUF_COMPONENT_CALLBACK() = 				*/
  void nine_component_callback(initiateur, where, call_data)
  Widget initiateur;
  int where ;  /* used to know what scale has been selected */
  caddr_t call_data;     /* not used  */
  {
/* accumulate in the newpath[where] the int coze can be > 9 */
     if ( thenewpath[where] != -1)  
        thenewpath[where] = thenewpath[where] * 10  + 9  ;
     else   thenewpath[where] = 9 ;    
  }
/*--------------------------------------------------*/
/*  PROC CALLLED FROM NEWSCALE.C
/*
 * this call back proc creates a menu list widget
 * which allows the user to give the full path  
 * new graphic env.
*/
  void Component( father, grand_father , whichopen)
  Widget father , grand_father ;
  int whichopen ; /* contains only the new scale (net or layer or..) */
		  /* 1 => net ; 2 => layer , 3 => cluster ; 4 => neuron */
  {
   Widget  comptop_control , 
	 control ,
		component_title[4] , 
		componumber[40] ,
		enter ;
   int i , count , again,  starting  ;
   int loopnumber , previousloop , escapepath[4] ;
   char name_number[150] ;

  static String command_trans = "<LeaveWindow>:unset()\n\
        			 <EnterWindow>:unset()\n\
				 <Btn1Down>:set()\n\
				 <Btn1Up>:notify() unset() highlight()" ;

XtTranslations command_compiled ;
Window junk_win;
int x_root, y_root,garbage;
unsigned int garbage_mask;

/* Change the cursor */
 Cursor thetried_cursor ; Display *thetried_display ; Window thetried_window ;

/*  Position *relativeX , *relativeY ;
  Position theX ,theY ;
*/
/* Arguments for the children of the Form*/
/* Args for any command widget */
        static Arg anycommand_arg[] = {
                {XtNfromVert, (XtArgVal)NULL},
                {XtNfromHoriz, (XtArgVal)NULL},
                {XtNlabel, (XtArgVal)NULL},
                {XtNvertDistance, (XtArgVal)1},
                {XtNhorizDistance, (XtArgVal)2},
/* MIKE CHANGE for foreground */
                {XtNdestroyCallback, (XtArgVal)NULL},
                } ;

  static Arg componenttitle_arg[] = {
         {XtNfromVert, (XtArgVal)NULL},
         {XtNfromHoriz, (XtArgVal)NULL},
        {XtNlabel, (XtArgVal)NULL} ,
         {XtNvertDistance, (XtArgVal)1},
         {XtNhorizDistance, (XtArgVal)2},
        } ;

  static Arg enter_arg[] = {
                {XtNfromVert, (XtArgVal)NULL},
                {XtNfromHoriz, (XtArgVal)NULL},
                {XtNvertDistance, (XtArgVal)1},
                {XtNhorizDistance, (XtArgVal)2},
/* MIKE CHANGE for foreground */
                {XtNdestroyCallback, (XtArgVal)NULL},
	       } ;

/* obligation for the control widget not to have a NULL size */
        static Arg control_arg[] = {
/* MIKE CHANGE */
                {XtNdestroyCallback, (XtArgVal)NULL},
                } ;

/* Args for comptop_control menu widget */


  last = whichopen  ;

/*  relativeX = 0 ;
  relativeY = 0 ;
 XtTranslateCoords(father, relativeX , relativeY , &theX , &theY ) ;

 XtSetArg(topcontrol_arg[0],XtNx, theX) ;
 XtSetArg(topcontrol_arg[1],XtNy, theY + 25) ;
*/
        comptop_control = XtCreatePopupShell("Path",
                                overrideShellWidgetClass,
                                father,
                                comptopcontrol_arg,
                                XtNumber(comptopcontrol_arg));


             control = XtCreateManagedWidget("path Menu",
                                formWidgetClass,
                                comptop_control,
                                control_arg,
                                XtNumber(control_arg) );

/* Set the new path to be the system LWindow */
 SetPath() ;

/* for the first pass on the loop vertical distance is NULL */
  XtSetArg(anycommand_arg[0],XtNfromVert, NULL ) ;
 XtSetArg(componenttitle_arg[0],XtNfromVert, NULL ) ;

/* According to the scale pop up as many (0 1 2 3 4 5 6 7 8 9) */
/* menu as needed */

 for ( i = 0 ; i < 4 ; i++)
    escapepath[i] = -1 ;

/* starting can be either 0 or 1 ; 0=> More than one net */
/*				   1=> ONE NET          */
 if (GiveNumber(thenewpath) == 1 )
    {
    thenewpath[0] = 0 ;  /* The net reference HAS to be the first => 0 */
    escapepath[0] = 0 ;
    starting = 1 ;
    }
 else
    starting = 0 ;

 for (i = 0 ; i < 4 ; i++)
   level_normal[i] = True ;
 loopnumber = GiveMaxNumber(escapepath) ;
 if (loopnumber > 9 ) { loopnumber = 10 ; level_normal[starting] = False ;} ;
 previousloop = 0 ;
 command_compiled = XtParseTranslationTable(command_trans) ;
 
 for (count = starting ; count < whichopen ; count++)
 {

 switch(count)
        {
        case 0 : XtSetArg(componenttitle_arg[2],XtNlabel, "Net     ") ;
                  break ;
        case 1 : XtSetArg(componenttitle_arg[2],XtNlabel, "Layer   ") ;
                  break ;
        case 2 : XtSetArg(componenttitle_arg[2],XtNlabel, "Cluster ") ;
                  break ;
        case 3 : XtSetArg(componenttitle_arg[2],XtNlabel, "Neuron  ");
                  break ;
        } ;
 
/* create the title widgets */
 if (count != 0 && count != starting)
  XtSetArg(componenttitle_arg[0],XtNfromVert, component_title[count-1]) ;
 XtSetArg(componenttitle_arg[1],XtNfromHoriz, NULL ) ;
             component_title[count] = XtCreateManagedWidget("",
                                commandWidgetClass,
                                control,
                                componenttitle_arg,
                                XtNumber(componenttitle_arg) );

/* create the number command widgets */
  for (again = 0 ; again < loopnumber ; again++)
  { 

 if (count != 0 && count != starting)
     XtSetArg(anycommand_arg[0],XtNfromVert, component_title[count-1]) ;
 else
     XtSetArg(anycommand_arg[0],XtNfromVert, NULL) ;

 if (again > 0)
     XtSetArg(anycommand_arg[1],XtNfromHoriz, 
		componumber[again-1 +previousloop]  ) ;
 else
     XtSetArg(anycommand_arg[1],XtNfromHoriz, component_title[count]  ) ;

/* assign the label */
/* Feb 01 => labelling changes */
  if (level_normal[count])
 	{
        sprintf(name_number , " %i " , again+1 ) ;
        XtSetArg(anycommand_arg[2],XtNlabel, name_number ) ;
 	}
  else
 	{
        sprintf(name_number , " %i " , again ) ;
        XtSetArg(anycommand_arg[2],XtNlabel, name_number ) ;
 	}

     componumber[again + previousloop] = XtCreateManagedWidget("",
                                commandWidgetClass,
                                control,
                                anycommand_arg,
                                XtNumber(anycommand_arg) );

  XtOverrideTranslations(componumber[again +previousloop],
                command_compiled) ;

/* create the corresponding callbacks */
switch (again) {
  case 0 : 
       XtAddCallback(componumber[again +previousloop],
                XtNcallback, zero_component_callback, (caddr_t)count) ;
           break ;
  case 1 : XtAddCallback(componumber[again +previousloop] ,
                XtNcallback, one_component_callback, (caddr_t)count) ;
           break ;
  case 2 : XtAddCallback(componumber[again +previousloop],
                XtNcallback, two_component_callback, (caddr_t)count) ;
           break ;
  case 3 : XtAddCallback(componumber[again +previousloop],
                XtNcallback, three_component_callback, (caddr_t)count) ;
           break ;
  case 4 : XtAddCallback(componumber[again +previousloop],
                XtNcallback, four_component_callback, (caddr_t)count) ;
           break ;
  case 5 : XtAddCallback(componumber[again +previousloop],
                XtNcallback, five_component_callback, (caddr_t)count) ;
           break ;
  case 6 : XtAddCallback(componumber[again +previousloop],
                XtNcallback, six_component_callback, (caddr_t)count) ;
           break ;
  case 7 : XtAddCallback(componumber[again +previousloop],
                XtNcallback, seven_component_callback, (caddr_t)count) ;
           break ;
  case 8 : XtAddCallback(componumber[again +previousloop],
                XtNcallback, height_component_callback, (caddr_t)count) ;
           break ;
  case 9 : XtAddCallback(componumber[again +previousloop],
                XtNcallback, nine_component_callback, (caddr_t)count) ;
           break ;
           }  ;
/* end of the case */

        }  ;
/* end of the for again loop */

/* assign the new from loop according to max number */
switch (count) {
   case 0 :
/* next step => net level => max nbe of layers */
      escapepath[0] = 0 ;
      previousloop = loopnumber  ;
      loopnumber= GiveMaxNumber(escapepath) ;
      if (loopnumber > 9 ) { loopnumber = 10 ; level_normal[1] = False ;} ;
      break ;
   case 1 :
/* next step => layer level => max nbe of clusters */
      escapepath[0] = 0 ; escapepath[1] = 0 ;
      previousloop = loopnumber  ;
      loopnumber = GiveMaxNumber(escapepath) ;
      if (loopnumber > 9 ) { loopnumber = 10 ; level_normal[2] = False ;} ;
      break ;
   case 2 :
/* next step => cluster level => max nbe of neurons */
      escapepath[0] = 0 ; escapepath[1] = 0 ;
      escapepath[2] = 0 ;
      previousloop = loopnumber  ;
      loopnumber = 10 ; /* always more than 10 neurons */
      if (loopnumber > 9 ) { loopnumber = 10 ; level_normal[3] = False ;} ;
      break ;
           }  ;
/* end of the case */


 } ;
/* END OF THE FOR COUNT LOOP */

    XtSetArg(enter_arg[0],XtNfromVert, component_title[whichopen -1 ]) ;
    XtSetArg(enter_arg[1],XtNfromHoriz, NULL) ;

     enter = XtCreateManagedWidget("ENTER",
                                commandWidgetClass,
                                control,
                                enter_arg,
                                XtNumber(enter_arg) );
     XtAddCallback(enter , XtNcallback,
		enter_callback, (caddr_t)comptop_control) ;


/* REALIZE */
/*	XtPopup(comptop_control, XtGrabExclusive);   */
XtRealizeWidget(comptop_control);
XQueryPointer(XtDisplay(comptop_control), XtWindow(comptop_control), &junk_win, &junk_win, &x_root, &y_root, &garbage, &garbage, &garbage_mask);
XtSetArg(comptopcontrol_arg[0],XtNx, x_root-20) ;
XtSetArg(comptopcontrol_arg[1],XtNy, y_root-20) ;
XtSetValues(comptop_control, comptopcontrol_arg, XtNumber(comptopcontrol_arg));
XtMapWidget(comptop_control);


/* Pop down the OPEN/CLOSE and SYSTEM/NET/LAYER... before taking the path */
XtUnmapWidget(grand_father);
/*  XtPopdown(grand_father) ;*/
/*  XtPopdown(father) ;*/  /* COZ father gets pop down because of translation */
XtUnmapWidget(father);

/* Change the cursor ; beomes an arrow */
thetried_display = XtDisplay(control) ;
thetried_window = XtWindow(control) ;
thetried_cursor = XCreateFontCursor(thetried_display , XC_circle) ;
XDefineCursor(thetried_display, thetried_window , thetried_cursor) ;

}
