/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 3/3/90
 *
 * pgm 
 *
 * Colour.c
 ******************************************************************************/

#include "mymonitor.h"
#include "mike_display.h"
  
/*--------------------------------------------------*/
/*--------------------------------------------------*/
/* COLOURMAP */
/*--------------------------------------------------*/
/*--------------------------------------------------*/

/* CAUTION */
/* Global NiceHary to be known by all callbacks */
  ColourStructure  *NiceHary ;

Arg colourchoice_arg[] = {
                {XtNx, (XtArgVal)0},
                {XtNy, (XtArgVal)0},
                {XtNdestroyCallback, (XtArgVal)NULL},
	};


/*--------------------------------------------------*/
/* CALLBACK PROCS OF THE <NAME>CHOICE WIDGET*/


/*--------------------------------------------------*/
/*  the user chooses  the  RED */
  void Red_choice(initiateur, client_data, call_data)
  Widget initiateur;
  caddr_t client_data;  
  caddr_t call_data;     /* not used  */
  {
  int i ;

   if (NiceHary->low_colour != 'n' ) 
             {
             NiceHary->high_colour = 'r' ;
/*             XtPopdown(NiceHary->kill) ;
             XtPopdown(NiceHary->hurt) ;
*/
XtUnmapWidget(NiceHary->kill) ;
XtUnmapWidget(NiceHary->hurt) ;
/* Call To Mike level_colour and redraw_graphic */
         level_color(NiceHary->path_current, 
                     NiceHary->low_colour , 
                     NiceHary->high_colour);
/*         redraw_graphic_window(NiceHary->drawing  ,
                               NiceHary->path_current ) ;*/
SplatColors(XtDisplay(NiceHary->drawing), XtWindow(NiceHary->drawing));
/* END Call To Mike level_colour and redraw_graphic */

             }  
   else NiceHary->low_colour = 'r' ;
 }

/* call to MIke  REDRAW */
/* redraw(NiceHary->drawing  , NiceHary->path_current ,
 *         NiceHary->low_colour , NiceHary->high_colour ,
*/

/*--------------------------------------------------*/
/* the user chooses the GREEN */
  void Green_choice(initiateur, client_data, call_data)
  Widget initiateur;
  caddr_t client_data;  
  caddr_t call_data;     /* not used  */
  {

   if (NiceHary->low_colour != 'n' ) 
             {
             NiceHary->high_colour = 'g' ;
/*             XtPopdown(NiceHary->kill) ;
             XtPopdown(NiceHary->hurt) ;
*/
XtUnmapWidget(NiceHary->kill) ;
XtUnmapWidget(NiceHary->hurt) ;

/* Call To Mike level_colour and redraw_graphic */
         level_color(NiceHary->path_current, 
                     NiceHary->low_colour , 
                     NiceHary->high_colour);
/*         redraw_graphic_window(NiceHary->drawing  ,
                               NiceHary->path_current ) ;
*/
SplatColors(XtDisplay(NiceHary->drawing), XtWindow(NiceHary->drawing));

/* END Call To Mike level_colour and redraw_graphic */
             }  
   else NiceHary->low_colour = 'g' ;
}

/*--------------------------------------------------*/
/*  the user chooses the BLUE */
  void Blue_choice(initiateur, client_data, call_data)
  Widget initiateur;
  caddr_t client_data;  
  caddr_t call_data;     /* not used  */
  {

  if (NiceHary->low_colour != 'n' ) 
             {
             NiceHary->high_colour = 'b' ;
/*             XtPopdown(NiceHary->kill) ;
             XtPopdown(NiceHary->hurt) ;
*/
XtUnmapWidget(NiceHary->kill) ;
XtUnmapWidget(NiceHary->hurt) ;

/* Call To Mike level_colour and redraw_graphic */
         level_color(NiceHary->path_current, 
                     NiceHary->low_colour , 
                     NiceHary->high_colour);
/*         redraw_graphic_window(NiceHary->drawing  ,
                               NiceHary->path_current ) ;
*/
SplatColors(XtDisplay(NiceHary->drawing), XtWindow(NiceHary->drawing));

/* END Call To Mike level_colour and redraw_graphic */
             }  
  else NiceHary->low_colour = 'b' ;
}

/*--------------------------------------------------*/
/*  the user chooses the GREY SCALE */
  void Grey_choice(initiateur, client_data, call_data)
  Widget initiateur;
  caddr_t client_data;  
  caddr_t call_data;     /* not used  */
  {

  NiceHary->low_colour = 'm'  ;
  NiceHary->high_colour = 'm' ;
/*  XtPopdown(NiceHary->kill) ;
  XtPopdown(NiceHary->hurt) ;
*/
XtUnmapWidget(NiceHary->kill) ;
XtUnmapWidget(NiceHary->hurt) ;
/* Call To Mike level_colour and redraw_graphic */
  level_color(NiceHary->path_current, 
  		NiceHary->low_colour , 
                NiceHary->high_colour);
/*         redraw_graphic_window(NiceHary->drawing  ,
                               NiceHary->path_current ) ;
*/
SplatColors(XtDisplay(NiceHary->drawing), XtWindow(NiceHary->drawing));

}

/*--------------------------------------------------*/
/* THIS PROC TAKES CARE OF THE COLOURS (Red, Green, Blue )    */
/* 			OR OF THE GREY SCALE    	      */ 
/*
 * this proc allows the user to set the upper and lower bound
 *  first colour selected = lower, second = upper 
 * for the association COLOR-ACTIVATION LEVEL 
*/
  void Colour(theway , father , gody)
  int theway[4] ;
  Widget father , gody  ; /* it is level_display */
  {
 Widget  colour_choice ,
	 factice_colour_choice ,
 		red_choice , green_choice , blue_choice ,
            grey_colour_choice ;
extern Arg colourchoice_arg[3];
Window junk_win;
int x_root, y_root,garbage;
unsigned int garbage_mask;

 int counter ;

/* Args to get the location */
/*  Position *relativeX , *relativeY ;
  Position theX , theY ;
*/
/* Args for colour_choice list widget */

/* Args for red-green and blue, command widget */
  static Arg anycolour_arg[] = {
                {XtNfromHoriz, (XtArgVal)NULL},
                {XtNlabel, (XtArgVal)NULL},
                {XtNfromVert, (XtArgVal)NULL},
                {XtNhorizDistance, (XtArgVal)1},
                {XtNvertDistance, (XtArgVal)1},
	        };


/* Take the location of the father menu to pop it up properly */
/*  relativeX = 0 ;
  relativeY = 0 ;
  XtTranslateCoords(father ,relativeX ,relativeY ,&theX ,&theY);
  XtSetArg(colourchoice_arg[0],XtNx, theX+10) ;
  XtSetArg(colourchoice_arg[1],XtNy, theY) ;
*/
	colour_choice = XtCreatePopupShell("COLOUR", 
				overrideShellWidgetClass,
				father,
				colourchoice_arg,
			 	XtNumber(colourchoice_arg));


	factice_colour_choice = XtCreateManagedWidget("FACTICE", 
				formWidgetClass,
				colour_choice,
				colourchoice_arg,
			 	XtNumber(colourchoice_arg));

/* Init NiceHary */
  NiceHary =(ColourStructure *) calloc(sizeof(ColourStructure), 1 ) ;
/* initialise path for the call back */
 for ( counter = 0 ; counter < 4 ; counter++ )
  {
  NiceHary->path_current[counter] = theway[counter] ;
  } ;
 NiceHary->drawing = gody ; 
 NiceHary->kill = father ;
 NiceHary->hurt = colour_choice ;
 NiceHary->low_colour = 'n' ;
 NiceHary->high_colour = 'n' ;

 XtSetArg(anycolour_arg[2],XtNfromVert,NULL) ;


 XtSetArg(anycolour_arg[0],XtNfromHoriz,NULL) ;

	   red_choice = XtCreateManagedWidget("    Red    ",
				commandWidgetClass,
				factice_colour_choice,
				anycolour_arg,
				XtNumber(anycolour_arg));

XtAddCallback(red_choice, XtNcallback,
		Red_choice, (caddr_t)NULL) ;


 XtSetArg(anycolour_arg[0],XtNfromHoriz,red_choice) ;

	   green_choice = XtCreateManagedWidget("    Green    ",
				commandWidgetClass,
				factice_colour_choice,
				anycolour_arg,
				XtNumber(anycolour_arg));

XtAddCallback(green_choice, XtNcallback,
		Green_choice, (caddr_t)NULL) ;

 XtSetArg(anycolour_arg[0],XtNfromHoriz, green_choice) ;

	   blue_choice = XtCreateManagedWidget("    Blue    ",
				commandWidgetClass,
				factice_colour_choice,
				anycolour_arg,
				XtNumber(anycolour_arg));

XtAddCallback(blue_choice, XtNcallback,
		Blue_choice, (caddr_t)NULL) ;

 XtSetArg(anycolour_arg[0],XtNfromHoriz, NULL) ;
 XtSetArg(anycolour_arg[2],XtNfromVert, red_choice) ;

	   grey_colour_choice = XtCreateManagedWidget("      Grey Scale       ",
				commandWidgetClass,
				factice_colour_choice,
				anycolour_arg,
				XtNumber(anycolour_arg));

XtAddCallback(grey_colour_choice, XtNcallback,
		Grey_choice, (caddr_t)NULL) ;

/* 
 * Use of XtGrabExclusive 
 * in order to oblige the user to choose a color USEFULL ???
 */
/*	XtPopup(colour_choice, XtGrabExclusive);   */
XtRealizeWidget(colour_choice);
XQueryPointer(XtDisplay(colour_choice), XtWindow(colour_choice), &junk_win, &junk_win, &x_root, &y_root, &garbage, &garbage, &garbage_mask);
XtSetArg(colourchoice_arg[0],XtNx, x_root-20) ;
XtSetArg(colourchoice_arg[1],XtNy, y_root-20) ;
XtSetValues(colour_choice, colourchoice_arg, XtNumber(colourchoice_arg));
XtMapWidget(colour_choice);


}

