/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**				                  			     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.01 30/1/90
 *
 * pgm 
 *
 * Patset_control.c
 ******************************************************************************/

#include "everything.h"
#include "myheader.h"

/* Globals about RPC used to get back configuration if it exists */
/* when going back to INTERACTIVE mode */
  extern CLIENT *myclient;
  extern char server[];
  extern confres *conf ; /* need to be global to be used in */
			/* Utilities.c at any time          */

/*----------------------------------------------*/
/* THIS PROC DEALS WITH				*/
/* 	1- The creation of the BATCH/INTERACT button    */
/*	2- The effect = call Take_input 	*/
/* 			 which will take the filename.appli */
/*			or more .....           */
/*----------------------------------------------*/



/*----------------------------------------------*/
/* EXTERN for the 1- father widget		*/
/* 	          2- neighbour(s) within the form	*/
/* 		  3- the created widget itself 	*/
/*	 	  4- all ,the one that have to be mapped and unmapped   */
extern Widget simulation ;

extern Widget batchmode ;
extern Widget step;
extern Widget continuous;

extern Widget interactmode ;
extern Widget pgmrun;
extern Widget pause;

extern Widget patset;
extern Widget pgmtarget;
extern Arg patset_arg[], pgmrun_arg[];

extern Widget appli_statement_text;
extern Widget appli_statement_param;

/*-----------------------------------------------------*/
/* ARGUMENTS FOR BATCH/INTERACT widget				*/
/*-----------------------------------------------------*/

/* Args for batchinteract widget */
	Arg batchinteract_arg[] = {
                {XtNfromVert, (XtArgVal)NULL},
                {XtNfromHoriz, (XtArgVal)NULL},
		{XtNmappedWhenManaged, (XtArgVal)False},
                {XtNhighlightThickness, (XtArgVal)3},
/* MIKE CHANGE for foreground */
                {XtNdestroyCallback, (XtArgVal)NULL},
                {XtNhorizDistance, (XtArgVal)4},
                {XtNvertDistance, (XtArgVal)2},
                {XtNwidth, (XtArgVal)2*BUTTON_WIDTH},
                {XtNheight, (XtArgVal)BUTTON_HEIGHT},
        };

/* test*/

/* When BATCH has been selected */
/* BATCH == INTERACT ; RUN == STEP ; PAUSE == CONTINUOUS */
/* Display currrent instructions */
  void BatchUnmap()
  {
   XtUnmapWidget(batchmode) ;
   XtUnmapWidget(pgmrun) ;
   XtUnmapWidget(pause) ;
   XtMapWidget(interactmode) ;
   XtMapWidget(step) ;
   XtMapWidget(continuous) ;
   XtMapWidget(appli_statement_text) ;
   XtMapWidget(appli_statement_param) ;

  }
 
  void InteractUnmap()
  {
   XtUnmapWidget(interactmode) ;
   XtUnmapWidget(step) ;
   XtUnmapWidget(continuous) ;
   XtMapWidget(batchmode) ;
   XtMapWidget(pgmrun) ;
   XtMapWidget(pause) ;
  }
 
/*----------------------------------------------*/
/* CALL BACK OF THE COMMAND BATCH/INTERACT      */
/*---------------------------------------------*/

  void Batch_callback(initiateur, client_data, call_data)
  Widget initiateur;
  caddr_t client_data;  /* */
  caddr_t call_data;     /* not used  */
  {
/* An application can be loaded if algo has been loaded */
        if (!my_algorithm )
          {
          Error(29) ;
          return ;
          } ;

/* The user has asked to execute in batch mode */
/* user has to input the application filename */
 	Take_input(initiateur,0) ; 
/* The unmapping of Run and Pause has been done in Take_input ie IOTake.c */
/* as weel as appli_statement_text and param */
/*        BatchUnmap() ; */
/*
/* XtMapWidget(appli_statement_text) ; */
/* XtMapWidget(appli_statement_param) ; */


  }

  void Interact_callback(initiateur, client_data, call_data)
  Widget initiateur;
  caddr_t client_data;  /* used as thepopup but no interest at the moment*/
  caddr_t call_data;     /* not used  */
  {
  fname str;  /* Filename */

  char buf[200] , buffy[200] ; 

/* The user has asked to go back to interactive mode */
        my_application = False ;

/* test if config or system loaded do not display empty */
  if (!my_configuration)
	{
	strcpy(buffy, "empty.nC" ) ;
   	sprintf(buf, "%s/%s" , rc[RC_error_message_directory], buffy) ;
	Add_information(3, buf) ;
	} 
/* there is a config => display it */
/* and allow run and pause */
  else
	{
/* RPC Call to get the configuration of the NN system */
            conf = rsysconf_1(str, myclient);
            if (!conf)
                {
               clnt_perror(myclient, server);
                return;
                }
            if (conf->errorn != 0)
                {
                Error(203) ;
                return;
                }
            show_rpconf(conf->confres_u.sys, str);
            Add_information(3, str) ;
        XtSetArg(patset_arg[9], XtNsensitive, (XtArgVal) True);
        XtSetValues(patset, patset_arg, 10);
        XtSetArg(pgmrun_arg[9], XtNsensitive, (XtArgVal) True);
        XtSetValues(pgmrun, pgmrun_arg, 10);

	} ;


        InteractUnmap() ;

XtUnmapWidget(appli_statement_text) ;
XtUnmapWidget(appli_statement_param) ;
  }
 
/*----------------------------------------------
 * CREATION OF THE BATCH/INTERACT command widget (proc name= BatchInteract)
/*----------------------------------------------*/
  void BatchInteract()
  {


/* BTN1UP = DEFAULT + RESET otherwise does not unhighlight */
/* Declaration of the translation table for init */
  static String menu_trans = "<Btn1Up>: notify() unset() reset()" ;
  XtTranslations menu_compiled ;

 XtSetArg(batchinteract_arg[0],XtNfromVert, patset) ;
 XtSetArg(batchinteract_arg[1],XtNfromHoriz,pgmtarget ) ;


/* create and map  batch mode */
        batchmode = XtCreateManagedWidget("  Batch  ",
                                commandWidgetClass,
                                simulation,
                                batchinteract_arg,
                                XtNumber(batchinteract_arg));


/* "Compile" the call back */
XtAddCallback(batchmode, XtNcallback,
        Batch_callback,(caddr_t)NULL) ;

/* create and not map interactive mode */
        interactmode = XtCreateManagedWidget(" Interactive ",
                                commandWidgetClass,
                                simulation,
                                batchinteract_arg,
                                XtNumber(batchinteract_arg));



/* "Compile" the call back */
XtAddCallback(interactmode, XtNcallback,
        Interact_callback,(caddr_t)NULL) ;


/* Compilation of the translation table for IO */
  menu_compiled = XtParseTranslationTable(menu_trans) ;
  XtOverrideTranslations(batchmode, menu_compiled) ;
  XtOverrideTranslations(interactmode, menu_compiled) ;


}
