/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 3/3/90
 *
 * pgm 
 *
 * AssocColour.c
 ******************************************************************************/

#include "mymonitor.h"

  
/*--------------------------------------------------*/
/*--------------------------------------------------*/
/*  ASSOCIATE COLOUR WITH			    */
/*		       1- STATES AND WEIGHTS        */
/*		       2- ERROR AND WEIGHTS        */
/*		       3- AND WEIGHTS        */
/*--------------------------------------------------*/
/*--------------------------------------------------*/
/* Structure to be known by the callbacks */

  static AssocStruct  *NiceJim ;
/* Args for colour_choice list widget */
Arg assocchoice_arg[] = {
                {XtNx, (XtArgVal)0},
                {XtNy, (XtArgVal)0},
                {XtNwidth, (XtArgVal)BIG_COLOUR_WIDTH},
                {XtNheight, (XtArgVal)BIG_COLOUR_HEIGHT},
                {XtNdestroyCallback, (XtArgVal)NULL},
	};


/*--------------------------------------------------*/
/* CALLBACK PROCS OF THE <NAME>CHOICE WIDGET*/


/*--------------------------------------------------*/
/*  the user chooses  the  STATES */
  void State_choice(initiateur, client_data, call_data)
  Widget initiateur;
  caddr_t client_data;  
  caddr_t call_data;     /* not used  */
  {

   FillAssocFamily(NiceJim->theroute , 0) ;
/*             XtPopdown(NiceJim->tokill) ;
             XtPopdown(NiceJim->tohurt) ;
*/
XtUnmapWidget(NiceJim->tokill);
XtUnmapWidget(NiceJim->tohurt);
   free(NiceJim) ;
 }

/*--------------------------------------------------*/
/* the user chooses the ERR */
  void Error_choice(initiateur, client_data, call_data)
  Widget initiateur;
  caddr_t client_data;  
  caddr_t call_data;     /* not used  */
  {

   FillAssocFamily(NiceJim->theroute , 1) ;
/*             XtPopdown(NiceJim->tokill) ;
             XtPopdown(NiceJim->tohurt) ;
*/ 
XtUnmapWidget(NiceJim->tokill);
XtUnmapWidget(NiceJim->tohurt);

free(NiceJim) ;
}

/*--------------------------------------------------*/
/*  the user chooses the TARGET */
  void Target_choice(initiateur, client_data, call_data)
  Widget initiateur;
  caddr_t client_data;  
  caddr_t call_data;     /* not used  */
  {
   FillAssocFamily(NiceJim->theroute , 2) ;

/*   XtPopdown(NiceJim->tokill) ;
   XtPopdown(NiceJim->tohurt) ;
*/
XtUnmapWidget(NiceJim->tokill);
XtUnmapWidget(NiceJim->tohurt);

   free(NiceJim) ;
  } 

/*--------------------------------------------------*/
/* THIS PROC TAKES CARE OF THE ASSOCIATION          */
/*
 * this proc allows the user to set the upper and lower bound
 *  first colour selected = lower, second = upper 
 * for the association COLOR-ACTIVATION LEVEL 
 * Comments =(OF THE NEURON BY DEFAULT FOR THE MOMENT)
 * OR for the association COLOR-NEURON OR COLOR-SYNAPSE
*/
  void AssocColour(theway , father)
  int theway[4] ;
  Widget father ; /* it is the menu  */
  {
 Widget  top_assoc_choice , assoc_choice ,
	 assoc_state_choice ,
 		assoc_error_choice , assoc_target_choice ;
 int counter ;
extern Arg assocchoice_arg[5];

Window junk_win;
int x_root, y_root,garbage;
unsigned int garbage_mask;

/* ENTER ANY COMMAND WINDOW = HIGHLIGHT */
  static String command_trans = "<EnterWindow>: set()" ;
  XtTranslations command_compiled ;

/* Change the cursor */
 Cursor thecursor ; Display *thedisplay ; Window thewindow ;

/* Args to get the location */
/*  Position *relativeX , *relativeY ;
  Position theX , theY ;
*/

/* Args for , command widget */
  static Arg anyassoc_arg[] = {
                {XtNfromVert, (XtArgVal)NULL},
                {XtNlabel, (XtArgVal)NULL},
                {XtNfromHoriz, (XtArgVal)NULL},
                {XtNhorizDistance, (XtArgVal)1},
                {XtNvertDistance, (XtArgVal)1},
                {XtNheight, (XtArgVal)COLOUR_HEIGHT},
        };


/* Take the location of the father menu to pop it up properly */
/*  relativeX = 0 ;
  relativeY = 0 ;
  XtTranslateCoords(father ,relativeX ,relativeY ,&theX ,&theY);
  XtSetArg(assocchoice_arg[0],XtNx, theX) ;
  XtSetArg(assocchoice_arg[1],XtNy, theY) ;
*/


	top_assoc_choice = XtCreatePopupShell("TOPASSOC", 
				overrideShellWidgetClass,
				father,
				assocchoice_arg,
			 	XtNumber(assocchoice_arg));


	assoc_choice = XtCreateManagedWidget("ASSOC", 
				formWidgetClass,
				top_assoc_choice,
				assocchoice_arg,
			 	XtNumber(assocchoice_arg));

/* Init NiceJim */
  NiceJim =(AssocStruct *) calloc(sizeof(AssocStruct), 1 ) ;
/* initialise path for the call back */
 for ( counter = 0 ; counter < 4 ; counter++ )
  {
  NiceJim->theroute[counter] = theway[counter] ;
  } ;
 NiceJim->tokill = father ;
 NiceJim->tohurt = top_assoc_choice ;

 XtSetArg(anyassoc_arg[0],XtNfromVert,NULL) ;

   assoc_state_choice = XtCreateManagedWidget("Colour <=> State (default)",
				commandWidgetClass,
				assoc_choice,
				anyassoc_arg,
				XtNumber(anyassoc_arg));

XtAddCallback(assoc_state_choice, XtNcallback,
		State_choice, (caddr_t)NULL) ;


 XtSetArg(anyassoc_arg[0],XtNfromVert,assoc_state_choice) ;

	   assoc_error_choice = XtCreateManagedWidget(" Colour <=> Error ",
				commandWidgetClass,
				assoc_choice,
				anyassoc_arg,
				XtNumber(anyassoc_arg));

XtAddCallback(assoc_error_choice, XtNcallback,
		Error_choice, (caddr_t)NULL) ;
 

  XtSetArg(anyassoc_arg[0],XtNfromVert,assoc_error_choice) ;

	   assoc_target_choice = XtCreateManagedWidget(" Colour <=> Tartget ",
				commandWidgetClass,
				assoc_choice,
				anyassoc_arg,
				XtNumber(anyassoc_arg));

XtAddCallback(assoc_target_choice, XtNcallback,
		Target_choice, (caddr_t)NULL) ;


/* compiled the new translation */
  command_compiled = XtParseTranslationTable(command_trans) ;
  XtOverrideTranslations(assoc_state_choice, command_compiled) ;
  XtOverrideTranslations(assoc_target_choice, command_compiled) ;
  XtOverrideTranslations(assoc_error_choice, command_compiled) ;

/* 
 * Use of XtGrabExclusive 
 * in order to oblige the user to choose an association USEFULL ???
 */
/*	XtPopup(top_assoc_choice, XtGrabExclusive);   */

XtRealizeWidget(top_assoc_choice);
XQueryPointer(XtDisplay(top_assoc_choice), XtWindow(top_assoc_choice), &junk_win, &junk_win, &x_root, &y_root, &garbage, &garbage, &garbage_mask);
XtSetArg(assocchoice_arg[0],XtNx, x_root-20) ;
XtSetArg(assocchoice_arg[1],XtNy, y_root-20) ;
XtSetValues(top_assoc_choice, assocchoice_arg, XtNumber(assocchoice_arg));
XtMapWidget(top_assoc_choice);


/* Change the cursor ; beomes an arrow */
thedisplay = XtDisplay(top_assoc_choice) ;
thewindow = XtWindow(top_assoc_choice) ;
thecursor = XCreateFontCursor(thedisplay , XC_sb_right_arrow) ;
XDefineCursor(thedisplay, thewindow , thecursor
) ;


}

