/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 3/3/90
 *
 * pgm 
 *
 * AppliRuleExec.c
 ******************************************************************************/

#include "rpcheader.h"
#include "everything.h" 
#include "mymonitor.h" 

#define rpc_free(x, p) if(p)xdr_free(x, p)

extern char server[];
extern CLIENT *myclient;

/*--------------------------------------------*/
/* Execution of a RULE NAME of the level THEWAY */
/*----------------------------------------------*/
/*----------------------------------------------------*/
  void AppliRuleExec(rule_name, theway)
  char *rule_name ;
  int theway[] ; /* Gives the full path for that level rule window */

  {
/* Declaration for RPC call */
  strctname rpcpara;
  int	i , counter ;
  static rec *rule_result ;

/* Call the RPC to get Rule information */
  rpcpara.indx[0] = 0;
  for (i=0; i<4; i++)
     rpcpara.indx[i+1] = theway[i];
  rpcpara.indx[5] = -1;
  rpcpara.namecode = N_RULE;

  rpc_free(xdr_rec, rule_result);

  rule_result = rnetstat_1(&rpcpara, myclient);

  if (!rule_result) {
     clnt_perror(myclient, server);
     return;
  }
/* the RPC has not return what we asked for */
  if (rule_result->errorn == -1) {
     Error(207) ;
     return;
  }

/* the RPC failed */
  if (rule_result->errorn != 1) {
     Error(207) ;
     return;
  }


/* if no rule then problem */
  if (rule_result->rec_u.names.fnarray_len == 0 )
    {
    printf("No rules at this level !!!\n") ;
    return ;
    }  ;

/* Find the rule which matches with the name given and execute it */

 for (counter = 0 ; counter < rule_result->rec_u.names.fnarray_len ; 
		counter++)
   {
/* if same name then execute */
   if(!strcmp(rule_result->rec_u.names.fnarray_val[counter].rule_name ,
       		rule_name ) )
     {
      MagaliExecute(
	rule_result->rec_u.names.fnarray_val[counter].rule_pointer) ;
      return ;
     } ;

   } ;

/* the user should not be here  !! */
   Error(84) ;


}

