/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 3/3/90
 *
 * pgm 
 *
 * util.c
 ******************************************************************************/

#include "pygmalion.h"
#include "sysdef.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <fcntl.h>
#include <strings.h>

extern	char	*jalloc();

char		my_getchar();

/*	Global variables	*/

system_type	*sys;

int		int_mode;
int		cycles;
int		dis_width = 8;			/* network display width */
float		rand_scale = .05;		/* the norm of randomised weights */
char		*n_order[4] = {"1st", "2nd", "3rd"};
int		out_fd, in_fd;
FILE		*infil, *pfil;

/*	--------------	utility function definitions -------------------------- */

char	*strdup ( s )		/* copy string into malloc'ed space */
char	*s;
{
	char	*c = ( char * ) malloc ( strlen ( s ) + 1 );

	strcpy ( c, s );
	return ( c );
}
/* --------------------------------------------------------------- */
/*  fexist tests if a file exits, is readable to the caller or a directory  */

int fexist(filename)
char *filename;
{
	struct stat buf;

	if (!stat(filename, &buf))
		if (buf.st_mode & S_IFDIR) {
			fprintf(stderr, "%s is a directory.\n", filename);
			return(FALSE);
		 }
		else if (!(buf.st_mode & S_IREAD)) {	
			fprintf(stderr, "%s read permission denied.\n", filename);
			return(FALSE);
		}
	else
		return(TRUE);

	return(FALSE);
}
/* --------------------------------------------------------------- */
int rand_weight()
{
	int i, j, k;
	cluster_type *cluster;
	char c;

	for (i=1; i<sys->net[0]->layers; i++)
	for (j=0; j<sys->net[0]->layer[i]->clusters; j++) {
		for (k=0; k<sys->net[0]->layer[i]->cluster[j]->neurons; k++) {
#ifdef	DEBUG_RANDOM
			printf( "rand_weight net [%d] layer[%d] cluster[%d] neuron[%d] fanin %d\n", 0, i, j, k, sys->net[0]->layer[i]->cluster[j]->neuron[k]->fanin);
#endif
			norm_rand_syn ( sys->net[0]->layer[i]->cluster[j]->neuron[k]->synapse,
					sys->net[0]->layer[i]->cluster[j]->neuron[k]->synapses, rand_scale );
		}
	}
	return( 0 );
}
/* --------------------------------------------------------------- */

void free_chain(elem)
any_elem **elem;
{
	any_elem *ptr;

	while (ptr = *elem) {
		*elem = ptr->next_ptr;
		free(ptr);
	}
}

/* --------------------------------------------------------------- */

int listln(list)
pat_elem *list;
{
	int cnt = 0;
	while(list) {
		list = list->next_ptr;
		cnt++;
	}
	return(cnt);
}

/* --------------------------------------------------------------- */

int_elem *last_elem(list)
int_elem *list;
{
	while (list->next_ptr)
		list = list->next_ptr;
	return(list);
}

/* --------------------------------------------------------------- */

int tree_check(tree, depth)
int_elem **tree;
int depth;
{
	int n;

	switch (depth) {
		case 0:	return(TRUE);	/* an empty sub-tree */
		case 1:	if (!(*tree))
				return(FALSE);
			*tree = (*tree)->next_ptr;
			return(TRUE);
		default: if (!*(tree))	/* no more elements for the tree structure */
				return(FALSE);
			n = (*tree)->val;
			*tree = (*tree)->next_ptr;
			while(n--) {
				if (!(*tree))	/* expecting a sub-tree structure */
					return(FALSE);
				if (!tree_check(tree, depth-1))
					return(FALSE);
			}
	}
	return(TRUE);
}

/* --------------------------------------------------------------- */

int ok_tree(tree, depth)
int_elem *tree;
int depth;
{
	if (tree_check(&tree, depth) && !tree)
		return(TRUE);
	return(FALSE);
}

/* --------------------------------------------------------------- */

void free_tree(tree)
int_elem *tree;
{
	int i;

	if (!tree)
		return;
	for (i=0; i<tree->val; i++)
		free_tree(tree->next_ptr[i]);
	free(tree->next_ptr);
	free(tree);
}
	
/* --------------------------------------------------------------- */
/*	recons_tree modified the TREE to have BRANCH subtrees and copies	*/
/*	TREE's original subtrees to the reconstructed tree when it is possible	*/

void recons_tree(tree, branch)
int_elem *tree;
int branch;
{
	int_elem *buf;
	int i, min;

	if (branch == tree->val)
		return;
	buf = tree->next_ptr;
	tree->next_ptr = (int_elem *) jalloc(sizeof(int_elem), branch);
	min = (branch < tree->val)? branch : tree->val;
	for (i=0; i<min; i++) {
		tree->next_ptr[i].val = buf[i].val;
		tree->next_ptr[i].next_ptr = buf[i].next_ptr;
	}
	while (i < tree->val)
		free_tree(buf[i++].next_ptr);
	if (buf)
		free(buf);
	tree->val = branch;
}
/* --------------------------------------------------------------- */
int YES()
{
	for (;;) {
		 switch(my_getchar()) {
			case 'y':
			case 'Y': return(TRUE);
			case 'n':
			case 'N': return(FALSE);
			default: printf("Answer yes/no:");
		 }
	}
}
/*
	Note, the function "int NO()" is defined in sysdef.h as follows:

	#define NO() !YES()
*/
/* --------------------------------------------------------------- */
/*	my_getchar treats EOF from the stream stdin as [CR]	*/

char my_getchar()
{
	char c[10];

	fflush(stdin);
	if ((gets(c)) == NULL) {
		 clearerr(stdin);
		 *c = '\r';
	}
	return(*c);
}
/* --------------------------------------------------------------- */
