/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 3/3/90
 *
 * pgm 
 *
 * jsave.c
 ******************************************************************************/

#include	"pygmalion.h"
#include	"sysdef.h"
#include	"pgmrc.h"
#include	<time.h>

extern	system_type	*sys;
extern	pat_elem	*pattern_list;
extern	char		*rc[];

FILE	*fd;

/* ------------------------------------------------------------------------ */
int	sys_save(filename)
char	filename[];
{
	int		i, j, k, l, m, p, start_layer;
	char		str[80];
	int		count = 8;	/* fields per line */
	long		clock;

	if (!filename[0]) {
		printf(stderr, "Filename is unknown.\n");
		return(FAIL);
	}
	if (fexist(filename)) {
		sprintf(str, "mv -f %s %s.bak", filename, filename);
		if (system(str)) {
			error("Warning: No system backup!\nSaving the current system will overwrite the prior system file.");
			return(FAIL);
		}
	}

	if (!(fd = fopen(filename, "w"))) {
		error("Can't open system file.\nSaving system failed.\n");
		return(FAIL);
	}

	fprintf ( fd, "#\tPygmalion system file : %s\n", filename );
	fprintf ( fd, "#\n" );
	fprintf ( fd, "#\t%s\n", rc[ RC_local_user] );
	fprintf ( fd, "#\t%s\n", rc[ RC_local_host] );
	fprintf ( fd, "#\n" );
	clock =  time ( (long *) 0 );
	fprintf ( fd, "#\t%s", ctime ( &clock ) );
	fprintf ( fd, "#\n" );

	fprintf(fd, "config\n");
	fprintf(fd, "%d\n", sys->nets);
	for (i=0; i<sys->nets; i++) {
		fprintf(fd, "%d\n", sys->net[i]->layers);
		for (j=0; j<sys->net[i]->layers; j++) {
			fprintf(fd, "%d\n", sys->net[i]->layer[j]->clusters);
			for (k=0; k<sys->net[i]->layer[j]->clusters; k++) {
				fprintf(fd, "%d\n", sys->net[i]->layer[j]->cluster[k]->neurons);
			}
		}
	}

	fprintf(fd, "parameters:\n");
	if ( sys->n_parameters ) {
		fprintf(fd, "parameters_in_sys %d\n", 0);
		for (p=0; p<sys->n_parameters; p++) {
			fprintf(fd, "%f\t# %s\n",	sys->parameters[p].parameter.value.f,
						sys->parameters[p].name);
/*			if ( ! ( (p + 1) % count ) ) fprintf(fd, "\n"); */
		}
		fprintf(fd, "\n");
	}
	for (i=0; i<sys->nets; i++) {
		if ( sys->net[i]->n_parameters ) {
			fprintf(fd, "parameters_in_net %d\n", i);
			for (p=0; p<sys->net[i]->n_parameters; p++) {
				fprintf(fd, "%f\t# %s\n",	sys->net[i]->parameters[p].parameter.value.f,
								sys->net[i]->parameters[p].name);
			}
			fprintf(fd, "\n");
		}

		for (j=0; j<sys->net[i]->layers; j++) {
			if ( sys->net[i]->layer[j]->n_parameters ) {
				fprintf(fd, "parameters_in_layer %d\n", j);
				for (p=0; p<sys->net[i]->layer[j]->n_parameters; p++) {
					fprintf(fd, "%f\t# %s\n",	sys->net[i]->layer[j]->parameters[p].parameter.value.f,
									sys->net[i]->layer[j]->parameters[p].name);
				}
				fprintf(fd, "\n");
			}

			for (k=0; k<sys->net[i]->layer[j]->clusters; k++) {
				if ( sys->net[i]->layer[j]->cluster[k]->n_parameters ) {
					fprintf(fd, "parameters_in_cluster %d\n", k);
					for (p=0; p<sys->net[i]->layer[j]->cluster[k]->n_parameters; p++) {
						fprintf(fd, "%f\t# %s\n",	sys->net[i]->layer[j]->cluster[k]->parameters[p].parameter.value.f,
										sys->net[i]->layer[j]->cluster[k]->parameters[p].name);
					}
					fprintf(fd, "\n");
				}
				for (l=0; l<sys->net[i]->layer[j]->cluster[k]->neurons; l++) {
					if ( sys->net[i]->layer[j]->cluster[k]->neuron[l]->n_parameters ) {
						fprintf(fd, "parameters_in_neuron %d\n", l);
						for (p=0; p<sys->net[i]->layer[j]->cluster[k]->neuron[l]->n_parameters; p++) {
							fprintf(fd, "%f\t# %s\n",	sys->net[i]->layer[j]->cluster[k]->neuron[l]->parameters[p].parameter.value.f,
											sys->net[i]->layer[j]->cluster[k]->neuron[l]->parameters[p].name);
						}
						fprintf(fd, "\n");
					}
				}
			}
		}
	}
	fprintf(fd, "\n");

	fprintf(fd, "states:\n");
	for (i=0; i<sys->nets; i++) {
		fprintf(fd, "states_in_net %d\n", i);
		for (j=0; j<sys->net[i]->layers; j++) {
			fprintf(fd, "states_in_layer %d\n", j);
			for (k=0; k<sys->net[i]->layer[j]->clusters; k++) {
				fprintf(fd, "states_in_cluster %d\n", k);
				for (l=0; l<sys->net[i]->layer[j]->cluster[k]->neurons; l++) {
					fprintf(fd, "%f\t", sys->net[i]->layer[j]->cluster[k]->neuron[l]->state[0].value.f);
					if ( ! ( (l + 1) % count ) ) fprintf(fd, "\n");
				}
				fprintf(fd, "\n");
			}
		}
	}
	fprintf(fd, "\n");

	fprintf(fd, "weights:\n");
	for (i=0; i<sys->nets; i++) {
		fprintf(fd, "weights_in_net %d\n", i);

		/* NOTE THAT the following assumption is not general - a better mechanism should be provided */
		if ( sys->net[i]->layers == 1 ) {	/* for multiple layers, assume that Layer 0 is the input layer	*/
			start_layer = 0;		/* for single layer, Layer 0 has self-connection */
		}
		else {
			start_layer = 1;
		}
		for (j=start_layer; j<sys->net[i]->layers; j++) {
			fprintf(fd, "weights_to_layer %d\n", j);
			for (k=0; k<sys->net[i]->layer[j]->clusters; k++) {
				fprintf(fd, "weights_to_cluster %d\n", k);
				for (l=0; l<sys->net[i]->layer[j]->cluster[k]->neurons; l++) {
					fprintf(fd, "weights_to_neuron %d\n", l);
					for (m=0; m<sys->net[i]->layer[j]->cluster[k]->neuron[l]->fanin; m++) {
						fprintf(fd, "%f\t", sys->net[i]->layer[j]->cluster[k]->neuron[l]->synapse[m]->weight.value.f);
						if ( ! ( (m + 1) % count ) ) fprintf(fd, "\n");
					}
					fprintf(fd, "\n");
				}
			}
		}
	}
	fprintf(fd, "\n");

	if (pattern_list) {
		fprintf(fd, "patterns:\n");
		pat_write (pattern_list);
	}

	fprintf(fd, "%s\n", "_EOF");
	fclose(fd);

	return(OK);
}

/* ----------------------------------------------------------------- */
pat_write ( p )
pat_elem	*p;
{
	pat_elem	*q = p;

	while ( q ) {
		fprintf(fd, "%s", q->input_file);
		if ( q->input_character != '\0')
			fprintf(fd, "\t%c", q->input_character);
		fprintf(fd, "\t%s", q->target_file);
		if ( q->target_character != '\0')
			fprintf(fd, "\t%c", q->target_character);
		fprintf(fd, "\n");
/*		fprintf(fd, "\n%f\n", q->score); */
		q = q->next_ptr;
	}
	fprintf(fd, "\n");
}
/* ------------------------------------------------------------------------ */
