/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 3/3/90
 *
 * pgm 
 *
 * jload.c
 ******************************************************************************/

#include	"pygmalion.h"
#include	"sysdef.h"
#include	"util.h"
#include	"pgmrc.h"

extern		system_type	*sys;
extern		pat_elem	*pattern_list;
extern		int		pattern_count;
extern		connect();
extern		build_rules();
extern		char		*jalloc();
extern		char		*strstr();

extern		char		*rc[];
extern		int		rc_read();

extern		pat_elem	*load_patterns();

int_elem	*net_load();
void		load_data();
void		load_parameters();
void		load_states();
void		load_weights();
char		*index();

int		load_flags;

static		char	buf [ LINESIZE ];
static		char	str [ LINESIZE ];

/* --------------------------------------------------------------- */
int	sys_load(filename)
char	filename[];
{
	FILE		*fd;

	rc_read();

	load_flags = LD_NOTHING;

	if (!(fd = fopen(filename, "r")))
	{
		error("can't open system file - system load failed\n");
		return(FAIL);
	}

	while ( !feof( fd ) ) {

		j_fscanf(fd, "%s", str);

		if (!strcmp(str, "config")) {
			if ( load_config( fd ) != OK ) {
				error("load_config failed\n");
				return( FAIL );
			}
			load_flags |= LD_CONFIG;
		}
		if (!strcmp(str, "parameters:")) {
			load_parameters(fd, sys, str);
			load_flags |= LD_PARAMETERS;
		}
		if (!strcmp(str, "states:")) {
			load_states(fd, sys, str);
			load_flags |= LD_STATES;
		}
		if (!strcmp(str, "weights:")) {
			load_weights(fd, sys, str);
			load_flags |= LD_WEIGHTS;
		}

		if (!strcmp(str, "patterns:")) {
			if (pattern_list = load_patterns(fd, str)) {
				pattern_count = count_patterns ( pattern_list );
				load_flags |= LD_PATTERNS;
			}
		}
		if (strcmp(str, "_EOF")) {
			error("The system file is ill-formatted.\n");
			if ( load_flags & LD_CONFIG )
				fprintf(stderr, "The configuration has been loaded from the system file.\n");
			if ( load_flags & LD_PARAMETERS )
				fprintf(stderr, "The parameters have been loaded from the system file.\n");
			if ( load_flags & LD_STATES )
				fprintf(stderr, "The states have been loaded from the system file.\n");
			if ( load_flags & LD_WEIGHTS )
				fprintf(stderr, "The weights have been loaded from the system file.\n");
			if ( load_flags & LD_PATTERNS )
				fprintf(stderr, "The pattern descriptors have been loaded from the system file.\n");
		}
	}
	fclose(fd);
	return(load_flags);
}

/* --------------------------------------------------------------- */

/*	Read in the configuration of the system and create a config	*/
/*	datastructure to build a new system if it is necessary		*/

int	load_config( fd )
FILE	*fd;
{
	int		size;
	int		*loadconf, *cptr;
	int_elem	*elems, *ptr;

	if (!(elems = net_load(fd))) {
		error("config array ill-formatted\n");
		return(FAIL);
	}
	if (!ok_tree(elems, 4)) {
		error("config tree structure incorrect\n");
		return(FAIL);
  	}

	size = listln(elems);
	cptr = loadconf = (int *) jalloc(sizeof(int), size);
	ptr = elems;

	while(elems) {
		*cptr++ = elems->val;
		elems = elems->next_ptr;
	}

	printf("configuration loaded\n");
	if (connect(loadconf))
		return(FAIL);
	printf("connected\n");
	if (build_rules())
		return(FAIL);
	printf("build_rules completed\n");

	j_fscanf(fd, "%s", str);		/* read next line */

	return ( OK );
}
/* --------------------------------------------------------------- */

int_elem *net_load(fd)
FILE *fd;
{
	int i;
	int_elem *elems, *ptr;

	extern int_elem *lay_load();

	if (j_fscanf(fd, "%d", &i) == EOF)
		 return(NULL);
	ptr = elems = (int_elem*) jalloc(sizeof(int_elem), 1);
	elems->val = i;
	while (i--)
	{
		elems->next_ptr = lay_load(fd);
		elems = last_elem(elems);
	}
	return(ptr);
}

/* --------------------------------------------------------------- */
int_elem *lay_load(fd)
FILE *fd;
{
	int i;
	int_elem *elems, *ptr;

	extern int_elem *clu_load();

	if (j_fscanf(fd, "%d", &i) == EOF)
		 return(NULL);
	ptr = elems = (int_elem*) jalloc(sizeof(int_elem), 1);
	elems->val = i;
	while (i--)
	{
		elems->next_ptr = clu_load(fd);
		elems = last_elem(elems);
	}
	return(ptr);
}

/* --------------------------------------------------------------- */
int_elem *clu_load(fd)
FILE *fd;
{
	int i;
	int_elem *elems, *ptr;

	extern int_elem *neu_load();

	if (j_fscanf(fd, "%d", &i) == EOF)
		 return(NULL);
	ptr = elems = (int_elem*) jalloc(sizeof(int_elem), 1);
	elems->val = i;
	while (i--)
	{
		 elems->next_ptr = neu_load(fd);
		 elems = last_elem(elems);
	}
	return(ptr);
}

/* --------------------------------------------------------------- */
int_elem *neu_load(fd)
FILE *fd;
{
	int i;
	int_elem *elems;

	if (j_fscanf(fd, "%d", &i) == EOF)
		 return(NULL);
	elems = (int_elem *) jalloc(sizeof(int_elem), 1);
	elems->val = i;
	elems->next_ptr = NULL;
	return(elems);
}

/* --------------------------------------------------------------- */
void load_parameters(fd, sys, str)
FILE		*fd;
system_type	*sys;
char		str[];
{
	int	s, n, l, c, i;

	s = n = l = c = 0;
	while(!feof(fd)) {
		j_fscanf(fd, "%s", str);

		if (!strcmp(str, "parameters_in_neuron")) {
			j_fscanf(fd, "%d", &n);
			for (i=0; i<sys->net[n]->layer[l]->cluster[c]->neuron[n]->n_parameters; i++)
				j_fscanf(fd, "%f", &sys->net[n]->layer[l]->cluster[c]->neuron[i]->parameters[i].parameter.value.f);
			continue;
		}

		if (!strcmp(str, "parameters_in_cluster")) {
			j_fscanf(fd, "%d", &c);
			for (i=0; i<sys->net[n]->layer[l]->cluster[c]->n_parameters; i++)
				j_fscanf(fd, "%f", &sys->net[n]->layer[l]->cluster[c]->parameters[i].parameter.value.f);
			continue;
		}

		if (!strcmp(str, "parameters_in_layer")) {
			j_fscanf(fd, "%d", &l);
			for (i=0; i<sys->net[n]->layer[l]->n_parameters; i++)
				j_fscanf(fd, "%f", &sys->net[n]->layer[l]->parameters[i].parameter.value.f);
			continue;
		}

		if (!strcmp(str, "parameters_in_net")) {
			j_fscanf(fd, "%d", &n);
			for (i=0; i<sys->net[n]->n_parameters; i++)
				j_fscanf(fd, "%f", &sys->net[n]->parameters[i].parameter.value.f);
			continue;
		}

		if (!strcmp(str, "parameters_in_sys")) {
			j_fscanf(fd, "%d", &s);
			for (i=0; i<sys->n_parameters; i++)
				j_fscanf(fd, "%f", &sys->parameters[i].parameter.value.f);
			continue;
		}
		return;
	}
}

/* --------------------------------------------------------------- */
void load_states(fd, sys, str)
FILE *fd;
system_type *sys;
char str[];
{
	int	n, l, c, i;

	n = l = c = 0;
	while(!feof(fd)) {
		j_fscanf(fd, "%s", str);

		if (!strcmp(str, "states_in_cluster")) {
			j_fscanf(fd, "%d", &c);
			for (i=0; i<sys->net[n]->layer[l]->cluster[c]->neurons; i++)
				j_fscanf(fd, "%f", &sys->net[n]->layer[l]->cluster[c]->neuron[i]->state[ N_STATE ].value.f);
			continue;
		}

		if (!strcmp(str, "states_in_layer")) {
			j_fscanf(fd, "%d", &l);
			continue;
		}

		if (!strcmp(str, "states_in_net")) {
			j_fscanf(fd, "%d", &n);
			continue;
		}
		return;
	}
}

/* --------------------------------------------------------------- */
void load_weights(fd, sys, str)
FILE		*fd;
system_type	*sys;
char		str[];
{
	int		n, l, c, s, i;
	neuron_type	*neuron;

	n = l = c = s = 0;

	while(!feof(fd)) {

		j_fscanf(fd, "%s", str);
		if (!strcmp(str, "weights_to_neuron")) {
			j_fscanf(fd, "%d", &s);
			neuron = sys->net[n]->layer[l]->cluster[c]->neuron[s];
			for (i=0; i<neuron->fanin; i++)
				j_fscanf(fd, "%f", &neuron->synapse[i]->weight.value.f);
			continue;
		}

		if (!strcmp(str, "weights_to_cluster")) {
			j_fscanf(fd, "%d", &c);
			continue;
		}

		if (!strcmp(str, "weights_to_layer")) {
			j_fscanf(fd, "%d", &l);
			continue;
		}

		if (!strcmp(str, "weights_in_net")) {
			j_fscanf(fd, "%d", &n);
			continue;
		}
		return;
	}
}
/* ------------------------------------------------------------------------ */
int	j_fscanf ( fd, format, p )	/* fscanf - skipping  comments		*/
					/* formats must be "%f", "%s" or "%d"	*/
FILE	*fd;
char	*format;
caddr_t	p;
{
	char	s[ LINESIZE], c;
	int	i, found = FALSE;

	do {
		while ( TRUE ) {
			while ( index( " \t\n", ( c = fgetc( fd ) ) ) ) {
			}
			if ( c == '#' ) {
				while ( ( c = fgetc( fd ) ) != '\n' ) {
				}
			}
			else {
				ungetc ( c, fd );
				break;
			}
		}

		switch ( format[1] ) {

		case 'f':
			if ( (i = fscanf ( fd, "%f", (float *) p ) ) == 1 )
				found = TRUE;
			break;

		case 'd':
			if ( (i = fscanf ( fd, "%d", (int *) p ) ) == 1 )
				found = TRUE;
			break;

		case 's':
			if ( (i = fscanf ( fd, "%s", (char *) p ) ) == 1 )
				found = TRUE;
			break;

		default:
			printf ( "j_fscanf - unsupported format type\n" );
			break;
		}
	} while ( !found && !feof( fd ) );

	return ( found );
}

/* ------------------------------------------------------------------------ */
