/* ------------------------------------------------------------------------ *\

	sysdef.h

	21st March 1990
	15:00

\* ------------------------------------------------------------------------ */

#include <stdio.h>
#include <sys/types.h>

/* Control key definition */

#define		PAR
#define		SEQ

/* Constant definitions */

#define		NO_STATES 	4	/* determines size of state[] array in neuron_type structure */
#define		CLEAR		12
#define		EOP		NULL
#define		CHILD		0
#define		NULLCP		(char *) NULL

#define		CONFIRM_OK	0
#define		SYNT_ERR	1
#define		QUERY		2
#define		SYSEMPTY	3
#define		EXIT		60
#define		FAIL		-1

/* Exit control for rules */
#define	TERM			-1

/* neuron.state indices */

#define		N_STATE		0
#define		N_ERR		1
#define		N_TARGET	2
#define		N_ACC		3
#define		N_WEIGHT	4
#define		N_RULE		5
#define		N_PARA		6
#define		N_NONE		7

/* control values for network tolerance test */

#define		MERR		0
#define		HAM		1
#define		EUCL		2
#define		ANGL		3

/* control values for neighbourhood calculation */

#define		EUCLIDEAN	0
#define		CARTESIAN	1
#define		CITY_BLOCK	2

/* Pattern value to clamp to input, target vectors */

#define		BINARY		0
#define		PLUSMINUS	1
#define		REAL		2
#define		SCALED_SIGMOID	3
#define		NORMALISE	4

/* activation function switch */

#define		STEP		0
#define		SIGMOID		1

/* ------------------------------------------------------------------------ */
/* Rule structures */

typedef	struct	{
		int		(*fn)();	/* pointer to function returning an integer */
		char		*fn_name;	/* the name of the function in the code - future use */
		int		n_generic_parameters;
		int		n_extend_parameters;
	       } class_type;

#define null_class_type	(class_type *) 0

/* ------------------------------------------------------------------------ */

struct	RULE	{
		char		*tag;	/* code_gen() - future use */
		char		*name;	/* for display purposes */
		class_type	*class;
		caddr_t		*para_list;
		};

typedef struct	RULE	rule_type;

/* ------------------------------------------------------------------------ */

typedef	struct	{	/* to hold size counter AND a rule pointer */
		int		size;
		rule_type	*rule;
		} exec_type;

/* ------------------------------------------------------------------------ */

typedef	union	{	/* general purpose storage - always signed */
		float		f;
		short		s;
		int		i;
		long		l;
		char		c;
		char		*cp;
	/*	double		d; too big */
	} UNVAL;

/* ------------------------------------------------------------------------ */

typedef struct	{
		char		*tag;	/* code_gen() - future use */
		char		type;
		UNVAL		value;
	       } TAGVAL;

/* ------------------------------------------------------------------------ */

typedef struct	{
		char		*name;
		TAGVAL		parameter;
	       } para_type;

#define null_para_type	(para_type *) 0

/* ------------------------------------------------------------------------ */

/* Data types for network structure */

typedef struct	{	
		int		n_rules;
		rule_type	*rules;
		int		n_parameters;
		para_type	*parameters;

		TAGVAL		weight;
		} synapse_type;

#define null_synapse_type	(synapse_type *) 0

/* ------------------------------------------------------------------------ */
struct NEURON	{
		int		n_rules;
		rule_type	*rules;
		int		n_parameters;
		para_type	*parameters;

		TAGVAL		state[ NO_STATES ]; /* state[0]=neuron's state */
		int		route[ 4 ];
		int		fanin;
		int		fanout;
		struct NEURON	**input_neuron;
		struct NEURON	**output_neuron;

		int		synapses;
		synapse_type	**synapse;
	       };

typedef struct	NEURON	neuron_type;
#define null_neuron_type	(neuron_type *) 0

/* ------------------------------------------------------------------------ */
typedef struct	{
		int		n_rules;
		rule_type	*rules;
		int		n_parameters;
		para_type	*parameters;

		int		neurons;
		int		synapses;
		neuron_type	**neuron;
		synapse_type	**synapse;
	       } cluster_type;

#define null_cluster_type	(cluster_type *) 0

/* ------------------------------------------------------------------------ */
typedef struct	{
		int		n_rules;
		rule_type	*rules;
		int		n_parameters;
		para_type	*parameters;

		int		clusters;
		cluster_type	**cluster;
	       } layer_type;

#define null_layer_type	(layer_type *) 0

/* ------------------------------------------------------------------------ */
typedef struct	{
		int		n_rules;
		rule_type	*rules;
		int		n_parameters;
		para_type	*parameters;

		int		fanin;
		int		fanout;
		caddr_t		*input_port;
		caddr_t		*output_port;
		caddr_t		*target;

		int		layers;
		layer_type 	**layer;
	       } net_type;

#define null_net_type	(net_type *) 0

/* ------------------------------------------------------------------------ */
typedef struct 	{
		int		n_rules;
		rule_type	*rules;
		int		n_parameters;
		para_type	*parameters;

		int		nets;
		net_type	**net;
	       } system_type;

#define null_system_type	(system_type *) 0

/* ------------------------------------------------------------------------ */

#define		SYS	0
#define		NET	1
#define		LAY	2
#define		CLU	3
#define		NEU	4
#define		SYN	5

/* ------------------------------------------------------------------------ */

/*		various structures for patterns etc.		*/

struct elem_header{
		    struct elem_header* next_ptr;
		  };

typedef struct elem_header any_elem;

struct pat_chain {
		struct	pat_chain *next_ptr;
		int	input_pattern_type;
		char	*input_file;
		char	input_character;
		int	input_width;
		int	input_height;
		int	target_pattern_type;
		char	*target_file;
		char	target_character;
		int	target_width;
		int	target_height;
		float	score;
		};

#define		PATTERN_TYPE_FONT	0
#define		PATTERN_TYPE_X		1
#define		PATTERN_TYPE_FLOAT	2
#define		PATTERN_TYPE_INT	3

typedef struct pat_chain pat_elem;

struct int_chain {
		struct	int_chain *next_ptr;
		int	val;
		};

typedef struct int_chain int_elem;

#include "supdef.h"	/* supplementary definitions for config spec. */

/* ------------------------------------------------------------------------ */

/* system load return flags */

#define		LD_NOTHING	0
#define		LD_CONFIG	1<<0
#define		LD_PARAMETERS	1<<1
#define		LD_STATES	1<<2
#define		LD_WEIGHTS	1<<3
#define		LD_PATTERNS	1<<4

/* Macro function definitions */

#define NO() !YES()

#define clearscreen() putchar(CLEAR)

/* ------------------------------------------------------------------------ */
