/* ------------------------------------------------------------------------ *\
	soconfig.h		Defaults for Kohonen SO Map

	ugur, jtaylor

	6th March 1990
	12:45
\* ------------------------------------------------------------------------ */

/* parameter values */

#define X_DIMENSION		16
#define Y_DIMENSION		16

#define WINNER			-1		/* initial value forces neighbourhood calculation */
#define DISTANCE_START		0.00		/* not used yet */
#define DISTANCE_STEP		1.00
#define DISTANCE_FINISH		0.00		/* not used yet */
#define DISTANCE_CONTROL	EUCLIDEAN	/* Options : EUCLIDEAN, CARTESIAN, CITY_BLOCK */
#define INPUT_PATTERN_CONTROL	NORMALISE	/* Options : NORMALISE, BINARY, PLUSMINUS, REAL */
#define TARGET_PATTERN_CONTROL	REAL		/* not used yet */
#define GAIN_START		0.99
#define GAIN_STEP		0.05
#define GAIN_FINISH		0.11

/* ------------------------------------------------------------------------ */

/* topology */

#define NETS			1
#define LAYERS			2
#define CLUSTERS		1

struct	config_tag {
		int	nets;
		struct {
		        int	layers;
		        struct {
				int	clusters;
				struct {
					int	neurons;
					} cluster [CLUSTERS];
				} layer [LAYERS];
			} net [NETS];
		} config = 
			{ 1,
				{ 2,
					{
					{ 1,
						{ 96 }
					},
					{ 1,
						{ X_DIMENSION * Y_DIMENSION }
					}
					}
				}
			};
/* ------------------------------------------------------------------------ */
