/* -------------------------------------------------------------- *\
	pgmrc.h		#defines for .pgmrc routines

	jtaylor

	27/02/90
	11:00

\* -------------------------------------------------------------- */

#ifndef		_H_PGMRC
#define		_H_PGMRC

#define		EQUCHAR				'='
#define		PGMRC_ENV			"PGMRC"

/* -------------------------------------------------------------- *\
	command indices
\* -------------------------------------------------------------- */

#define		RC_local_user			1
#define		RC_local_host			2
#define		RC_remote_user			3
#define		RC_remote_host			4
#define		RC_display			5

#define		RC_working_directory		6
#define		RC_home_directory		7

#define		RC_algorithm_directory		8
#define		RC_application_directory	9
#define		RC_configuration_directory	10
#define		RC_error_message_directory	11
#define		RC_font_directory		12
#define		RC_nc_code_directory		13
#define		RC_nn_save_directory		14
#define		RC_pattern_directory		15
#define		RC_pygmalion_directory		16
#define		RC_rpc_server_directory		17

#define		RC_algorithm_file		18
#define		RC_application_file		19
#define		RC_configuration_file		20
#define		RC_nc_code_file			21
#define		RC_nn_save_file			22
#define		RC_pattern_descriptor_file	23

#define		RC_connectivity_display		24
#define		RC_matrix_display		25
#define		RC_inverse_display		26

#define		RC_fixed_font			27
#define		RC_small_font			28
#define		RC_large_font			29

#define		RC_main_foreground_red		30
#define		RC_main_foreground_green	31
#define		RC_main_foreground_blue		32

#define		RC_main_background_red		33
#define		RC_main_background_green	34
#define		RC_main_background_blue		35

#define		RC_button_foreground_red	36
#define		RC_button_foreground_green	37
#define		RC_button_foreground_blue	38

#define		RC_button_background_red	39
#define		RC_button_background_green	40
#define		RC_button_background_blue	41

#define		RC_menu_foreground_red		42
#define		RC_menu_foreground_green	43
#define		RC_menu_foreground_blue		44

#define		RC_menu_background_red		45
#define		RC_menu_background_green	46
#define		RC_menu_background_blue		47
/* Add more here - then increment RC_MAX */
#define		RC_MAX				48

/* -------------------------------------------------------------- *\
	validation types
\* -------------------------------------------------------------- */

#define	VAL_ignore				0
#define	VAL_string				1
#define	VAL_on_off				2
#define	VAL_0_65535				3
#define	VAL_filename				4
#define	VAL_directory				5

/* -------------------------------------------------------------- *\
	command table structure
\* -------------------------------------------------------------- */

typedef struct  cmd_table {	/* derived from ISODE mechanism */
	char    *cmd_key;
	int     cmd_value;
	int     cmd_valid;
	} CMD_TABLE;

/* -------------------------------------------------------------- *\
	routines defined in pgmrc.c used externally
\* -------------------------------------------------------------- */

int	rc_read ();		/* read file    ( used externally ) */
int	rc_write ();		/* write file   ( used externally ) */
void	rc_update ();		/* modify field ( used externally ) */

#endif
