/* ------------------------------------------------------------------------ *\
	magboconfig.h		Defaults for boltzmann algorithm
\* ------------------------------------------------------------------------ */

/* parameters values */

#define LEARN_RATE		2.00
#define TEMP_START		10.0
#define TEMP_EQUI 		1.0
#define TEMP_STEP 		1.0
#define ITER_EQUI		2.0
#define ITERATION		0.0

#define INPUT_PATTERN_CONTROL	PLUSMINUS /* Options : BINARY, REAL */
#define TARGET_PATTERN_CONTROL	PLUSMINUS /* Options : BINARY, REAL, SCALED_SIGMOID */

/* ------------------------------------------------------------------------ */

/* default configuration */
#define NETS			1
#define LAYERS			3
#define CLUSTERS		1

struct	config_tag {
		int	nets;
		struct {
		        int	layers;
		        struct {
				int	clusters;
				struct {
					int	neurons;
					} cluster [CLUSTERS];
				} layer [LAYERS];
			} net [NETS];
		} config = 
			{ 1,
				{ 3,
					{
					{ 1,
						{ 4 }
					},
					{ 1,
						{ 2 }
					},
					{ 1,
						{ 4 }
					}
					}
				}
			};
/* ------------------------------------------------------------------------ */
