/*	fontdefs.h	for readfont */

#define min(x,y)        (x<y ? x : y)
#define max(x,y)        (x>y ? x : y)
#define hex(n)          ((n>9 ? n+'a'-10 : n+'0'))
#define dec(c)          ((c>'9' ? 10+(c | 32)-'a' : c-'0'))

#define ReadBit         0
#define SetBit          1
#define ComBit          2
#define ClearBit        3

extern int errno;
char *malloc();

struct box {
	int w, h;
	int x, y;
};

struct character {
	char    *charId;
	int     encoding;
	int     swidth[2];
	int     dwidth[2];
	struct  box bbx;
	int     nrows;
	char    **rows;
};

struct font {
	int     rev, subrev;
	char    *comment;
	char    *fontname;
	int     sizes[3];
	struct box     boundingbox;
	int     nprop;
	int     descentValid, descent;
	int     ascentValid, ascent;
	int     copyrightValid;
	char    *copyright;
	int     nchars;
	struct box maxbbx;
	struct  character *characters;
	int	defaultCharValid, defaultChar;
};

struct font font;
