/* ------------------------------------------------------------------------ *\
	bpconfig.h		Defaults for back propagation algorithm

	jtaylor

	1st March 1990
	12:45
\* ------------------------------------------------------------------------ */

/* parameter values */

#define TOLERANCE		0.25
#define LEARN_RATE		0.70
#define MEASURE			MERR	/* Options : MERR, HAM, EUCL, ANGL */
#define INPUT_PATTERN_CONTROL	BINARY	/* Options : BINARY, REAL */
#define TARGET_PATTERN_CONTROL	BINARY	/* Options : BINARY, REAL, SCALED_SIGMOID */

/* ------------------------------------------------------------------------ */

/* topology */

#define NETS			1
#define LAYERS			3
#define CLUSTERS		1

struct	config_tag {
		int	nets;
		struct {
		        int	layers;
		        struct {
				int	clusters;
				struct {
					int	neurons;
					} cluster [CLUSTERS];
				} layer [LAYERS];
			} net [NETS];
		} config = 
			{ 1,
				{ 3,
					{
					{ 1,
						{ 8*12 }
					},
					{ 1,
						{ 24 }
					},
					{ 1,
						{ 8*12 }
					}
					}
				}
			};
/* ------------------------------------------------------------------------ */
