.TH nC_code_chk 1 "March 1990" "Beta Test 1.02"
.SH NAME
nC_code_chk \- Pygmalion nC_code language syntax checker

.SH SYNOPSIS
.B nC_code_chk
\fIfilename\fP

.SH DESCRIPTION
\fInC_code_chk\fP
is a syntax checker for the Pygmalion \fInC_code\fP language.
The \fInC_code\fR program \fIfilename\fP is read by the
\fInC_code_chk\fP and analysed to find out whether its contents
conforms the \fInC_code\fP language specification (see the
\fInC_code\fP Manual). If there is any syntax error,
\fInC_code_chk\fP will print the following line:

.ce
syntax error: \fIstring\fP not expected in line xxx

.LP
\fInC_code_chk\fP MUST be run before \fIfilename\fP is compiled by
the C compiler. If the checking of the syntax succeeds, it
means that the \fInC_code\fP program conforms the
Pygmalion Programming Environment, and therefore there is a
great probability that it will be
compiled by the C compiler with no errors and will run under the Pygmalion
Graphic Monitor correctly.

.SH SEE ALSO
nC_code Language Manual, nC Programming Language Manual,
Gen_nC_code Manual (being developed).

.SH WHAT \fInC_code_chk\P DOES NOT CHECK
\fInC_code_chk\fP does not check whether the symbolic tag names
respect the scheme adopted to unambiguously identify each
element in the \fIsystem\fP data structure, since this is not
characterised as a syntax error. It is the
\fIGen_nC_code\fP tool's responsibility to provide the correct naming
scheme. Also, in the initialisation part, nC_code_chk only analyses
whether an address is provided, without checking
which address it is supposed to be. As an example, to
initialise a list of neurons in the cluster data structure, the
\fInC_code_chk\fP does not check whether the address belongs to
a neuron data structure. It is also the \fIGen_nC_code\fP
tool's responsibility to provide the correct address.

.SH BUGS
If you find any bugs, please let me know immediately !

.SH COPYRIGHT
Copyright 1990 Department of Computer Science, University College London.

.SH AUTHOR
M. E. Nigri
