/******************************************************************************
**  The Rochester Connectionist Simulator - a neural network simulator.      **
**  COPYRIGHT (C) 1989  UNIVERSITY OF ROCHESTER.                             **
**                                                                           **
**  This program is free software; you can redistribute it and/or modify it  **
**  under the terms of the GNU General Public License as published by the    **
**  Free Software Foundation; either version 1, or (at your option) any      **
**  later version.                                                           ** 
**                                                                           **
**  This program is distributed in the hope that it will be useful, but      **
**  WITHOUT ANY WARRANTY; without even the implied warranty of               **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     **
**  See the GNU General Public License for more details.                     **
*******************************************************************************/

/*********************************************************************
 * Graphics Interface
 * ------------------
 * This is the main entry point to the Graphics Interface package
 * for the Rochester Connectionist Simulator.  
 * It is called automatically by the simulator if the 
 * gistart.o has been linked into the object code.
 * The routines here set up the GI tool and do all beginning
 * initialization of global variables.
 *
 * Kenton Lynne
 ********************************************************************/

#include "macros.h"
#include "externs.h"
#include "panel.h"
#include "control_panel.h"
#include "info_panel.h"
#include <X11/Box.h>
#include <X11/VPaned.h>
#include <X11/Xlib.h>

#undef DEBUG

/* default tool window dimensions -- may be changed by -W flags */
#define SCREEN_TOP    100
#define SCREEN_LEFT   560
#define SCREEN_WIDTH  585
#define SCREEN_HEIGHT 725

/****************************************/
/* define the image for the MARKER icon */
/****************************************/
#include "icon/marker"
XImage *marker_image;
struct gricons marker_icon = {NULL, NULL, 1, UNITSIZE, UNITSIZE, NULL};

extern info_panel_t gi_info_panel_list;

int gi_in_control;
static int temp_in_control;

/*************************************************************************/
static pre_init()
{
/* takes care of initialization of globals variables
 * needed before the tool is installed 
 */
  int i;

  /* set up the text object headers */
  gi_text_head.next = gi_text_head.prev = &gi_text_head;
  gi_text_head.flag = 0;

  /* set up the vertex object headers */
  gi_draw_head.next = gi_draw_head.prev = &gi_draw_head;
  gi_draw_head.flag = 0;

  /* initialize the off_display header */
  gi_off_display.next = gi_off_display.prev = &gi_off_display;
  gi_off_display.flag = 0;

  gi_info_panel_list = NULL;
  /* initialize the marker (ie. display header) for graphics panel */
  marker_image = MakeImage(gi_tool,marker_bits,marker_width,marker_height);
  marker_icon.pix_ptr = &(marker_image);
  gi_marker.next = gi_marker.prev = &gi_marker;
  gi_marker.x_pos = 5;
  gi_marker.y_pos = 5;
  gi_marker.u_index = MARKER;
  gi_marker.gptr = &marker_icon;
  gi_marker.val = 0;
  gi_marker.flag = VALUE_OK + NOSHOW;
  gi_marker.icon_index = 0;
  gi_echo_on = True;
}

/*************************************************************************/
static post_init()
{
/* initializes global variables and structures that are best
 * done after the tool is installed
 */

    /* turn off target item, for now */
    XtUnmanageChild(gi_mitem[TARGET_ITEM]);

    /* custom mode: button events + negative move and window exit events */
    gi_event_mask = ExposureMask | LeaveWindowMask | ButtonPressMask | ButtonReleaseMask | ButtonMotionMask;
    /* main mode: same as for custom mode */
    /* link mode: same as for main mode */
    /* text mode: same as main + ascii events */
    /* draw mode: same as main + positive move events */

    /* initialize all the cursors */
    gi_graball_cursor = XCreateFontCursor(XtDisplay(gi_tool), XC_fleur);
    gi_grab_cursor = XCreateFontCursor(XtDisplay(gi_tool), XC_hand2);
    gi_main_cursor = XCreateFontCursor(XtDisplay(gi_tool), XC_diamond_cross);
    gi_draw_cursor = XCreateFontCursor(XtDisplay(gi_tool), XC_pencil);
    gi_text_cursor = XCreateFontCursor(XtDisplay(gi_tool), XC_xterm);
    gi_delete_cursor = XCreateFontCursor(XtDisplay(gi_tool), XC_pirate);
    gi_custom_cursor = XCreateFontCursor(XtDisplay(gi_tool), XC_mouse);
    gi_left_cursor = XCreateFontCursor(XtDisplay(gi_tool), XC_leftbutton);
    gi_middle_cursor = XCreateFontCursor(XtDisplay(gi_tool), XC_middlebutton);
    gi_right_cursor = XCreateFontCursor(XtDisplay(gi_tool), XC_rightbutton);

    /* change the cursor on the graphics panel to a crosshair */
/*    gi_last_cursor = gi_main_cursor;*/
/*    XDefineCursor(XtDisplay(gi_tool), gi_gfx, gi_main_cursor);*/
 
}


/*************************************************************************/
gi_main(argc,argv)
     int argc;
     char *argv[];
{
/* called by the simulator in order to bring up the
 * GI interface tool.
 * It is passed the original command line arguments
 * in order to pull out the -W flags for explicit tool window
 * positioning, size, label and whatever else Sun comes up with
 * for these tool flags
 */
  Widget shell;
  int i;
  char *fontname;

  /* print out banner on simulator panel */
  printf("\n... building Graphic Interface widget -- please wait ...\n");

  /* get the command line arguments */
  /* parse command line args for flags */

  shell = XtInitialize("main","XGI", NULL, NULL, &argc, argv);
  if (argc != 1)
  {
    fputs("Can't parse args\n", stderr);
    exit(1);
  }

  /* did we get shell widget? */
  if (shell == NULL)
  {      
    fputs("Can't make top level shell widget\n", stderr);
    exit(1);
  }

  gi_tool = XtCreateManagedWidget("GI_TOOL", vPanedWidgetClass, shell, NULL, 0);

   /* get default font resource */
  if ((fontname = XGetDefault(XtDisplay(gi_tool), argv[0], "font")) == NULL)
	fontname = "fixed";
  if ((gi_cur_font = (XFontStruct *) gi_get_font(fontname)) == NULL)
    {
      fprintf(stderr, "Font %s not available, trying \"fixed\"\n", fontname);
      if ((gi_cur_font = (XFontStruct *) gi_get_font("fixed")) == NULL)
	{
	  fprintf(stderr, "Can't load \"fixed\" font, bye bye....\n");
	  exit(1);
	}
    }

  gi_default_font = * gi_cur_font; /* complete copy */

  gi_font_width = (XTextWidth(&gi_default_font,
	     "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890", 62))/62.0;

  /* set up the tool panels */
  /* NOTE: panels MUST be built in this order */

  gi_make_mode_panel(); 
  gi_make_control_panel();
  gi_make_msg_panel(); 
  gi_make_cmd_panel(gi_tool);

  /* initialize needed vars before tool is installed */
  pre_init();

  /* display the tool */
  XtRealizeWidget(shell);

  /* initialize needed vars after tool is installed */
  post_init();

  /* now make the first display window and layout */
  gi_popup_first_display();
}

/*************************************************************************/
gi_end_session()

{
  gi_popdown_popups();
  gi_raise_control_panel();
  unlink(gi_prev_fname);
  if (gi_log_on && gi_log_fp)
    {
      fflush(gi_log_fp);
      fclose(gi_log_fp);
    }
  exit(0);
}

/*************************************************************************/
gi_get_control()

{
  /* This is the main event loop. */
  XEvent e;

  gi_in_control = TRUE;		/* set to false in gi_back_to_caller */

  while (gi_in_control)
    {
      XtNextEvent(&e);
      XtDispatchEvent(&e);
    }
  gi_raise_control_panel();
				/* and so return to caller */
}

/*************************************************************************/
/* function to process mouse events                           */
/* returns FALSE if quit button was clicked                   */
/* otherwise returns TRUE when all events done                */

int gi_process_events()

{
  XEvent e;
  int saveg;
  int ret;

  saveg = gi_in_control;
  temp_in_control = gi_in_control = TRUE;
  while (temp_in_control && XtPending())
    {
      XtNextEvent(&e);
      XtDispatchEvent(&e);
    }
  if (temp_in_control)
    ret = TRUE;
  else
    ret = FALSE;
  temp_in_control = FALSE;
  gi_in_control = saveg;
}

/*************************************************************************/
gi_back_to_caller()

{
  gi_in_control = FALSE;
  temp_in_control = FALSE;
}
