/******************************************************************************
**  The Rochester Connectionist Simulator - a neural network simulator.      **
**  COPYRIGHT (C) 1989  UNIVERSITY OF ROCHESTER.                             **
**                                                                           **
**  This program is free software; you can redistribute it and/or modify it  **
**  under the terms of the GNU General Public License as published by the    **
**  Free Software Foundation; either version 1, or (at your option) any      **
**  later version.                                                           ** 
**                                                                           **
**  This program is distributed in the hope that it will be useful, but      **
**  WITHOUT ANY WARRANTY; without even the implied warranty of               **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     **
**  See the GNU General Public License for more details.                     **
*******************************************************************************/

/********************************************************************
 * Graphics Interface
 * ------------------
 * This file contains most of the routines related to processing
 * done on or with the info panel.
 *
 * Kenton Lynne
 *******************************************************************/

#include <X11/Shell.h>

typedef struct _info_panel {
  struct info_unit iu; /* unit information */
  Widget popup; /* popup widget */
  Widget text; /* info text widget */
  char * display;		/* really a pointer to the display_panel */
  char buf[150]; /* info text buf */
  Boolean free; /* if free, then popped down, and available for "next" */
  Boolean frozen;		/* if frozen then no updates are made until unfrozen */
  struct _info_panel *next; /* pointer to next in line */
} *info_panel_t;

extern info_panel_t gi_info_panel_head;
