/******************************************************************************
**  The Rochester Connectionist Simulator - a neural network simulator.      **
**  COPYRIGHT (C) 1989  UNIVERSITY OF ROCHESTER.                             **
**                                                                           **
**  This program is free software; you can redistribute it and/or modify it  **
**  under the terms of the GNU General Public License as published by the    **
**  Free Software Foundation; either version 1, or (at your option) any      **
**  later version.                                                           ** 
**                                                                           **
**  This program is distributed in the hope that it will be useful, but      **
**  WITHOUT ANY WARRANTY; without even the implied warranty of               **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     **
**  See the GNU General Public License for more details.                     **
*******************************************************************************/

/* Xsupport.c */
#include "Xsupport.h"
#include <X11/Box.h>
#include <X11/Command.h>
#include <X11/VPaned.h>
#include <X11/AsciiText.h>
#include <X11/Xlib.h>

extern XFontStruct gi_default_font;

void gi_radio_button_callback(w, client_data, call_data)
     Widget w;
     caddr_t client_data, call_data;

/*  w is the widget
    client_data is the button_list structure for the radio box
*/

{
  String buf;
  Widget * Wptr;
  Arg arglist[1];
  int i, count;
  button_list * buttons;
  
  buttons = (button_list * ) client_data;
  count = buttons->count;
  Wptr = buttons->toggle_list;
  for (i = 0; i < count; i++)
    if (*(Wptr+i) == w)
      {
	XtSetSensitive(w, FALSE); /* stipple this button */
	if (buttons->func != NULL)
	  buttons->func(w,i,NULL);	/* call button function */
      }
    else
      XtSetSensitive(*(Wptr+i), TRUE); /* unstipple other buttons */
}

Widget AddRadio(w,s,f,b,cols,on,butts)
/* w is parent widget,
   s is the name of the radio box,
   f is the function to call when a button is pushed,
   and b is a (null-terminated) array of button labels.
   and cols is the number of columns.
   and on is the index of the button that is selected (-1 implies none).
   and butts is the address of a pointer to return the button list in.
   When the button is pushed, the f is called with integer argument set to
   the index in the array of button labels.
*/
	Widget w;
	char *s;
	XtCallbackProc f;
	char **b;
        int cols, on;
        button_list ** butts;
{
  Widget radio_box, toggle, * toggle_list;
  button_list * buttons;
  int c,i;
  static Arg a[] =
    {
      { XtNfromHoriz, (XtArgVal) NULL },
      { XtNfromVert, (XtArgVal) NULL },
      { XtNvertDistance, (XtArgVal) 10 },
      { XtNhorizDistance, (XtArgVal) 10 },
      { XtNfont, (XtArgVal) &gi_default_font },
    };
  static Arg no_bdr[] =
    {
      { XtNborderWidth, (XtArgVal) 0 },
    };

#ifdef DEBUG
  printf("Xsupport: creating widget named %s.\n",s);
#endif
  /* count the number of buttons */
  for(c=0; b[c]!=NULL; c++);
  
  radio_box=XtCreateManagedWidget(s, formWidgetClass, w, no_bdr, 1);
  buttons = (button_list *) malloc (sizeof(button_list));
  buttons->toggle_list = toggle_list = (Widget *) malloc (c * sizeof (Widget));
  buttons->count = c;
  buttons->func = f;
  for(i=0; i<c; i++)
    {
      if (i % cols == 0)	/* new row */
	{
	  a[0].value = (XtArgVal) NULL;	/* tie to left */
	  if (i != 0)
	    a[1].value = (XtArgVal) toggle_list[i-cols]; /* one above */
	  else
	    a[1].value = (XtArgVal) NULL; /* none above */
	}
      else			/* middle of row */
	{
	  if (i > cols)		/* not first row */
	    a[1].value = (XtArgVal) toggle_list[i-cols]; /* one above */
	  else
	    a[1].value = (XtArgVal) NULL; /* none above */
	  a[0].value = (XtArgVal) toggle_list[i-1]; /* one to left */
	}
      toggle_list[i] = XtCreateManagedWidget(b[i], commandWidgetClass,
					     radio_box, a, XtNumber(a));
      XtAddCallback(toggle_list[i], XtNcallback, gi_radio_button_callback, buttons);
    }
				/* select on button */
  if (on >= 0)
    XtSetSensitive(toggle_list[on], FALSE); /* stipple this button */
  if (butts != NULL)
    *butts = buttons;
  return radio_box;
}	  

Widget AddButton(w,s,f,d,p)
/* w is the parent,
   s is the name of the button,
   f is the function to call,
   and d is the data passed to the function.
   and p is the neighbour to the left */
     Widget w;
     char *s;
     XtCallbackProc f;
     caddr_t d;
{
  Widget temp;
  static Arg a[] = {
    { XtNfromHoriz, (XtArgVal) NULL },
    { XtNhorizDistance, (XtArgVal) 10 },
    { XtNfont, (XtArgVal) &gi_default_font },
  };

#ifdef DEBUG
	printf("Xsupport: creating widget named %s.\n",s);
#endif
  a[0].value = (XtArgVal) p;
  temp = XtCreateWidget(s, commandWidgetClass, w, a, XtNumber(a));
  XtAddCallback(temp,XtNcallback,f,d);

  XtManageChild(temp);
  return(temp);
}

Widget AddBox(w,s)
/* w is the parent,
   and s is the name of the box. */
     Widget w;
     char *s;
{
	static Arg a[] = {
		{XtNborderWidth, (XtArgVal)0},
	};
#ifdef DEBUG
	printf("Xsupport: creating widget named %s.\n",s);
#endif
	return(XtCreateManagedWidget(s, boxWidgetClass, w, a, XtNumber(a)));
}

Widget AddForm(w,s)
/* w is the parent,
   and s is the name of the form. */
     Widget w;
     char *s;
{
	Widget t;
	static Arg a[] = {
		{XtNborderWidth, (XtArgVal)0},
	};


#ifdef DEBUG
	printf("Xsupport: creating widget named %s.\n",s);
#endif

	t = XtCreateWidget(s, formWidgetClass, w, a, XtNumber(a)); /* was Xwform... */
	XtManageChild(t);
	return(t);
}

Widget AddText(w,s,f, p)
/* w is parent widget,
   s is the text to add,
   and f is the alignment (format). 
   and p is the neighbour to the left */
     Widget w;
     char *s;
     XtJustify f;
     Widget p;

{
  Arg *a;


#ifdef DEBUG
	printf("Xsupport: creating widget named %s.\n",s);
#endif

  a = (Arg *)malloc(6*sizeof(Arg)); 
  if (a == NULL) {
	error2("!AddText(%s):  couldn't allocate space for args!\n.",s);
	exit(1);
  }

  XtSetArg(*a, XtNjustify, f);
  XtSetArg(*(a+1), XtNlabel, s);
  XtSetArg(*(a+2), XtNborderWidth, (XtArgVal)0);
  XtSetArg(*(a+3), XtNhorizDistance, (XtArgVal)10);
  XtSetArg(*(a+4), XtNfromHoriz, (XtArgVal) p);
  XtSetArg(*(a+5), XtNfont, (XtArgVal) &gi_default_font);
  return(XtCreateManagedWidget(s, labelWidgetClass, w, a, 6));
}

Widget AddTextEdit(w,n,s,p,l,v)
/* w is the parent widget,
   n is the name of the TextEdit widget,
   and s is the initial text.
   and p is the neighbouring widget to the left
   and l is the length of the editable string buffer in characters
   and v is the length of the visible string in characters
   If l is greater then v, the string is scrolled horizontally */
	Widget w;
	char *n;
	char *s;
        Widget p;
        int l, v;
{
	Arg *a;
	Widget ret;

#ifdef DEBUG
	printf("Xsupport: creating widget named %s.\n",n);
#endif
  a = (Arg *)malloc(10*sizeof(Arg));
  if (a == NULL)
    {
      error2("!AddTextEdit(%s): couldn't allocate space for args!\n.",s);
      exit(1);
    }

  XtSetArg(*a, XtNstring, (XtArgVal)s);
  XtSetArg(*(a+1), XtNeditType, (XtArgVal)XttextEdit);
  XtSetArg(*(a+2), XtNwidth, (XtArgVal) (v*6)); /* assume char = 6 pix */
  XtSetArg(*(a+3), XtNheight, (XtArgVal)20);
  XtSetArg(*(a+4), XtNlength, (XtArgVal) l);
  XtSetArg(*(a+5), XtNhorizDistance, (XtArgVal)20);
  XtSetArg(*(a+6), XtNfromHoriz, (XtArgVal) p);
  if (l > v)
    XtSetArg(*(a+7), XtNtextOptions, (XtArgVal)(editable|scrollHorizontal));
  else
    XtSetArg(*(a+7), XtNtextOptions, (XtArgVal)(editable|scrollOnOverflow));
  XtSetArg(*(a+8), XtNborderWidth, (XtArgVal) 0);
  XtSetArg(*(a+9), XtNfont, (XtArgVal) &gi_default_font);

  ret =  XtCreateManagedWidget(n, asciiStringWidgetClass, w, a, 10);
  XtTextSetInsertionPoint(ret, strlen(XtNstring));
  free(a);
  return (ret);
}

XImage *MakeImage(w, bits, width, height)
	Widget w;
	char *bits;
	int width, height;
{
	XImage *new_image;

	new_image = XCreateImage(XtDisplay(w),
				DefaultVisualOfScreen(XtScreen(w)),
				1, XYBitmap, 0, bits,
				width, height, 8, 0);
        new_image->byte_order = LSBFirst;
        new_image->bitmap_unit = 8;
        new_image->bitmap_bit_order = LSBFirst;

	return(new_image);
}

void SetValue(w,name,value)
/* Easy interface to XtSetValues */
        Widget w;
        String name;
        XtArgVal value;
{
        Arg *NewArg;

	NewArg=(Arg *)malloc(sizeof(Arg));
	if (NewArg==NULL) {
		error1("!SetValue(%s):  couldn't allocate space for arg!\n");
		exit(1);
	}

        XtSetArg(*NewArg,name,value);
        XtSetValues(w,NewArg,1);
}

/* Suntool-like functions for ease in porting */

Widget panel_create(parent, name)
     Widget parent;
     char *name;
{
#ifdef DEBUG
	printf("Xsupport: creating widget named %s.\n",name);
#endif

  return(XtCreateManagedWidget(name, vPanedWidgetClass, parent, NULL, 0));
}


