/******************************************************************************
**  The Rochester Connectionist Simulator - a neural network simulator.      **
**  COPYRIGHT (C) 1989  UNIVERSITY OF ROCHESTER.                             **
**                                                                           **
**  This program is free software; you can redistribute it and/or modify it  **
**  under the terms of the GNU General Public License as published by the    **
**  Free Software Foundation; either version 1, or (at your option) any      **
**  later version.                                                           ** 
**                                                                           **
**  This program is distributed in the hope that it will be useful, but      **
**  WITHOUT ANY WARRANTY; without even the implied warranty of               **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     **
**  See the GNU General Public License for more details.                     **
*******************************************************************************/

/*----------------------------------------------------------------------------
  Author: Mark Fanty
  Modifications: Nigel Goddard
  Date: May 7 1987
----------------------------------------------------------------------------*/

#include <stdio.h>
#include <ctype.h>
#include <sys/file.h>
#include <sys/types.h>
#include <ar.h>
#include <a.out.h>
#ifndef mips
#include <ranlib.h>
#endif


#ifdef mips
#define NAME_OFFSET 0
#else
#define NAME_OFFSET 1
#endif

#define FALSE 0
#define TRUE 1

long lseek();
char *malloc();

static char * strings;		/* array of names - malloced later */
static int * indx;		/* each int a boolean */
static int funcnt = 0;		/* number of names */

/*----------------------------------------------------------------------------
  This program expects an arbitrary number of library files (created with
  ar and ranlib) as arguments.  It reads in all the function names in these
  libraries.  Then it reads from stdin until EOF, expecting input as produced
  by nm -g of a .o file.  It outputs the names of all defined procedures and
  all undefined procedures that have the same name as one of the library
  function names read in previously.  The output is intended for makebind or
  cmdmkbind, which creates a C program that loads all these function names
  into the simulator function table.
----------------------------------------------------------------------------*/

main(argc,argv)
     int argc;
     char *argv[];
{
  int c;
  char buf[50];
  int i, fd, libcnt = -1, stringsz = -1, acc;
  
  if(argc > 1)
  {				/* have to do library check */
  for (libcnt = 1, funcnt = 0;
       libcnt < argc; libcnt++) /* for each library file */
    {
      fd = open(argv[libcnt],O_RDONLY,0);
      stringsz += FindFuncCnt(fd); /* find out length of ALL lib func names */
      close(fd);
    }
  
  strings = malloc((unsigned)stringsz+1); /* first byte unused; to hold lib func names */
  strings++;			/* first byte unused */
  for (libcnt = 1, acc = 0; libcnt < argc; libcnt++)
    {				/* for each library file */
      fd = open(argv[libcnt],O_RDONLY,0);
      stringsz = FindFuncCnt(fd); /* get file pointer to start of names */
      if(read(fd,strings+acc,stringsz) == -1)
	{			/* read in function names */
	  fprintf(stderr,"error in grabnames: read error 4");
	  exit(1);
	}
      close(fd);
      acc +=stringsz;		/* where to add names for next lib file */
    }

  for (i = 0, funcnt = 0;
       i < stringsz;
       i += strlen(&strings[i])+1, funcnt++); /* get function count */
  indx = (int *) malloc(funcnt * sizeof(int));	/* for indices into strings */
  for (i = 0, funcnt = 0;
       i < stringsz;
       i += strlen(&strings[i])+1, funcnt++) /* get indices of names */
    indx[funcnt] = i+1;	/* first byte unused so all indices > 0 */
  strings--;			/* reset to include first byte */
  }

  while(TRUE)
    {				/* read from stdin one line at a time */
      for(c = getchar();!isupper(c);c = getchar())
	if(c == EOF) break;
      if(c == 'T')		/* defined procedure */
	{
	  getchar();		/* skip blank */
	  scanf("%s",buf);	/* this is the name */
	  printf("%s\n",&buf[NAME_OFFSET]);
	}
      if(c == 'U' && libcnt > 0)/* undefined (library ?) procedure */
	{			/* irrelevant if no libraries given */
	  getchar();		/* skip blank */
	  scanf("%s",buf);	/* this is the name */
	  if(inlib(buf))	/* check if indeed a library function */
	    printf("%s\n",&buf[NAME_OFFSET]);
	}
      for(c = getchar();c != '\n' && c != EOF;c = getchar());
      if(c == EOF) break;
    }
  return(0);			/* important this returns 0 */
}

/*----------------------------------------------------------------------------
  This function looks through the list of library functions for one that
  matches <st>.  If found, resets the index value to zero so can't be
  found again, and returns TRUE.  Otherwise returns FALSE.
----------------------------------------------------------------------------*/

inlib(st)
    char *st;
{
  int i;

  for (i = 0; i < funcnt; i++)
    if (indx[i] > 0 && !strcmp(st,&strings[indx[i]]))
      {
	indx[i] = 0;		/* all indices > 0 to begin with */
	return TRUE;
      }
  return FALSE;
}

/*----------------------------------------------------------------------------
  This function walks through a library file <fd> to the function names,
  and returns the size of the function names, leaving the file pointer
  ready to read in the function names.
----------------------------------------------------------------------------*/

int FindFuncCnt(fd)
     int fd;

{
  int stringsz, status, size;

  if(fd == -1)
    {
      fprintf(stderr,"error in grabnames: cannot find library\n");
      exit(1);
    }
  if(lseek(fd,(long)strlen(ARMAG),L_INCR) == -1)
    {
      fprintf(stderr,"error in grabnames: lseek error");
      exit(1);
    }
  status = lseek(fd,(long)sizeof(struct ar_hdr),L_INCR);
  if(status == -1)
    {
      fprintf(stderr,"error in grabnames: lseek error");
      exit(1);
    }
  status = read(fd, (char *)&size, sizeof size);
  size >>= 3;
  if(status == -1)
    {
      fprintf(stderr,"error in grabnames: read error 2");
      exit(1);
    }
  if(lseek(fd,(long)(size*sizeof(struct ranlib)),L_INCR) == -1)
    {
      fprintf(stderr,"error in grabnames: lseek error");
      exit(1);
    }
  if(read(fd, (char *)&stringsz, sizeof stringsz) == -1)
    {
      fprintf(stderr,"error in grabnames: read error 3");
      exit(1);
    }
  return stringsz;
}

