/******************************************************************************
**  The Rochester Connectionist Simulator - a neural network simulator.      **
**  COPYRIGHT (C) 1989  UNIVERSITY OF ROCHESTER.                             **
**                                                                           **
**  This program is free software; you can redistribute it and/or modify it  **
**  under the terms of the GNU General Public License as published by the    **
**  Free Software Foundation; either version 1, or (at your option) any      **
**  later version.                                                           ** 
**                                                                           **
**  This program is distributed in the hope that it will be useful, but      **
**  WITHOUT ANY WARRANTY; without even the implied warranty of               **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     **
**  See the GNU General Public License for more details.                     **
*******************************************************************************/

/* definitions unique to butterfly sim-node code */

extern int MySimNumber;

/* unit array */
extern unsigned int TimeStart;	/* to time runs */
extern unsigned int TimeFinish;

extern Output **OutputArrays;


/** functions **/
extern char * calloc();
extern FILE *fopen(), *popen(), *stream_fdopen();

#define BFLYTHROW(a,b)

#define NOBFLYTHROW(str,num) onthrow \
  when(TRUE) \
    { \
      LOGfprintf(stderr,"sim[%d]: throw in %s: %s\n",num,str,throwtext); \
      fflush(stdout); \
      Sleep(1000); \
      exit(1); \
    } \
 endcatch

/* end of sim definitions */


