/******************************************************************************
**  The Rochester Connectionist Simulator - a neural network simulator.      **
**  COPYRIGHT (C) 1989  UNIVERSITY OF ROCHESTER.                             **
**                                                                           **
**  This program is free software; you can redistribute it and/or modify it  **
**  under the terms of the GNU General Public License as published by the    **
**  Free Software Foundation; either version 1, or (at your option) any      **
**  later version.                                                           ** 
**                                                                           **
**  This program is distributed in the hope that it will be useful, but      **
**  WITHOUT ANY WARRANTY; without even the implied warranty of               **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     **
**  See the GNU General Public License for more details.                     **
*******************************************************************************/

/* definitions for butterfly control and sim node code */

typedef struct comd {
    /* general purpose */
    int cmd;
    int ulow;
    int uhigh;			/* for ranges */
    int idata1,idata2,idata3,idata4,idata5,idata6,idata7,idata8,idata9;
    char sdata1[80];
    char sdata2[80];
    char sdata3[80];
    char sdata4[80];
    char sdata5[80];
    char sdata6[80];
    char sdata7[80];
    char sdata8[80];
    OID OIDdata;

    /* for sim answer */
    int answer;

    /* for building links */
    int weight;
    int ldata;
    int from;

    /* for building units */
    int init_potential;
    int potential;		/* potential */
    int udata;
    int output;		/* output */
    int init_state;
    int state;			/* state */
    unsigned int sets;		/* set membership bits */
    unsigned int ubits;		/* general purpose bits */

    /* for building sites */
    int sidata;

    /* for piping data */
    int PipeFlag;
    QH  pipeQ;
    
    /* for listing/showing */
    int first;
} Command, *Commandp;

struct nametable
  {
    OID table;
    OID index;
    OID lock;
  };

/* structure for info on each sim */

typedef struct siminfo
  {
    int lastunit;
  } SimInfo;

#define EVERY_N		-1	/* unit value meaning all units */

#define UNITS   	0	/* for disp  command */
#define LINKS		1

#define MAPIN_C 	2	/* the following are command codes */
#define RESET_C		3
#define GO_C		4
#define UPDATE_C	5
#define LIST_C		6
#define DISP_C 		7
#define POT_C		8
#define OUT_C		9
#define STATE_C		10
#define SHOW_C		11
#define SHOWPOT_C	12
#define SHOWADD_C	13
#define SHOWDEL_C	14
#define SHOWLIST_C	15
#define MAKEUNIT_C	16
#define ADDSITE_C	17
#define MAKELINK_C	18
#define RCALL_C 	19
#define MOD_NAME 	20
#define SAVE_C 		21
#define GPOT_C 		22
#define GOUT_C 		23
#define GSTATE_C	24
#define STATUS_C	25
#define DECSET_C        26
#define DELSET_C        27
#define ADDSET_C        28
#define REMSET_C        29
#define MEMSET_C        30
#define SETFLG_C        31
#define TSTFLG_C        32
#define UNSFLG_C        33
#define UNIONSET_C      34
#define INTERSET_C      35
#define DIFFSET_C       36
#define INVERSET_C      37
#define WEIGHT_C        38
#define LISTUNIT_C      39
#define LISTLINKS_C     40
#define SHOWSETADD_C    41
#define SHOWSETDEL_C    42
#define ASYNC_C         43
#define FSYNC_C         44
#define SYNC_C          45
#define RWEIGHT_C       46

/* used to store unit and unit structure (vector) names, set and state
   names and other strings; not all fields used for each type */

typedef struct n_i_desc {
        char    name[22]; /* Pointer to name*/
	short	type;	/* Type of unit {0=SCALAR,1=VECTOR,2=ARRAY} */
	short	size;	/* Size of array if Type 1, width of row if 2 */
	short   length; /* number of rows if type 2 */
	int	index;	/* Index number */
      } NameDesc;

/* unit index consists of a table (= sim) number and an offset in the table */

typedef struct ind
    {	      
      short table;
      short offset;
    } Index;

/* maximum prime number of NameDesc's that will fit in 64k */

#define NO_RECORDS   2039

extern char **Names;		/* name list poiner */
extern int no_Names;	/* actual number of Names */
extern int NameSize;	/* default size of name table */

extern int NumberOfSims;
extern int UnitsEach;
extern SimInfo *Sims;
extern short *InLock;

#define STRCMP(s1,s2)  !strcmp(s1,s2) /* string comparison macro */

#define BFLYCATCH
#define NOBFLYCATCH catch

char * StoreString();
char * FindString();

/* end of multi definitons */
