#include "sim.h"

testbuild()

{
  int i,j,k, u,v,w;

  AllocateUnits(10);
  for (i = 0; i < 10; i++)
    {
      u = MakeUnit("test",UFsum,0,i,i,i,0,i);
      AddSite(u,"excite",SFweightedsum,0);
    }
  NameUnit("Scalar",SCALAR,0);
  NameUnit("Vector",VECTOR,1,3);
  NameUnit("Array",ARRAY,4,2,3);
  printf("Units 3 - 7 should be displayed, with all values set to the unit index, one\nsite each named `excite', unit function UFsum, site function SFweightedsum");
  extern_command_reader("disp unit 3 - 7");
  UserWait("Any key to continue...");
  for (i = 0; i < 10; i++)
    MakeLink(i,(i+1)%10,"excite",1000,(i+1)%10,NULL);
  printf("Units 8 and 9 should be displayed, with one link each (from 7 and 8\nrespectively), weights set to 1000 and data to unit index, NullFunc for\nlink function, and link value the same as the index of the source unit.\n");
  extern_command_reader("disp unit 8 - 9");
  UserWait("Any key to continue...");
  for (i = 1; i < 10; i++)
    AddSite(i,IndToName(i),NULL,NameToInd("Array",1,1));
  printf("Units 1 and 2 should be displayed, with an additional site with the same\nname as the unit, and site data set to 7, site function NullFunc\n");
  extern_command_reader("disp unit 1 - 2");
}

testdisp()

{
  int i,j,k, u,v,w;

  DeclareSet("SetOne");
  AddToSet("SetOne",NameToInd(IndToName(0)),3);
  printf("Units 0 to 4 should be displayed, 0 to 3 in `SetOne', 4 not.\n");
  extern_command_reader("disp unit 0 - 4");
  UserWait("Any key to continue...");
  DeclareSet("SetTwo");
  AddToSet("SetTwo",2,6);
  printf("Units 2 to 6 should be listed\n");
  extern_command_reader("l u SetTwo");
  UserWait("Any key to continue...");
  DeclareSet("SetThree");
  UnionSet("SetThree","SetOne","SetTwo");
  printf("Units 0 to 6 should be listed\n");
  extern_command_reader("l u SetThree");
  UserWait("Any key to continue...");
  DeclareSet("SetFour");
  IntersectSet("SetFour","SetOne","SetTwo");
  printf("Units 2 and 3 should be listed\n");
  extern_command_reader("l u SetFour");
  UserWait("Any key to continue...");
  DeclareSet("SetFive");
  DifferenceSet("SetFive","SetThree","SetFour");
  printf("Units 0, 1, 4, 5, 6 should be listed\n");
  extern_command_reader("l u SetFive");
  UserWait("Any key to continue...");
  DeclareSet("SetSix");
  InverseSet("SetSix","SetFive");
  printf("Units 2,3,7,8,9 should be listed\n");
  extern_command_reader("l u SetSix");
  UserWait("Any key to continue...");
  if (!MemberSet("SetSix",9))
    printf("MemberSet test failed\n");
  else
    printf("MemberSet test succeeded\n");
  UserWait("Any key to continue...");
  DeleteSet("SetFour");
  printf("Message should read something like: `SetFour is not a UnitId!'\n");
  extern_command_reader("l u SetFour");
  UserWait("Any key to continue...");
  DeclareSet("SetFour");
  printf("Unit listing header should be printed, but no units listed.\n");
  extern_command_reader("l u SetFour");
  UserWait("Any key to continue...");
  RemFromSet("SetSix",4,8);
  printf("Units 2,3,9 should be listed\n");
  extern_command_reader("l u SetSix");
  UserWait("Any key to continue...");
  DeclareSet("TestSet");
  DeleteSet("TestSet");
  SetOutput(1,100);
  SetPotential(2,200);
  SetState(3,300);
  SetData(4,400);
  printf("Units 1 to 4 should be displayed, unit 1 output = 100, unit 2 potential = 200,\nunit 3 state = 300, unit 4 data = 400\n");
  extern_command_reader("d u 1 - 4");
  UserWait("Any key to continue...");
  if (GetOutput(1) != 100)
    printf("GetOutput failed\n");
  if (GetPotential(2) != 200)
    printf("GetPotential failed\n");
  if (GetState(3) != 300)
    printf("GetState failed\n");
  if (GetData(4) != 400)
    printf("GetData failed\n");
  RandomiseWeights(500,100);
  printf("All weights should be spread randomly between 400 and 600\n");
  extern_command_reader("l c");
  UserWait("Any key to continue...");
  SetWeight(0,9,FALSE,0,0,3,FALSE,0,"excite",FALSE,-1000);
  printf("All displayed weights on links into `excite' sites should be -1000\n");
  extern_command_reader("d u 0 - 3");
  UserWait("Any key to continue...");
  for (i = 0; i < 10; i++)
    SetState(i,i);
  DeclareState("ZERO",0);
  DeclareState("ONE",1);
  DeclareState("TWO",2);
  DeclareState("THREE",3);
  printf("Units %d to %d should be displayed, with state name describing\nthe unit index\n",NameToState("ZERO"),NameToState("THREE"));
  extern_command_reader("d u 0 - 3");
  UserWait("Any key to continue...");
  if (strcmp("testdisp",FuncToName(testdisp)))
    printf("something wrong when getting function name\n");

  printf("net test finished\n");
}

testflag()

{
  int i,j,k, u,v,w, ok;
  Unit * up;

  for (i = 0; i < 10; i++)
    UnitList[i].flags = 0;
  for (i = 0; i < 32; i++)
    for (j = 0; j < 10; j++)
      SetFlag(j,i);
  for (i = 0, ok=TRUE; i < 10; i++)
    if (UnitList[i].flags != 0xffffffff)
      ok=FALSE;
  if (!ok)
    printf("SetFlag test failed\n");

  for (i = 0; i < 10; i++)
    UnitList[i].flags = 0;
  for (i = 0; i < 32; i++)
    for (j = 0, up = UnitList; j < 10; j++,up++)
      SetFlagP(up,i);
  for (i = 0, ok = TRUE; i < 10; i++)
    if (UnitList[i].flags != 0xffffffff)
      ok = FALSE;
  if (!ok)
    printf("SetFlagP test failed\n");

  for (i = 0; i < 10; i++)
    UnitList[i].flags = 0xffffffff;
  for (i = 0; i < 32; i++)
    for (j = 0; j < 10; j++)
      UnsetFlag(j,i);
  for (i = 0, ok = TRUE; i < 10; i++)
    if (UnitList[i].flags != 0)
      ok = FALSE;
  if (!ok)
    printf("UnsetFlag test failed\n");

  for (i = 0; i < 10; i++)
    UnitList[i].flags = 0xffffffff;
  for (i = 0; i < 32; i++)
    for (j = 0, up = UnitList; j < 10; j++,up++)
      UnsetFlagP(up,i);
  for (i = 0, ok = TRUE; i < 10; i++)
    if (UnitList[i].flags != 0)
      ok = FALSE;
  if (!ok)
    printf("UnsetFlagP test failed\n");

  for (i = 0; i < 10; i++)
    UnitList[i].flags = 0;
  for (i = 0, ok = TRUE; i < 32; i++)
    for (j = 0; j < 10; j++)
      if (TestFlag(j,i))
        ok = FALSE;
  if (!ok)
    printf("TestFlag test failed\n");

  for (i = 0; i < 10; i++)
    UnitList[i].flags = 0xffffffff;
  for (i = 0, ok = TRUE; i < 32; i++)
    for (j = 0; j < 10; j++)
      if (!TestFlag(j,i))
        ok = FALSE;
  if (!ok)
    printf("TestFlag test failed\n");

  for (i = 0; i < 10; i++)
    UnitList[i].flags = 0;
  for (i = 0, ok = TRUE; i < 32; i++)
    for (j = 0, up = UnitList; j < 10; j++, up++)
      if (TestFlagP(up,i))
        ok = FALSE;
  if (!ok)
    printf("TestFlagP test failed\n");

  for (i = 0; i < 10; i++)
    UnitList[i].flags = 0xffffffff;
  for (i = 0, ok = TRUE; i < 32; i++)
    for (j = 0, up = UnitList; j < 10; j++,up++)
      if (!TestFlagP(up,i))
        ok = FALSE;
  if (!ok)
    printf("TestFlagP test failed\n");

  printf("flag test finished\n");
}

teststamp()

{
  FILE * fp;

      if ((fp = fopen("/tmp/conntest1","w")) == NULL)
        {
          printf("couldn't open file... can't do test\n");
          return;
        }
      if (!StampFile(fp,TRUE))
        {
          printf("stamp file failed for checkpoint file\n");
          return;
        }
      fflush(fp);
      close(fp);
      fp = NULL;
      if ((fp = fopen("/tmp/conntest1","r")) == NULL)
        {
          printf("couldn't open file... can't do test\n");
          return;
        }
      if (!CheckStamp(fp,TRUE))
        printf("check stamp failed for checkpoint file\n");
      system("rm /tmp/conntest1");
      close(fp);
      if ((fp = fopen("/tmp/conntest2","w")) == NULL)
        {
          printf("couldn't open file... can't do test\n");
          return;
        }
       if (!StampFile(fp,FALSE))
        {
          printf("stamp file failed for save file\n");
          return;
        }
      fflush(fp);
      close(fp);
      if ((fp = fopen("/tmp/conntest2","r")) == NULL)
        {
          printf("couldn't open file... can't do test\n");
          return;
        }
      if (!CheckStamp(fp,FALSE))
        printf("check stamp failed for load file\n");
      close(fp);
/*      system("rm /tmp/conntest2");*/
      printf("time stamp test finished\n");
}

  
Cmd_test()

{
  testbuild();
  testdisp();
  testflag();
  teststamp();
}
