/*----------------------------------------------------------------------------

  The Rochester Connectionist Simulator.  Copyright Univesity of Rochester.
  Author: Nigel Goddard & Toby Mintz
  Date: May 1 1987

----------------------------------------------------------------------------*/

/* "cmdmkbind" takes one argument which will be the name of the output file.
 * ".bind.c" is concatonated onto the end of the filename.  The finall
 * name must not be more than FN_LEN characters.  "makebind" reads
 * the procedures names from stdin.  The procedure names must be
 * separated by blanks of new lines.  The procedure names must not be
 * longer than PN_LEN characters.  "cmdebind" then outputs the 
 * resulting program to <filename>.bind.c .
 * It differs from "makebind" only in the names of the functions it writes.
 */

#include        <stdio.h>
/* file name length */
#define FN_LEN  50
/* procedure name length */
#define PN_LEN  50

struct proc {
        char    p_name[PN_LEN+1];       /* Procedure Name */
        struct proc     *p_next;        /* Pointer to next */
} *procs = 0;

/* add_proc Creates a new proc cell and stores "name."  Returns a pointer
 * to the new proc cell.
 */

struct proc * add_proc(name)
char    name[];
{
        struct proc     *p_tmp;

        p_tmp = (struct proc *)malloc(sizeof(struct proc));
        if (!p_tmp) {
                perror("makebind->add_proc");
                exit(-1);
        }

        p_tmp->p_next = procs;
        strcpy(p_tmp->p_name, name);
        procs = p_tmp;
        return p_tmp;
}

main(argc, argv)
int     argc;
char    *argv[];
{
        char    bind_file[FN_LEN+1],    /* Output file name */
                tmp_proc[PN_LEN+1];     /* For reading in procs */
        FILE    *bind_fp;               /* Output file pointer */
        int     size = 0,               /* For the #define in the output */
                count;                  /* General counter */
        struct proc     *p_tmp;

/* |||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
 *   The following are format strings for output.  The different sections
 *   have nothing special about them, they are sectioned the way they
 *   are for programming convenience
 * \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\///////////////////////////////////// */
        char    *sec_0 = "\nsi_get_cmd_no(length)\n    int *length;\n{\n   *length = SIZE;\n}\n\n";
        char    *sec_1 = "#include \"sim.h\"\n#define\tSIZE\t%d\n\n";
        char    *sec_2 = "int NullFunc();\n";
        char    *sec_3 = "si_cmd_bind_func()\n{\n    AddItemToTable(\"NullFunc\",NullFunc,FUNC_SYM,-1,NULL,-1);\n";
        char    *sec_4 = "    AddItemToTable\(\"%s\",%s,FUNC_SYM,-1,NULL,-1);\n";
        char    *sec_5 = "    \n}\n";

/* //////////////////////////////\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\ */

/******  Get the output file name and open the file for writing  ******/

        if (!argv[1]) {
                printf("Usage: makebind <filename> < functions\n");
                exit(0);
        } else strcpy(bind_file, argv[1]);
        strcat (bind_file, ".bind.c");
        if ((bind_fp = fopen(bind_file, "w")) == 0) {
                perror("makebind");
                exit(-1);
        }
        
        while((scanf("%s", tmp_proc)) != EOF) { /* Read a proc */
                add_proc(tmp_proc);             /* and add it to the list */
                ++size;                         /* Incr. size */
        }

        if (!size) {
                printf("There are no procedures!!!!!\n");
                exit(0);
        }

        fprintf(bind_fp, sec_1, size+1);
        fprintf(bind_fp, sec_2);
        for (p_tmp = procs; p_tmp; p_tmp = p_tmp->p_next)
                fprintf(bind_fp, "int %s\(\);\n", p_tmp->p_name);
        fprintf(bind_fp, sec_0);
        fprintf(bind_fp, sec_3);
        for (p_tmp = procs, count = 0; p_tmp; p_tmp = p_tmp->p_next, count++)
                fprintf(bind_fp, sec_4, p_tmp->p_name, p_tmp->p_name);
        fprintf(bind_fp, sec_5);
        fclose(bind_fp);
        return 0;
}
