/* include file for uniprocessor code */

#include <stdio.h>
#include "Stupido:rochester:include:lib.h"           

/* used to store unit and unit structure (vector) names, set and state
   names and other strings; not all fields used for each type */
typedef struct n_i_desc
      {
        char    *name;  /* Pointer to name */
        short   type;   /* Type of unit {0=SCALAR,1=VECTOR,2=ARRAY} */
        short   size;   /* Size of array if Type 1, width of row if 2 */
        short   length; /* number of rows if type 2 */
        int     index;  /* Index number */
        struct n_i_desc *next;
      } NameDesc;

typedef char Index;             /* for name table */

#define SCALAR          0
#define VECTOR          1
#define ARRAY           2
#define SET_SYM         3
#define STATE_SYM       4
#define STRING_SYM      5
#define TYPE_SYM        6
#define FUNC_SYM        7
#define SITE_SYM        8
#define DATA_SYM        9
#define CODE_SYM        10

#define FALSE           0
#define TRUE            1
#define ARGLEN          40

#define ASYNC           0
#define SYNC            1
#define FAIRASYNC       2

typedef func_type (* func_ptr)();

#ifdef UDATA
# include UDATA
#else
  typedef data_type unit_data_type;
  typedef data_type site_data_type;
  typedef data_type link_data_type;
#endif

#ifdef TSIM
#  define Outvec Output *
#else
#  define Outvec Output
#endif

/* link */
typedef struct link{
    func_ptr link_f;
    weight_type weight;
    Output * value;
    link_data_type data;
    int from_unit;
    struct link *next;
} Link;

/* site */
typedef struct site{
    char * name;
    Output value;
    short no_inputs;
    site_data_type data;
    func_ptr site_f;
    Link * inputs;              /* array of inputs */
    struct site *next;
} Site;

/* unit */
typedef struct unit{
    unsigned int flags;         /* misc. flags */
    char * type;                /* pointer to stored string */
    func_ptr unit_f;    /* function pointers */
    char * name;                /* ptr to stored string */
    pot_type init_potential;
    pot_type potential;         /* potential */
    Output output;              /* output */
    short init_state;
    short state;                /* state */
    short no_site;
    unit_data_type data;
    unsigned int sets;          /* set membership bits */
    Site * sites;               /* array of sites */
} Unit;

typedef union i_p
{                               /* points to an item in core */
  int * intval;                 /* four byte quantity */
  float * floatval;
  func_ptr func;
  char * fileinfo;
} item_ptr;

typedef struct d_m              /* Item Table entry type */
{
  int next;                     /* index in table of next item for this file */
  char * name;                  /* pointer to name of item */
  item_ptr item;                /* for the data pointer to name mapping */
} MappingTable;

/* system defined flags */
#define SHOW_FLAG 0
#define LIST_FLAG 1
#define NO_LINK_FUNC_FLAG 2
#define NO_SITE_FUNC_FLAG 3
#define NO_UNIT_FUNC_FLAG 4
#define STEP_SIM_FLAG 5
#define LIMIT_SIM_FLAG 6

extern int MakeUnit();
extern Site * AddSite();
extern Link * MakeLink();
#ifdef TSIM
extern Link * MakeDelayLink();
#endif

extern int NoUnits;             /* number of units in the net */
extern int LastUnit;            /* last unit made */

extern char **StateNames;       /* state Names */
extern int NoStates;            /* number of states with Names */
extern int StateCount;          /* actual number of states with Names */

extern char *SetNames[32];      /* set Names */
extern int LastSet;
extern int NoSets;

extern int NoLinks;

extern int Clock;               /* the system Clock */

extern FILE *Dispf;             /* display output (pipe to more) */

extern int SyncFlag;

extern int ExecFract;
extern int ExecLimit;

extern int Pause;               /* if 1, Pause after every Show */
extern int EchoStep;            /* print message after EchoStep steps
                                   of simulation */
extern char PipeCommand[];      /* pipe command string */
extern int PipeFlag;            /* 0 means pipe off, 1 means pipe on*/

extern int Debug;               /* 0 if not debug, != 0 if debugging */
extern unsigned int Errors;     /* bit vector for debug errors */
extern int AutoFix;             /* 0 if no auto-fix, for debugging */
extern int Logging;             /* 0 if not logging, 1 if logging */
extern FILE * LogFile;          /* file pointer for Log file */

extern int Format;              /* if TRUE, output via LOGfprintf will be
                                   formatted */

extern int Show;                /* global flag indicating Show on/off */
extern int ShowStep;            /* plot values at ShowStep time steps */
extern int ShowPot;             /* potential threshold for Showing */
extern unsigned int ShowSets;   /* set bits for sets to be shown */

extern Index * EnterName();
extern Index * AlterName();

/* name table functions */
extern NameDesc *FindName();
extern char *IndToName();
extern char *StateToName();
extern func_ptr NameToFunc();
extern char *FuncToName();
extern char *IndToFuncName();
extern int NullFunc();
extern MappingTable * IndexToItem();
extern MappingTable * NameToItem();
extern MappingTable * PointerToItem();
extern FLINT GetOutput();
extern FLINT GetPotential();
extern FLINT GetData();

/* macro which tests bounds of unit index */
#define LegalUnit(x) ((x) >= 0 && (x) < NoUnits)
#define UnitIndex(up) ((up)-UnitList)

/* set macros using unit index */
#define AddSetI(si,ui) (UnitList[ui].sets |= 1<<(si))
#define RemSetI(si,ui) (UnitList[ui].sets &= ~(1<<(si)))
#define MemberSetI(si,ui) ((UnitList[ui].sets>>(si)) & 1)

/* set macros using unit pointer */
#define AddSetP(si,up) (up->sets |= 1<<(si))
#define RemSetP(si,up) (up->sets &= ~(1<<(si)))
#define MemberSetP(si,up) (up->sets & (1 << (si)))

/* set macros using unit sets */
#define MemberSetS(si,ss) (ss & (1 << (si)))

/* flag macros using unit index*/
#define SetFlag(ui,flag) (UnitList[ui].flags |= 1<<(flag))
#define UnsetFlag(ui,flag) (UnitList[ui].flags &= ~(1<<(flag)))
#define TestFlag(ui,flag) (UnitList[ui].flags & (1 << (flag)))

/* flag macros using unit pointer*/
#define SetFlagP(up,flag) (up->flags |= (1 << (flag)))
#define UnsetFlagP(up,flag) (up->flags &= ~(1 << (flag)))
#define TestFlagP(up,flag) (up->flags & (1 << (flag)))

/* flag macros using unit flags*/
#define TestFlagF(uf,flag) (uf & (1 << (flag)))


extern Unit *UnitList;          /* unit array pointer */
extern Outvec *Outputs;         /* output list pointer */

