#include	"widget_core.h"
/*
** widget
**
*/
struct widget_type {
	WIDGET_TYPE
};

/*
** xform
**
*/
struct xform_type {
	WIDGET_TYPE
	int	labelflag;
};

/*
** xlabel
**
*/
struct xlabel_type {
	WIDGET_TYPE
};

/*
** xtext
**
*/
struct xtext_type {
	WIDGET_TYPE
	char	*file;
};

/*
** xdialog
**
*/
struct xdialog_type {
	WIDGET_TYPE
	char	*value;
};

/*
** xbutton
**
*/
struct xbutton_type {
	WIDGET_TYPE
};

/*
** xtoggle
**
*/
struct xtoggle_type {
	WIDGET_TYPE
	int	state;
	char *label0;
	char *label1;
};

/*
** xaxisgraph
**
*/
struct xaxisgraph_type {
	WIDGET_TYPE
	float	xmin;
	float	ymin;
	float	xmax;
	float	ymax;
	short	overlay;
	float	xoffset;
	float	yoffset;
	short	last_plot;
	short	phase_plot;
	char	*XUnits;	
	char	*YUnits;	
};


/*
** xdraw
**
*/
struct xdraw_type {
	WIDGET_TYPE
	float	cx;
	float	cy;
	float	cz;
	float	vx;
	float	vy;
	float	vz;
	float	wx;
	float	wy;		
	char	*value;		/* returned value of widget */
	char	*pixchoose;	/* name of pix to display */
	char	*transform;	/* name of function */
	char	*refresh_flag;	/* flag for refreshing on pix changes */
};

/*
** xview
**
*/
struct	xview_type {
	ELEMENT_TYPE
	char 	*pix;
	char 	*pixname;
	/* Subresource fields */
	char	*viewmode;	/* scaling method used to display values */
	char	*viewicon;	/* name of icon used for scaling  */
	char	*pixcolor;
	char	*hlhistmode;	/* hilight history mode */
	char	*hldispmode;	/* hilight display mode	*/
	char	*path;		/* path to widget		*/
	char	*field;		/* name of field 		*/
	float	vmin;
	float	vmax;
	char	*autoscale;
	int		nx;
	int		ny;
	char	*autospace;
	float	ox,oy,oz;	/* offset coords	*/
};

/*
** xfileview
**
*/
struct	xfileview_type {
	ELEMENT_TYPE
	char 	*pix;
	char 	*pixname;
	/* Subresource fields */
	char	*viewmode;	/* scaling method used to display values */
	char	*viewicon;	/* name of icon used for scaling  */
	char	*pixcolor;
	char	*hlhistmode;	/* hilight history mode */
	char	*hldispmode;	/* hilight display mode	*/
	char	*path;		/* path to file		*/
	float	time;		/* time being displayed	*/
	float	vmin;
	float	vmax;
	char	*autoscale;
	int		nx;
	int		ny;
	char	*autospace;
	float	ox,oy,oz;	/* offset coords	*/
};

/*
** xelmtree
**
*/
struct xelmtree_type {
	ELEMENT_TYPE
	char  	*pix;
	char 	*pixname;
	char	*linkmode;		/* whether to show links/stems/both */
	char	*hlhistmode;	/* hilight history mode */
	char	*hldispmode;	/* hilight display mode	*/
	char	*path;		/* path to widget		*/
	char	*value;		/* returned value of widget */
};


/*
** xconn
**
*/
struct xconn_type {
	ELEMENT_TYPE
	char	*pix;
	char 	*pixname;
	/* Subresource fields */
	char	*viewmode;	/* scaling method used to display values */
	char	*viewicon;	/* name of icon used for scaling  */
	char	*pixcolor;
	char	*hlhistmode;	/* hilight history mode */
	char	*hldispmode;	/* hilight display mode	*/
	char	*path;		/* path to widget		*/
	char	*field;		/* name of field 		*/
	float	vmin;
	float	vmax;
	char	*autoscale;
	int		nx;
	int		ny;
	char	*autospace;
	float	ox,oy,oz;	/* offset coords	*/
	char	*outlinemode;
	char	*outlineicon;
	char	*anterograde;	/* Direction of tracer transport */
};

/*
** xlabel
**
struct xtext_type {
	ELEMENT_TYPE
	char	*pix;
	char	*pixname;
	char	*hlhistmode;
	char	*hldispmode;
	int		textno;
	char	*textmode;
	char	*text;
	char	*textvalue;
	char	*iconname;
	char	*	textcolor;
	float	lx;
	float	ly;
	float	lz;
};
*/

struct xshape_type {
	ELEMENT_TYPE
	char	*pix;
	char	*pixname;
	char	*pixcolor;
	char	*drawmode;
	char	*coords;
	int		linewidth;
	char	*linestyle;
	char	*capstyle;
	char	*joinstyle;
	char	*textmode;
	char	*text;
	char	*textcolor;
	char	*font;
	char	*iconname;
	char	*hlhistmode;
	char	*hldispmode;
	char	*value;
	float	tx,ty,tz;
};

struct xcell_type {
	ELEMENT_TYPE
	char	*pix;
	char	*pixname;
	char	*fatfield;
	char	*autofat;
	char	*fatmin;
	char	*fatmax;
	char	*fatfix;
	char	*fatrange;
	char	*colfield;
	char	*autocol;
	char	*colmax;
	char	*colmin;
	char	*colfix;
	char	*path;
	char	*rootpath;
	char	*fieldpath;
	char	*labelmode;
	char	*rooticon;
	/*
	char	*iconscale;
	*/
	char	*ox;
	char	*oy;
	char	*oz;
	char	*hlhistmode;
	char	*hldispmode;
};

struct xpix_type {
	ELEMENT_TYPE
	char	*pix;
};

struct ximage_type {
	WIDGET_TYPE
	char	*filename;
	char	*fileformat;
	char	*storemode;
	char	*rescaleable;
	int		srcx;
	int		srcy; /* Position of top left corner of source of image */
	int		dstx;
	int		dsty; /* Where to draw image */
	int		wx;
	int		wy; /* size in pixels */
};
