#include "gen_ext.h"
#include "xodus_args.h"

XtCallbackProc	xdialog_callback();
char *g_copy();
static int xdialog_parser();

/*
** xdialog_func:	
**
*/
xdialog_func(element,action)
	struct xdialog_type 	*element;
	Action			*action;
{
	LayoutWidget	widget;
	char			*field;
	char		**argv;
	char			*value;
	char			*script;
	struct xdialog_type 	*new;
	Position		x,y;

	static	XtCallbackRec	callback[2];
	static struct valid_arg xdialog_args[] = {
		{"value", 0, 2},
		{"END", -1, -1}
	};

	if (x_status != 1) {
		fprintf(stderr,"X is not currently enabled.\n");
		fprintf(stderr,"  Please execute the 'xon' command.\n");
		return(0);
	}
	callback[0].callback = (XtCallbackProc)xdialog_callback;
	callback[0].closure = (caddr_t)NULL;
	callback[1].callback = (XtCallbackProc)NULL;
	callback[1].closure = (caddr_t)NULL;



	switch(action->type) {
    		case CREATE: 
			widget = (LayoutWidget)do_dialog(action->argc,
				 action->argv);
			if (widget == NULL)
				return(0);
			element->widget = (Widget)widget;
			element->value = g_copy(x_arg(ARG_STRING));
			xfunc_core_create(element, callback);
			if (script = (char *)x_arg(ARG_SCRIPT)) {
				do_add_script(widget,script);
			}
			break;
    		case DELETE:
			genesis_destroy_widget(element);
			free(element->value);
			break;
    		case SET:
		argv = (char **) calloc(action->argc + 2,sizeof(char *));
		XoParseCoords(&(action->argc), action->argv, argv);
			if (x_parse_set(action->argc, argv, 
				xdialog_args))
			xfunc_parse_set(element, action->argc, argv,
				xdialog_parser);
			free(argv);
			break;
		case	COPY:
			genesis_no_copy();
			return(0);
	}
	return(1);
}

/*
** xdialog_callback:	When xdialog is changed from the screen this is 
**			called.
**
*/
XtCallbackProc
xdialog_callback(w, client_data, call_data)
	LayoutWidget	w;
	caddr_t	client_data;
	caddr_t	call_data;
{
	char		*string;
	XtCallbackRec	*callback_ptr;
	struct xdialog_type *element;

	element = (struct xdialog_type *)
		(((LayoutConstraints)(w->core.constraints))->
			layout.layout_element);

	if (element == NULL) {
			fprintf(stderr,"xdialog_callback: null element\n");
			return;
	}
	if (element->name == NULL || *element->name == NULL) 
		return;	/* just a realize call */

	xodus_core_set(element, w);

	string = (char *)DbutGetString(w);
	if (string != NULL && element->value != NULL)
		if (strcmp(element->value, string) == 0) 
			return;
	if (element->value != NULL) {
		free(element->value);
		element->value = NULL;
	}
	element->value = g_copy(string);
}

static int xdialog_parser(element, i, argc, argv)
	struct xdialog_type	*element;
	int			i;
	int			argc;
	char			**argv;
{
	char	*field, *value;
	field = argv[i];
	i++;
	if (i > argc) {
		fprintf(stderr,"SET: must specify a value field for '%s'\n",
			 argv[i]);
		return(-1);
	}
	value = argv[i];
	
	/*
	if (strcmp(field,"script") == 0) {
		if (element->script != NULL) {
			free(element->script);
			element->script = NULL;
		}
		if (value != NULL) 
			element->script = g_copy(value);
		return(2);
	}
	*/
	if (strcmp(field,"value") == 0) {
		if (element->value != NULL) {
			free(element->value);
			element->value = NULL;
		}
		if (value != NULL)  
			element->value = g_copy(value);
		DbutSetString(element->widget, value);
		return(2);
	} 
	return(0);
}
