#include "gen_ext.h"
#include "draw_w.h"

int	XoCreateConn();

void xconn_callback(w, client, call)
	LayoutWidget	w;
	caddr_t	client;
	caddr_t	call;
{
	struct xconn_type	*element;

	element = (struct xconn_type *)
		(((LayoutConstraints)(w->core.constraints))->
				layout.layout_element);
	if (element == NULL) {
		fprintf(stderr,"xconn_callback: null element\n");
		return;
	}
	xodus_core_set(element, w);
}

xconn_func(element,action)
	struct xconn_type *element;
	Action		*action;
{
	char	**argv;
	static struct valid_arg xconn_args[] = {
		{"pix", 0, 2},
		{"pixname", 0, 2}, 
		{"viewmode", 0, 2},
		{"viewicon", 0, 2},
		{"pixcolor", 0, 2},
		{"hlhistmode", 0, 2},
		{"hldispmode", 0, 2},
		{"path", 0, 2},
		{"field", 0, 2},
		{"vmin", 0, 2}, 
		{"vmax", 0, 2},
		{"autoscale", 0, 2},
		{"nx", 0, 2},
		{"ny", 0, 2},
		{"autospace", 0, 2},
		{"ox", 0, 2},
		{"oy", 0, 2},
		{"oz", 0, 2},
		{"outlinemode", 0, 2},
		{"outlineicon", 0, 2},
		{"anterograde", 0, 2},
		{"END", -1, -1}
	};
	if (x_status != 1) {
		fprintf(stderr,"X is not currently enabled.\n");
		fprintf(stderr,"  Please execute the 'xon' command.\n");
		return(0);
	}

	if(debug > 1){
		ActionHeader("Xconn",element,action);
	}

	switch(action->type) {
		/* 
		** Create needs to call the correct creation routine
		** and then set element->(items).  
		*/
    	case CREATE: 
			XoCreateElmPix(element,
				((struct xdraw_type *)action->data)->widget,
				action->argc,action->argv, XoCreateConn);
			break;
		/* 
		** Set needs to traverse all set arguemnts and set them
		** internal to the parent widget's sub-resources and
		** then set them for the element
		*/
    	case DELETE: 
                    drop_pix(Pathname(element->parent),
                                ((Pix *)(element->pix))->name);
                        break;
    	case SET:
		argv = (char **) calloc(action->argc + 2,sizeof(char *));
		XoParseCoords(&(action->argc), action->argv, argv);
			if (x_parse_set(action->argc, argv, xconn_args))
			XoSetElmPix(element, action->argc, argv);
			break;
		case RESET:
			break;
		case	COPY:
			genesis_no_copy();
			return(0);
		default:
			InvalidAction("Xconn",element,action);
			break;
	}
	return(1);
}
