
/* --------------------------------------------- */
/* The init routine for setting up a conn based on
 * the draw widget.
 *
 *	By Upi Bhalla
 */
/* --------------------------------------------- */

/* All the necessary include files */

#include "draw_ext.h"
#include "drawview_w.h"
#include "drawconn_w.h"

#define  MAXNSEL 100
static  int AddConnHl();
static  int DropConnHl();

Boolean ConnSetHook();

/*
** This file contains three script functions which deal with 
** connections and display of connections. Each takes a 
** widget and the path of an element as arguments. 
** The first, ShowConn, adds or removes the element from the
** sel_list depending on whether the element was already there. It
** then calls the appropriate refresh routines.
** The second, AddNewConn, adds a connection from the clicked element
** to the hilighted one(s).
** The third, DropOldConn, drops all the connections from the clicked
** element to the hilighted one(s).
** 
** Clearly, this approach is only useful in small circuits. 
** Enhancements will include -
** Provision for making/dropping connections to planes of elements
** Assignment of arrays to specify weights and delays
*/

/*
** ShowConn
** This routine takes an element path and checks the sel_elms list to
** see if the element is on it. If not, then it adds the element to the
** list, otherwise it drops the element from the list. 
** This routine is meant to be used from the script in conjucntion
** with clicking on the conn widget.
** After doing all the conn display stuff, this has to refresh the 
** highlights. Perhaps it should refresh the conn background too, but
** I feel that speed is  more important than cosmetics.
*/

ShowConn(argc,argv)
	int		argc;
	char	**argv;
{
	DrawWidget	dw;
	ConnPix	*pix;
	Element	*elm,*GetElement();
	Element	**elms;
	int		i;

	if (argc < 3) {
		printf("usage: %s widget path\n",argv[0]);
		return;
	}
	dw = (DrawWidget)XoGetWidgetFromString(argv[1]);
	elm = GetElement(argv[2]);
	if (!(dw && elm)) {
		fprintf(stderr,"could not change connection on '%s' '%s'\n", argv[1],argv[2]);
		return;
	}

	for (pix = (ConnPix *)dw->draw.images ; pix ; pix = (ConnPix *)pix->next) {
		if (pix->set_hook == ConnSetHook) {
			elms = ((ElmRescale *)(pix->rescale))->elms;
			for (i = 0 ; i < pix->npts ; i++) {
				if (elms[i] == elm) {
					if (!DropConn(&(dw->draw),pix,elm))
						AddConn(&(dw->draw),pix,elm);
					(pix->hilight->hl_refresh)(&(dw->draw),pix);
					break;
				}
			}
		}
	}
}

#define MAXSUMHL MAXNHL * 5

ShowConn2(argc,argv)
	int		argc;
	char	**argv;
{
	DrawWidget	dw;

	if (argc < 2) {
		printf("usage: %s widget\n",argv[0]);
		return;
	}
	dw = (DrawWidget)XoGetWidgetFromString(argv[1]);
	if (!(dw)) {
		fprintf(stderr,"could not show connection on '%s'\n",argv[1]);
		return;
	}
	ShowConn3(dw);
}

ShowConn3(dw)
	DrawWidget	dw;
{
	ConnPix	*pix;
	Pix		*temp;
	Element	*elm;
	Element	**elms;
	Element	**sels;
	Element	*hlelms[MAXSUMHL];
	int		nhlindex = 0;
	int		i,j;

	/* Scan the hilight lists and compare with the sel_list to 
	** get the conns that have been added or dropped */

	/* constructing an amalgamated hl list */
	for (pix = (ConnPix *)dw->draw.images ; pix ;
		pix = (ConnPix *)pix->next) {
		if (pix->set_hook == ConnSetHook) {
			elms = ((ElmRescale *)(pix->rescale))->elms;
			for (i = 0 ; i < pix->hilight->nhl ; i++) {
				hlelms[nhlindex] = elms[pix->hilight->index[i]];
				nhlindex++;
			}
		}
	}
	/* Looking for a valid pix to use for the sel list. */
	for (pix = (ConnPix *)dw->draw.images ; pix ;
		pix = (ConnPix *)pix->next) 
		if (pix->set_hook == ConnSetHook) break;
	if (!pix) return;

	/* scanning through the hl and sel-lists to find dropped elements */
	for (i = 0 ; i < *(pix->nsel) ; i++) {
		elm = pix->sel_elms[i];
		for (j = 0 ; j < nhlindex ; j++) {
			if (elm == hlelms[j])
				break;
		}
		if (j == nhlindex) {
		/* element not found in hlelms : Do the drop */
			/* cleaning up sel_elms */
			for (j = i ; j < *(pix->nsel) ; j++)
				pix->sel_elms[j] = pix->sel_elms[j + 1];
			(*pix->nsel)--;
			/* since nsel has been decremented, i should too */
			i--;

			/* Cleaning up display */
			for (temp = dw->draw.images ; temp ; temp = temp->next) {
				DropOldElmFromConnPix(&(dw->draw),temp,elm);
			}
		}	
	}

	/* Scanning through the hl and sel-lists to find added elements */
	for (i = 0 ; i < nhlindex ; i++) {
		for (j = 0 ; j < *pix->nsel ; j++) {
			if (hlelms[i] == pix->sel_elms[j])
				break;
		}
		if (j == *pix->nsel) {
		/* Element not found in sel-elms : add it in */
			/* add it to the sel_list */
			pix->sel_elms[*(pix->nsel)] = hlelms[i];
			(*(pix->nsel))++;

			/* add it to display */
			for (temp = dw->draw.images ; temp ; temp = temp->next) {
				AddNewElmToConnPix(&(dw->draw),temp,hlelms[i]);
			}
		}
	}
	/*
	ConnUpdateFunc(dw,pix);
	AddConnIcons(&(dw->draw),pix,0,pix->nconns);
	*/
}

static int AddConn(pict,pix,new_elm)
	DrawPart	*pict;
	ConnPix		*pix;
	Element		*new_elm;
{
	Pix		*temp;

	/*
	** Note that the sel_elms and nsel are common to all conns
	*/
	pix->sel_elms[*(pix->nsel)] = new_elm;
	(*(pix->nsel))++;

	for (temp = pict->images ; temp ; temp = temp->next) {
		AddNewElmToConnPix(pict,temp,new_elm);
	}
	return(1);
}

int AddNewElmToConnPix(pict,pix,new_elm)
	DrawPart	*pict;
	ConnPix		*pix;
	Element		*new_elm;
{
	int			i;
	Element		**elms;
	Element		*elm;
	Projection	*proj;
	Connection	**conns;
	Connection	*conn,*firstconn;
	int			*index;
	int			nconns = pix->nconns;
	int			len;
	GenesisObject		*object;
	int			is_proj = 0;

	if (pix->set_hook != ConnSetHook) return;
	elms = ((ElmRescale *)(pix->rescale))->elms;
	conns = pix->conns;
	index = pix->index;

	if (strcmp(pix->anterograde,"FALSE") == 0) {
		for (i = 0 ; i < pix->npts ; i++) {

			if (object != elms[i]->object) {
				object = elms[i]->object;
				if ((len = strlen(object->type)) < 15) {
					is_proj = 0;
				} else if (strcmp(&(object->type[len - 15]),
					"projection_type") != 0) {
					is_proj = 0;
				} else 
					is_proj = 1;
			} 
			if (!is_proj) 
				continue;

			proj = (Projection *)(elms[i]);
			conn = proj->connection;
			while (conn) {
				if (conn->target == (Segment *)new_elm) {
					conns[nconns] = conn;
					index[nconns] = i;
					nconns++;
					/* Do realloc stuff if chunksize exceeded */
					if (nconns >= pix->maxnconns) {
						pix->maxnconns += CHUNKSIZE;
						pix->conns = (Connection **)
							calloc(pix->maxnconns,sizeof(Connection *));
						bcopy(conns,pix->conns,
							nconns * sizeof(Connection *));
						conns = pix->conns;

						pix->index = (int *)
							calloc(pix->maxnconns,sizeof(int));
						bcopy(index,pix->index,
							nconns * sizeof(int));
						index = pix->index;
					}
				}
				conn = conn->next;
			}
		}
	} else { /* connections to this plane */
		/* version 0.8 */
		if ((len = strlen(new_elm->object->type)) < 15)
			return;
		if (strcmp(&(new_elm->object->type[len - 15]),
			"projection_type") != 0)
			return;

		if (!(firstconn = ((Projection *)(new_elm))->connection))
			return;
		for (i = 0 ; i < pix->npts ; i++) {
			conn = firstconn;
			elm = elms[i];
			while (conn) {
				if (conn->target == (Segment *)elm) {
					conns[nconns] = conn;
					index[nconns] = i;
					nconns++;
					/* Do realloc stuff if chunksize exceeded */
					if (nconns >= pix->maxnconns) {
						pix->maxnconns += CHUNKSIZE;
						pix->conns = (Connection **)
							calloc(pix->maxnconns,sizeof(Connection *));
						bcopy(conns,pix->conns,
							nconns * sizeof(Connection *));
						conns = pix->conns;

						pix->index = (int *)
							calloc(pix->maxnconns,sizeof(int));
						bcopy(index,pix->index,
							nconns * sizeof(int));
						index = pix->index;
					}
				}
				conn = conn->next;
			}
		}
	}
	pix->nconns = nconns;
	ConnUpdateFunc(pict->w,pix);
	AddConnIcons(pict,pix,0,nconns);
}

static int DropConn(pict,pix,old_elm)
	DrawPart	*pict;
	ConnPix		*pix;
	Element		*old_elm;
{
	Element		**elms;
	Pix			*temp;
	int			i,j;

	elms = pix->sel_elms;
	for (i = 0 ; i < *(pix->nsel); i++) {
		if (elms[i] == old_elm) {
			break;
		}
	}
	if (i == *(pix->nsel)) return(0);

	for (j = i ; j < (*(pix->nsel) - 1) ; j++)
		elms[j] = elms[j + 1];
	(*(pix->nsel))--;

	for (temp = pict->images ; temp ; temp = temp->next) {
		DropOldElmFromConnPix(pict,temp,old_elm);
	}
	return(1);
}

DropOldElmFromConnPix(pict,pix,old_elm)
	DrawPart	*pict;
	ConnPix		*pix;
	Element		*old_elm;
{
	int		i,j,k;
	Element	**elms;
	Element	*elm;
	Element	**conn_elms;
	Connection	**conns;
	Connection	*conn,*firstconn;
	int		*index;
	int		nconns = pix->nconns;


	if (pix->set_hook != ConnSetHook) return;
	conns = pix->conns;
	index = pix->index;
	if (strcmp(pix->anterograde,"FALSE") == 0) {
		for (i = 0 ; i < pix->nconns ; i++) {
			if (conns[i]->target == (Segment *)old_elm) {
				if (i == pix->nconns) return(0);
			/* checking how many conns in a row we have to drop */
				for (j = i; 
					(j < pix->nconns &&
					conns[j]->target == (Segment *)old_elm);
					j++);

			/* Dropping the conns in a row */
				DropConnIcons(pict,pix,i,j);
				j -= i;
				for (k = i ; k < (pix->nconns - j) ; k++) {
					conns[k] = conns[k + j];
					index[k] = index[k + j];
				}
				pix->nconns -= j;
			}
		}
	} else { /* connections to this plane */
		for (conn = ((Projection *)old_elm)->connection; conn ; 
			conn = conn->next) {
			for (i = 0 ; i < pix->nconns ; i++) {
				if (conns[i] == conn) {
					if (i == pix->nconns) return(0);
			/* finding how many conns in a row we have to drop */
					for (j = i + 1;
					conn && j < pix->nconns && conns[j] == conn->next ;
						conn = conn->next, j++);
			/* Dropping the conns in a row */
					DropConnIcons(pict,pix,i,j);
					j -= i;
					for (k = i ; k < (pix->nconns - j) ; k++) {
						conns[k] = conns[k + j];
						index[k] = index[k + j];
					}
					pix->nconns -= j;
				}
			}
			if (!conn) break;
		}
	}
	ConnUpdateFunc(pict->w,pix);
	AddConnIcons(pict,pix,0,pix->nconns);
}
