
#include <sys/time.h>
#include <sys/resource.h>
#include <stdio.h>
#define RUSAGE_SELF	0
#define RUSAGE_CHILDREN -1
struct rusage  rbuff;

rstats (fp) 
FILE *fp;
{
    getrusage (RUSAGE_SELF, &rbuff);
    fprintf (fp,"user time used\t\t= %ld sec  %ld usec\n", rbuff.ru_utime.tv_sec, rbuff.ru_utime.tv_usec);
    fprintf (fp,"system time used\t= %ld sec  %ld usec\n", rbuff.ru_stime.tv_sec, rbuff.ru_stime.tv_usec);
    fprintf (fp,"max set size in Kbytes \t= %d\n", rbuff.ru_maxrss);
    fprintf (fp,"shared memory size\t= %d\n", rbuff.ru_ixrss);
    fprintf (fp,"unshared data size\t= %d\n", rbuff.ru_ixrss);
    fprintf (fp,"shared stack size\t= %d\n", rbuff.ru_ixrss);
    fprintf (fp,"page reclaims\t\t= %d\n", rbuff.ru_minflt);
    fprintf (fp,"page faults\t\t= %d\n", rbuff.ru_majflt);
    fprintf (fp,"swaps\t\t\t= %d\n", rbuff.ru_nswap);
    fprintf (fp,"block inputs\t\t= %d\n", rbuff.ru_inblock);
    fprintf (fp,"block outputs\t\t= %d\n", rbuff.ru_oublock);
    fprintf (fp,"voluntary switches\t= %d\n", rbuff.ru_nvcsw);
    fprintf (fp,"involuntary switches\t= %d\n", rbuff.ru_nivcsw);
}

rtime (fp) 
FILE *fp;
{
    getrusage (RUSAGE_SELF, &rbuff);
    fprintf (fp,"user time used\t\t= %ld sec  %ld usec\n", rbuff.ru_utime.tv_sec, rbuff.ru_utime.tv_usec);
    fprintf (fp,"system time used\t= %ld sec  %ld usec\n", rbuff.ru_stime.tv_sec, rbuff.ru_stime.tv_usec);
}


rtd(utime,stime) 
double	*utime,*stime;
{
    getrusage (RUSAGE_SELF, &rbuff);
    *utime = (rbuff.ru_utime.tv_sec) + (rbuff.ru_utime.tv_usec)/((double)1.0e6);
    *stime = (rbuff.ru_stime.tv_sec) + (rbuff.ru_stime.tv_usec)/((double)1.0e6);
}

double	rtd_t() 
{
    getrusage (RUSAGE_SELF, &rbuff);
	return((rbuff.ru_utime.tv_sec) + (rbuff.ru_utime.tv_usec)/1.0e6
	+ (rbuff.ru_stime.tv_sec) + (rbuff.ru_stime.tv_usec)/1.0e6);
}

rtl(utime_s,utime_u,stime_s,stime_u) 
long	*utime_s,*utime_u,*stime_s,*stime_u;
{
    getrusage (RUSAGE_SELF, &rbuff);
	*utime_s = rbuff.ru_utime.tv_sec;
	*utime_u = rbuff.ru_utime.tv_usec;
	*stime_s = rbuff.ru_stime.tv_sec;
	*stime_u = rbuff.ru_stime.tv_usec;
}
