#include "sim_ext.h"

char *GetValue(adr,info)
char *adr;
Info *info;
{
char *name;
static char	string[100];
float fval;
double dval;

    string[0] = '\0';
    if(adr == NULL || info == NULL){
	return("");
    }
    if(info->function_type){
	name = GetFuncName(*((PFI *)adr));
	if(name != NULL)
	    sprintf(string,"%s",name);
	else
	    sprintf(string,"&%d",*((int *)adr));
    } else
    if(strcmp(info->type,"char") ==0){
	if(info->field_indirection == 1){
	    sprintf(string,"%s",*((char **)adr));
	} else
	if(info->field_indirection == 0){
	    sprintf(string,"%c",*((char *)adr));
	}
    } else 
    if(info->field_indirection >= 1){
	sprintf(string,"&%d",*((int *)adr));
    } else 
    if(strcmp(info->type,"int") ==0){
	    sprintf(string,"%d",*((int *)adr));
    } else
    if(strcmp(info->type,"float") ==0){
	fval = *((float *)(adr));
/*
	if((fabs(fval) < 1e-6 || fabs(fval) > 1e6)
	 && fval != 0.0)
	    sprintf(string,"%e",fval);
	else
	    sprintf(string,"%f",fval);
*/
	sprintf(string,"%g",fval);
    } else
    if(strcmp(info->type,"double") ==0){
	dval = *((double *)(adr));
/*
	if((fabs(dval) < 1e-6 || fabs(dval) > 1e6)
	 && dval != 0.0)
	    sprintf(string,"%e",dval);
	else
	    sprintf(string,"%f",dval);
*/
	    sprintf(string,"%g",dval);
    } else
    if(strcmp(info->type,"short") ==0){
	sprintf(string,"%d",*((short *)adr));
    } else
    if(strcmp(info->type,"unsigned char") ==0){
	sprintf(string,"%d",*((unsigned char *)adr));
    } else 
    if(strcmp(info->type,"unsigned short") ==0){
	sprintf(string,"%d",*((unsigned short *)adr));
    } else {
	return("");
    }
    return(string);
}

PutValue(adr,info,value)
char *adr;
Info *info;
char *value;
{
char *name;
PFI func;

    if(adr == NULL || value == NULL) return(0);
    if(info->function_type){
	if((func = (PFI)GetFuncAddress(value))== NULL){
	    printf("could not find function '%s'\n",value);
	    return(0);
	} else {
	    *((PFI *)adr) = func;
	}
    } else
    if(strcmp(info->type,"int") ==0){
	*((int *)adr) = atoi(value);
    } else
    if(strcmp(info->type,"float") ==0){
	*((float *)adr) = Atof(value);
    } else
    if(strcmp(info->type,"double") ==0){
	*((double *)adr) = Atof(value);
    } else
    if(strcmp(info->type,"short") ==0){
	*((short *)adr) = atoi(value);
    } else
    if(strcmp(info->type,"unsigned char") ==0){
	*((unsigned char *)adr) = atoi(value);
    } else
    if(strcmp(info->type,"unsigned short") ==0){
	*((unsigned short *)adr) = (unsigned short)(atoi(value));
    } else
    if(strcmp(info->type,"char") ==0){
	if(info->field_indirection == 1){
	    name = (char *)malloc(strlen(value)+1);
	    strcpy(name,value);
	    *((char **)adr) = name;
	} else
	if(info->field_indirection == 0){
	    *((char *)adr) = atoi(value);
	}
    } else {
	printf("unable to assign to type '%s'\n",info->type);
	return(0);
    }
    return(1);
}

