#include "sim_ext.h"
#include <sys/types.h>
#include <fcntl.h>
#include <sys/stat.h>

extern int debug;
extern FILE *CurrentScriptFp();
extern char *progname;

extern 	etext;
extern 	edata;
extern 	eprol;
extern caddr_t	sbrk();


int memusage()
{
int	memsize;
#ifdef mips
    memsize = (int)sbrk(0) - (int)(&edata);
#else
    memsize = (int)sbrk(0);
#endif
    return(memsize);
}

int do_memlocations(argc,argv)
int argc;
char **argv;
{
int	value;
    if(argc < 2){
	printf("usage: %s [data][text][start][end]\n",argv[0]);
	return(0);
    }

    if(strcmp(argv[1],"data") == 0){
	value = (int)(&edata);
    } else
    if(strcmp(argv[1],"text") == 0){
	value = (int)(&etext);
    } else
    if(strcmp(argv[1],"end") == 0){
	value = (int)sbrk(0);
    } else {
	printf("unknown option '%s'\n",argv[1]);
	value = 0;
    }
    return(value);
}

#ifdef LATER
do_malloc_debug(argc,argv)
int	argc;
char	**argv;
{
    malloc_debug(atoi(argv[1]));
}
#endif

/* returns the address rounded up to the next page boundary */
Align(pagesize,adr)
int	pagesize;
int	adr;
{
int	mask;
int	size;

    size = pagesize - 1;
    mask = 0xffffffff & ~size;
    return((adr + size) & mask);
}

SaveDataImage(file)
char	*file;
{
FILE	*fp;
char 	*start_edata;
char	*start_etext;
caddr_t	end;
extern caddr_t	sbrk();
extern 	etext;
extern 	edata;
int	length;
int	fd;
time_t	time;
struct stat buf;
char	*buffer;
    
    if((fd = open(file,O_WRONLY | O_CREAT,0644)) == -1){
	perror("save");
	printf("unable to open file '%s' for writing\n",file);
	return(0);
    }
    end = (caddr_t)sbrk(0);
    start_edata = (char *)(&edata);
    length = (int)end - (int)start_edata;
    start_etext = (char *)(&etext);

    if(debug) {
	printf("edata = %d\n",(int)start_edata);
        printf("end = %d\n",(int)end);
        printf("length = %d\n",length);
    }
    /* save the modification time of the executable */
    if(stat(progname,&buf) != -1){
	time = buf.st_mtime;
    } else {
	time = 0;
    }
    /*
    ** write out the header
    */
    write(fd,&time,sizeof(time_t));
    write(fd,&start_etext,sizeof(char *));
    write(fd,&start_edata,sizeof(char *));
    write(fd,&end,sizeof(caddr_t));

    /*
    ** write out the dynamic data segment
    */
    if(write(fd,start_edata,length) != length){
	perror("writing");
    }
#ifdef NEW
    /*
    ** do the initialized data segment
    */
    length = (int)start_edata - (int)start_etext +1;

    if(debug) {
        printf("etext = %d\n",start_etext);
        printf("initialized data length = %d\n",length);
    }

    /*
    ** write out the initialized data segment
    */
    if(write(fd,start_etext,length) != length){
	perror("writing");
    }
#endif
    close(fd);
    return(1);
}

RestoreDataImage(file)
char	*file;
{
FILE	*fp;
char 	*start_etext;
char 	*start_edata;
caddr_t	end;
extern caddr_t	sbrk();
extern 	etext;
extern 	edata;
int	length;
int	fd;
time_t	time;
time_t	mytime;
struct stat buf;
    
    if((fd = open(file,O_RDONLY)) == -1){
	perror("restore");
	printf("unable to open file '%s' for reading\n",file);
	return(0);
    }

    /* 
    ** check the modify time of the executable used to save the image
    ** against the modify time of the current executable
    */
    read(fd,&time,sizeof(time_t));
    if(stat(progname,&buf) != -1){
	mytime = buf.st_mtime;
    } else {
	mytime = 0;
    }
    if(time != mytime){
	printf("\n");
	Warning();
	printf("The version of GENESIS under which '%s'\n",file);
	printf("was saved might not be compatible with this version.\n");
	printf("This could lead to unpredictable behavior.\n");
	printf("\n");
    }
    read(fd,&start_etext,sizeof(char *));
    read(fd,&start_edata,sizeof(char *));
    read(fd,&end,sizeof(caddr_t));

    if(debug){
	printf("read etext = &%d\n",(int)start_etext);
	printf("read edata = &%d\n",(int)start_edata);
	printf("read end = &%d\n",(int)end);
    }

    /* set the new brk value */
    if(brk(end) == -1){
	printf("unable to extend the brk point.\nRestore failed.\n");
	close(fd);
	return(0);
    }

    /*
    ** read in the dynamic data segment
    */
    /* check the old and new start values */
    if(start_edata != (char *)&edata){
	printf("edata mismatch for the data segment.\n");
	return(0);
    }

    length = (int)end - (int)start_edata;

    /* read in the saved data segment */
    read(fd,start_edata,length);

    if(debug) {
	printf("assigned end = %d\n",(int)sbrk(0));
    }
#ifdef NEW
    /*
    ** read in the initialized data segment
    */
    /* check the old and new start values */
    if(start_etext != (char *)&etext){
	printf("etext mismatch for the data segment.\n");
	return(0);
    }

    length = (int)start_edata - (int)start_etext;

    /* read in the saved data segment */
    read(fd,start_etext,length);
#endif
    close(fd);
    return(1);
}

int do_restore(argc,argv)
int	argc;
char	**argv;
{
char	string[100];
char	filename[100];
int	nxtarg;
int	compress;

    if(argc < 2){
	printf("usage: %s filename [-nocompress]\n",argv[0]);
	return(0);
    }
    compress = 1;

    nxtarg = 0;
    while(++nxtarg < argc){
	if(strcmp(argv[nxtarg],"-nocompress") == 0){
	    compress = 0;
	} else 
	if(argv[nxtarg][0] != '-'){
	    sprintf(filename,"%s.sav",argv[nxtarg]);
	}
    }
    /*
    ** make sure that you are not in a script
    */
    if(CurrentScriptFp() != stdin){
	printf("%s can only be executed from the keyboard.\n",argv[0]);
	return(0);
    }
    /*
    ** decompress the datafile
    */
    if(compress){
	printf("uncompressing %s.Z: ",filename);
	fflush(stdout);
	sprintf(string,"uncompress -cv %s > /tmp/%s",filename,filename);
	system(string);

	/* set the filename to the tmp file */
	sprintf(string,"/tmp/%s",filename);
	strcpy(filename,string);
    }
    /*
    ** restore the file
    */
    if(!RestoreDataImage(filename)){
	printf("%s failed.\n",argv[0]);
	if(compress){
	    unlink(filename);
	}
	return(0);
    }
    if(compress){
	unlink(filename);
    }
    OK();
    restore_context();
    return(1);
}

int do_save(argc,argv)
int	argc;
char	**argv;
{
char	string[100];
char	filename[100];
int	nxtarg;
int	compress;

    if(argc < 2){
	printf("usage: %s filename [-nocompress]\n",argv[0]);
	return(0);
    }
    compress = 1;

    nxtarg = 0;
    while(++nxtarg < argc){
	if(strcmp(argv[nxtarg],"-nocompress") == 0){
	    compress = 0;
	} else 
	if(argv[nxtarg][0] != '-'){
	    sprintf(filename,"%s.sav",argv[nxtarg]);
	}
    }
    /*
    ** make sure that you are not in a script
    */
    if(CurrentScriptFp() != stdin){
	printf("%s can only be executed from the keyboard.\n",argv[0]);
	return(0);
    }
    if(!SaveDataImage(filename)){
	printf("%s failed.\n",argv[0]);
	return(0);
    }
    /*
    ** compress the datafile
    */
    if(compress){
	printf("compressing ");
	fflush(stdout);
	sprintf(string,"compress -v %s",filename);
	system(string);
    }
    OK();
    return(1);
}

int CheckType2Header(file)
char *file;
{
FILE *fp;
int	size = 80;
char	header[80];

    /*
    ** check the header
    */
    if((fp = fopen(file,"r")) == NULL){
	printf("unable to read file '%s'\n",file);
	return(0);
    }
    fgets(header,size,fp);
    fclose(fp);
    if(strncmp(header,"TYPE2",5) != 0){
	printf("incompatible save formats 'TYPE2' and '%s'\n",header);
	return(0);
    }
    return(1);
}

int do_saveparms(argc,argv)
int argc;
char **argv;
{
FILE 	*fp;
char 	*mode;
char 	*file;
char 	*path;
PFI	func;
Action	action;
Element	*element;
ElementList	*list;
int	i;

    if(argc < 2){
	printf("usage: %s path file [-append]\n",argv[0]);
	return(0);
    }
    mode = "w";
    path = argv[1];
    file = argv[2];
    if(argc > 3 && (strcmp(argv[3],"-append") == 0)){
	mode = "a";
    }
    if(strcmp(mode,"a") == 0){
	if(!CheckType2Header(file)){
	    return(0);
	}
    } 
    if((fp = fopen(file,mode)) == NULL){
	printf("unable to write to file '%s'\n",file);
	return(0);
    }
    if(strcmp(mode,"w") == 0){
	/*
	** write out the header
	*/
	fprintf(fp,"TYPE2\n");
    }
    list = WildcardGetElement(path,1);
    action.data = (char *)fp;
    action.type = SAVE2;
    action.name = "SAVE2";
    for(i=0;i<list->nelements;i++){
	element = list->element[i];
	/*
	** call the element function with the desired action
	*/
	if((func = GetActionFunc(element->object,SAVE2)) != NULL){
	    fprintf(fp,"%s\n",Pathname(element));
	    func(element,&action);
	} else {
	    printf("'%s' does not support the SAVE2 action\n",
	    Pathname(element));
	}
    }
    fclose(fp);
    FreeElementList(list);
    return(1);
}

int do_restoreparms(argc,argv)
int argc;
char **argv;
{
FILE 	*fp;
char 	*file;
char 	path[300];
int	size = 300;
PFI	func;
Action	action;
char	restoredata[1000];
Element	*element;
char	*ptr;

    if(argc < 2){
	printf("usage: %s file\n",argv[0]);
	return(0);
    }
    file = argv[1];
    if(!CheckType2Header(file)){
	return(0);
    }
    if((fp = fopen(file,"r")) == NULL){
	printf("unable to read from file '%s'\n",file);
	return(0);
    }
    action.data = (char *)fp;
    action.type = RESTORE2;
    action.name = "RESTORE2";
    /*
    ** skip past the header
    */
    fgets(path,size,fp);
    while(!feof(fp)){
	fgets(path,size,fp);
	/*
	** strip the CR 
	*/
	for(ptr=path;*ptr != '\n' && *ptr != '\0';ptr++);
	*ptr = '\0';
	if((element = GetElement(path)) == NULL){
	    Error();
	    printf("cannot find element '%s'\n",path);
	    fclose(fp);
	    return(0);
	}
	/*
	** call the element function with the desired action
	*/
	if((func = GetActionFunc(element->object,RESTORE2)) != NULL){
	    func(element,&action);
	} else {
	    printf("'%s' does not support the RESTORE2 action\n",
	    Pathname(element));
	    fclose(fp);
	    return(0);
	}
    }
    fclose(fp);
    return(1);
}
