#include "sim_ext.h"

do_position(argc,argv)
int argc;
char **argv;
{
Element *element;
float	x,y,z;

    if(argc < 5){
	printf("usage: %s element x y z\n",argv[0]);
	printf("['I' to ignore, 'R' for relative. e.g. %s name R1.5 I 3]\n",
	argv[0]);
	return;
    }
    if((element = GetElement(argv[1])) == NULL){
	printf("unable to find element '%s'\n",argv[1]);
	return;
    }
    if(strcmp(argv[2],"I") == 0){
	x = element->x;
    } else {
	if(argv[2][0] == 'R'){
	    x = Atof(argv[2]+1) + element->x;
	} else {
	    x = Atof(argv[2]);
	}
    }
    if(strcmp(argv[3],"I") == 0){
	y = element->y;
    } else {
	if(argv[3][0] == 'R'){
	    y = Atof(argv[3]+1) + element->y;
	} else {
	    y = Atof(argv[3]);
	}
    }
    if(strcmp(argv[4],"-") == 0){
	z = element->z;
    } else {
	if(argv[4][0] == 'R'){
	    z = Atof(argv[4]+1) + element->z;
	} else {
	    z = Atof(argv[4]);
	}
    }
    if(!PositionElement(element, x,y,z)){
	printf("unable to position element '%s'\n",argv[1]);
    }
}

PositionElement(parent,x,y,z)
Element 	*parent;
float 		x,y,z;
{
Element 	*child;
ElementStack 	*stk;
float		dx,dy,dz;

    if(parent == NULL) return(0);
    /*
    ** position the parent element
    */
    dx = x - parent->x;
    dy = y - parent->y;
    dz = z - parent->z;
    parent->x = x;
    parent->y = y;
    parent->z = z;
    /*
    ** propagate the coordinates down the tree
    */
    stk = NewPutElementStack(parent);
    while((child = NewFastNextElement(0,stk)) != NULL){
	child->x += dx;
	child->y += dy;
	child->z += dz;
    }
    NewFreeElementStack(stk);
    return(1);
}
