#include "sim_ext.h"
#include "hash.h"

HASH *object_hash_table;

/*
** Hash table utilities
*/
void ObjectHashInit()
{
HASH *hash_create();

    /*
    ** create the table
    */
    object_hash_table = hash_create(2000);
}

int ObjectHashPut(object)
GenesisObject *object;
{
ENTRY	item,*hash_enter();

    item.data = (char *)calloc(1,sizeof(GenesisObject));
    bcopy(object,item.data,sizeof(GenesisObject));
    item.key = (char *)(((GenesisObject *)(item.data))->name);
    /*
    ** put the object into the table
    */
    if(hash_enter(&item,object_hash_table) == NULL){
	Error();
	printf("object hash table full\n");
	return(0);
    };
    return(1);
}

GenesisObject *ObjectHashFind(key)
char	*key;
{
ENTRY	*found_item,*hash_find();

    /*
    ** get the object from the table
    */
    if((found_item = hash_find(key,object_hash_table)) != NULL){
	return((GenesisObject *)found_item->data);
    } else
	return(NULL);
}


/*
** get the object from the object table
*/
GenesisObject *GetObject(name)
char *name;
{
extern GenesisObject	*ObjectHashFind();
#ifdef LATER
static	GenesisObject	*saved_object = NULL;
static	char	*saved_name = NULL;
#endif
    if(name == NULL) return(NULL);
#ifdef LATER
    if(saved_name == name) return(saved_object);
    saved_name = name;
    saved_object = ObjectHashFind(name);
    return(saved_object);
#else
    return(ObjectHashFind(name));
#endif
}

/*
** get the value of var from the object environment list
*/
char *getobjenv(object,var)
GenesisObject 	*object;
char	*var;
{
int	i;

    if(object == NULL || var == NULL) return(NULL);
    for(i=0;i<object->envc-1;i += 2){
	if(strcmp(var,object->env[i]) == 0){
	    return(object->env[i+1]);
	}
    }
    return(NULL);
}

int setobjenv(object,var,value)
GenesisObject *object;
char *var;
char *value;
{
int i;

    if(object == NULL || var == NULL ){
	return(0);
    }
    /*
    ** try to find the environment variable
    */
    for(i=0;i<object->envc-1;i+=2){
	if(strcmp(object->env[i],var) == 0){
	    break;
	}
    }
    if(i < object->envc-1){
	/*
	** a match was found so make the substitution
	*/
	object->env[i] = CopyString(var);
	object->env[i+1] = CopyString(value);

    } else {
	/*
	** append a new environment variable
	*/
	if(object->env){
	    object->env = (char **)
	    realloc(object->env,(object->envc+2)*sizeof(char *));
	} else {
	    object->env = (char **)
	    calloc(object->envc+2,sizeof(char *));
	}
	object->env[object->envc] = CopyString(var);
	object->env[object->envc+1] = CopyString(value);
	object->envc += 2;
    }
}


/*
** add an object to the object table
*/
int AddObject(object)
GenesisObject *object;
{
    ObjectHashPut(object);
}

ObjectAddClass(object,id)
GenesisObject 	*object;
int	id;
{
ClassList	*class;

    class = (ClassList *)malloc(sizeof(ClassList));
    class->id = id;
    class->next = object->class;
    object->class = class;
}

void do_add_object(argc,argv)
int	argc;
char 	**argv;
{
GenesisObject	object;
int	nxtarg;
int	mode = 0;
char	*name;
int	type;
int	slots;
int	i;
MsgList		*new_msg;
FieldList	*new_field;
char	description[1000];
char	author[100];
char	*function_name;
char	*string;
PFI	function;

    if(argc < 5){
	printf("usage: %s name data function class\n", argv[0]);
	printf("\t[-author text]\n");
	printf("\t[-messages name type nslots slotnames]\n");
	printf("\t[-actions names]\n");
	printf("\t[-fields names]\n");
	printf("\t[-default args]\n");
	printf("\t[-environment var value var2 value2 ..]\n");
	printf("\t[-description text]\n");
	return;
    }
    function_name = argv[3];
    bzero(&object,sizeof(GenesisObject));
    /*
    ** make an empty object
    */
    object.name 		= CopyString(argv[1]);
    /*
    ** check on the type
    */
    if(!FieldHashFind(argv[2])){
	Error();
	printf("invalid data type\n");
	return;
    }
    object.type 		= CopyString(argv[2]);
    object.size			= StructSize(object.type);
    if((object.function 	= GetFuncAddress(argv[3])) == NULL){
	Error();
	printf("could not find function '%s'\n",argv[3]);
	return;
    }
    nxtarg = 3;
    /*
    ** get the class specification up to the first option
    */
    while(++nxtarg < argc){
	if((strcmp(argv[nxtarg],"-default") ==0) ||
	(strcmp(argv[nxtarg],"-environment") ==0) ||
	(strcmp(argv[nxtarg],"-actions") ==0) ||
	(strcmp(argv[nxtarg],"-fields") ==0) ||
	(strcmp(argv[nxtarg],"-description") ==0) ||
	(strcmp(argv[nxtarg],"-author") ==0) ||
	(strcmp(argv[nxtarg],"-messages") ==0) 
	) {
	    nxtarg--;
	    break;
	}
	ObjectAddClass(&object,ClassID(argv[nxtarg]));
    }
    description[0] = '\0';
    author[0] = '\0';
    /*
    ** get the options
    */
    while(++nxtarg < argc){
	if(strcmp(argv[nxtarg],"-default") ==0){
	    mode = 1;
	    continue;
	}
	if(strcmp(argv[nxtarg],"-environment") ==0) {
	    mode = 2;
	    continue;
	}
	if(strcmp(argv[nxtarg],"-actions") ==0) {
	    mode = 3;
	    continue;
	}
	if(strcmp(argv[nxtarg],"-fields") ==0) {
	    mode = 4;
	    continue;
	}
	if(strcmp(argv[nxtarg],"-messages") ==0) {
	    mode = 5;
	    continue;
	}
	if(strcmp(argv[nxtarg],"-description") ==0) {
	    mode = 6;
	    continue;
	}
	if(strcmp(argv[nxtarg],"-author") ==0) {
	    mode = 7;
	    continue;
	}
	switch(mode){
	case 0:
	    Error();
	    printf("syntax error\n");
	    return;
	case 1:			/* default */
	    /*
	    ** get the default values or execute a function on the
	    ** default object
	    */
	    break;
	case 2:			/* environment */
	    if(object.env == NULL){
		object.env =
		(char **)calloc(2,sizeof(char *));
	    } else {
		object.env = (char **)realloc(object.env,
		(object.envc+2)*sizeof(char *));
	    }
	    /*
	    ** copy the first argument
	    */
	    ++object.envc;
	    object.env[object.envc-1] = CopyString(argv[nxtarg]);
	    if(++nxtarg >= argc){
		printf("insufficient arguments to %s\n",argv[0]);
		return;
	    }
	    /*
	    ** get the second
	    */
	    ++object.envc;
	    object.env[object.envc-1] = CopyString(argv[nxtarg]);
	    break;	
	case 3:			/* actions */
	    name = argv[nxtarg];
	    function = object.function;
	    /*
	    ** try to find a special action function
	    */
	    if(name[0] == '*'){
		name++;
		/*
		** get the action function name 
		*/
		if((function = GetFuncAddress(argv[++nxtarg])) == NULL){
		    Error();
		    printf("cant find function '%s'\n",argv[nxtarg]);
		    return;
		}
	    }
	    if(!AddActionToObject(&object,name,function)){
		Error();
		printf("unable to add action '%s' to '%s'\n",name,object.name);
	    }
	    break;
	case 4:			/* fields */
	    new_field = (FieldList *)malloc(sizeof(FieldList));
	    new_field->name = CopyString(argv[nxtarg]);
	    new_field->next = object.public_fields;
	    object.public_fields = new_field;
	    break;
	case 5:			/* messages */
	    name = argv[nxtarg];
	    if(++nxtarg >= argc){
		printf("insufficient arguments to %s\n",argv[0]);
		return;
	    }
	    type = atoi(argv[nxtarg]);
	    if(++nxtarg >= argc){
		printf("insufficient arguments to %s\n",argv[0]);
		return;
	    }
	    slots = atoi(argv[nxtarg]);
	    new_msg = (MsgList *)malloc(sizeof(MsgList));
	    new_msg->type = type;
	    new_msg->name = CopyString(name);
	    new_msg->slots = slots;
	    new_msg->slotname = (char **)malloc(slots*sizeof(char *));
	    for(i=0;i<slots;i++){
		if(++nxtarg >= argc){
		    printf("insufficient arguments to %s\n",argv[0]);
		    return;
		}
		new_msg->slotname[i] = CopyString(argv[nxtarg]);
	    }
	    new_msg->next = object.valid_msgs;
	    object.valid_msgs = new_msg;
	    break;
	case 6:
	    /*
	    ** read arguments into a description string
	    */
	    strcat(description,argv[nxtarg]);
	    strcat(description,"\n");
	    break;
	case 7:
	    /*
	    ** read arguments into a description string
	    */
	    strcat(author,argv[nxtarg]);
	    break;
	}
    }
    if(strlen(description) > 0){
	object.description = CopyString(description);
    }
    if(strlen(author) > 0){
	object.author = CopyString(author);
    }
    AddObject(&object);
}

/*
** preload the object table with some basic objects
*/
void BasicObjects()
{
GenesisObject	object;

    bzero(&object,sizeof(GenesisObject));
    /*
    ** make an empty object
    */
    object.name 		= "neutral";
    ObjectAddClass(&object,ELEMENT_ELEMENT);
    object.function 		= NULL;
    object.type 		= "element_type";
    object.size			= sizeof(struct element_type);
    AddObject(&object);
}

void do_list_objects()
{
extern HASH *object_hash_table;
char 	*name;
int	cnt=0;
int 	i;
char	**namelist;
extern int Strcmp();

    /*
    ** count the objects
    */
    for(i=0;i<object_hash_table->size;i++){
	if(name = object_hash_table->entry[i].key){
	    cnt++;
	}
    }
    if(cnt <1) return;
    /*
    ** make the list
    */
    namelist = (char **)malloc(sizeof(char *)*cnt);
    cnt = 0;
    for(i=0;i<object_hash_table->size;i++){
	if(name = object_hash_table->entry[i].key){
	    namelist[cnt++] = name;
	}
    }
    /*
    ** sort the list
    */
    qsort(namelist,cnt,sizeof(char *),Strcmp);
    printf("\nAVAILABLE OBJECTS:\n");
    for(i=0;i<cnt;i++){
	printf("%-20s",namelist[i]);
	if(((i+1)%4) == 0){
	    printf("\n");
	}
    }
    printf("\n\n");
    free(namelist);
}

void do_show_object(argc,argv)
int	argc;
char 	**argv;
{
GenesisObject	*object;

    if(argc < 2){
	printf("usage: %s name\n",argv[0]);
	return;
    }
    if(object = GetObject(argv[1])){
	ShowObject(object);
    } else {
	Error();
	printf("could not find object '%s'\n",argv[1]);
    }
}

char *do_getelementenv(argc,argv)
int argc;
char **argv;
{
Element	*element;

    if(argc < 3){
	printf("usage: %s element variable\n",argv[0]);
	return(NULL);
    }
    if((element = GetElement(argv[1])) == NULL){
	InvalidPath(argv[0],argv[1]);
	return(NULL);
    }
    return(CopyString(getobjenv(element->object,argv[2])));
}

int do_setelementenv(argc,argv)
int argc;
char **argv;
{
Element	*element;
GenesisObject	*object;
int	nxtarg;

    if(argc < 4){
	printf("usage: %s element variable value [variable value]\n",argv[0]);
	return(0);
    }
    if((element = GetElement(argv[1])) == NULL){
	InvalidPath(argv[0],argv[1]);
	return(0);
    }
    /*
    ** make a copy of the element object
    */
    object = (GenesisObject *)malloc(sizeof(GenesisObject));
    bcopy(element->object,object,sizeof(GenesisObject));
    /*
    ** make a copy of the object environment
    */
    object->env = (char **)malloc(object->envc*sizeof(char *));
    bcopy(element->object->env,object->env,object->envc*sizeof(char *));
    nxtarg = 2;
    while(argc > nxtarg + 1){
	/*
	** set the object environment variable
	*/
	setobjenv(object,argv[nxtarg],argv[nxtarg+1]);
	nxtarg += 2;
    }
    /*
    ** assign the new object to the element
    */
    element->object = object;
    return(1);
}

int do_setobjenv(argc,argv)
int argc;
char **argv;
{
GenesisObject	*object;
int	nxtarg;

    if(argc < 3){
	printf("usage: %s object var value\n",argv[0]);
	return(0);
    }
    if((object = GetObject(argv[1])) == NULL){
	Error();
	printf("could not find object '%s'\n",argv[1]);
	return(NULL);
    }
    nxtarg = 2;
    while(argc > nxtarg + 1){
	/*
	** set the object environment variable
	*/
	setobjenv(object,argv[nxtarg],argv[nxtarg+1]);
	nxtarg += 2;
    }
}

char *do_getobjenv(argc,argv)
int argc;
char **argv;
{
GenesisObject	*object;

    if(argc < 3){
	printf("usage: %s object variable\n",argv[0]);
	return(NULL);
    }
    if((object = GetObject(argv[1])) == NULL){
	Error();
	printf("could not find object '%s'\n",argv[1]);
	return(NULL);
    }
    return(CopyString(getobjenv(object,argv[2])));
}
