#include "shell_ext.h"

#ifdef NEW
char *do_INPUT(argc,argv)
int argc;
char **argv;
{
char str[1000];
char prompt[100];
char *ptr;
char *retstr;
char *defvalue;
char defstr[100];

    if(argc > 1){
	ptr = argv[1];
    } else {
	ptr = "?";
    }
    if(argc > 2){
	defvalue = argv[2];
	sprintf(defstr,"(def = %s) ",defvalue);
    } else {
	defvalue = "";
    }
    sprintf(prompt,"%s%s ",defstr,ptr);
    AlternatePrompt(prompt);
    fflush(stdout);
    GetLineFp(str,stdin,1000);
    /*
    ** remove the CR
    */
    if(ptr = strchr(str,'\n')){
	*ptr = '\0';
    }
    /*
    ** use the default value if nothing is entered
    */
    if(str[0] == '\0'){
	retstr = CopyString(defvalue);
    } else {
	retstr = CopyString(str);
    }
    AlternatePrompt(NULL);
    return(retstr);
}

float do_Random(argc,argv)
int argc;
char **argv;
{
float val;

    if(argc < 3){
	printf("usage: %s(lo,hi)\n",argv[0]);
	return(0.0);
    }
    val = frandom(Atof(argv[1]),Atof(argv[2]));
    return(val);
}

float do_Gaussian(argc,argv)
int argc;
char **argv;
{
float val;

    if(argc < 3){
	printf("usage: %s(u,s)\n",argv[0]);
	return(0.0);
    }
    val = rangauss(Atof(argv[1]),Atof(argv[2])*Atof(argv[2]));
    return(val);
}

float do_max(argc,argv)
int argc;
char **argv;
{
    if(argc < 3){
	printf("usage: %s(n1,n2)\n",argv[0]);
	return(0);
    }
    return(MAX(Atof(argv[1]),Atof(argv[2])));
}

float do_min(argc,argv)
int argc;
char **argv;
{
    if(argc < 3){
	printf("usage: %s(n1,n2)\n",argv[0]);
	return(0);
    }
    return(MIN(Atof(argv[1]),Atof(argv[2])));
}

int do_trunc(argc,argv) 
int argc; 
char **argv; 
{ 
    return((int)(Atof(argv[1]))); 
}

int do_round(argc,argv)
int argc;
char **argv;
{
    return(round(Atof(argv[1])));
}

float do_tan(argc,argv)
int argc;
char **argv;
{
    return((float)(tan(Atof(argv[1]))));
}

float do_sin(argc,argv)
int argc;
char **argv;
{
    return((float)(sin(Atof(argv[1]))));
}

float do_cos(argc,argv)
int argc;
char **argv;
{
    return((float)(cos(Atof(argv[1]))));
}

float do_asin(argc,argv)
int argc;
char **argv;
{
    return((float)(asin(Atof(argv[1]))));
}

float do_acos(argc,argv)
int argc;
char **argv;
{
    return((float)(acos(Atof(argv[1]))));
}

float do_atan(argc,argv)
int argc;
char **argv;
{
    return((float)(atan(Atof(argv[1]))));
}

float do_pow(argc,argv)
int argc;
char **argv;
{
    if(argc < 3){
	printf("usage: %s(n1,n2)\n",argv[0]);
	return(0.0);
    }
    return((float)(pow(Atof(argv[1]),Atof(argv[2]))));
}

float do_sqrt(argc,argv)
int argc;
char **argv;
{
    return((float)(sqrt(Atof(argv[1]))));
}

float do_exp(argc,argv)
int argc;
char **argv;
{
    return((float)(exp(Atof(argv[1]))));
}

float do_log(argc,argv)
int argc;
char **argv;
{
    return((float)(log(Atof(argv[1]))));
}

float do_fabs(argc,argv)
int argc;
char **argv;
{
    return((float)(fabs(Atof(argv[1]))));
}

char *do_getarg(argc,argv)
int argc;
char **argv;
{
int n;
char *itoa();

    if(argc < 3){
	printf("usage: %s [-count] arg# arg1 ... argn\n",argv[0]);
	return(NULL);
    }
    if(strcmp(argv[1],"-count") == 0){
	return(itoa(argc-2));
    }
    n = atoi(argv[1]) + 1;
    if(n >= argc || n < 1){
	printf("invalid argument number '%d'\n",n-1);
	return(NULL);
    }
    return(argv[n]);
}

char *do_cat(argc,argv)
int argc;
char **argv;
{
char *str;
    if(argc < 3){
	printf("usage: %s(s1,s2)\n",argv[0]);
	return(NULL);
    }
    str = (char *)malloc(strlen(argv[2])+strlen(argv[1])+1);
    sprintf(str,"%s%s",argv[1],argv[2]);
    return(str);
}

char *do_substring(argc,argv)
int argc;
char **argv;
{
int start;
int end;
int len;
char *s;
char *copy;

    if(argc < 3){
	printf("usage: %s string startindex [endindex]\n",argv[0]);
	return(NULL);
    }
    s = argv[1];
    start = atoi(argv[2]);
    if(argc > 3){
	end = atoi(argv[3]);
    } else {
	end = strlen(s)-1;
    }
    if((len = end -start+1) < 0){
	return(NULL);
    }
    copy = (char *)malloc(len +1);
    strncpy(copy,s+start,len);
    copy[len] = '\0';
    return(copy);
}

int do_findchar(argc,argv)
int argc;
char **argv;
{
char *s;
char c;
char *loc;

    if(argc < 3){
	printf("usage: %s string char\n",argv[0]);
	return(NULL);
    }
    s = argv[1];
    c = argv[2][0];
    if(( loc =strchr(s,c)) == NULL){
	return(-1);
    }
    return(loc-s);
}

int do_countchar(argc,argv)
int argc;
char **argv;
{
char *s;
char c;
int count;

    if(argc < 3){
	printf("usage: %s string char\n",argv[0]);
	return(NULL);
    }
    s = argv[1];
    c = argv[2][0];
    while(( s =strchr(s,c)) != NULL){
	count ++;
    }
    return(count);
}

int do_strcmp(argc,argv)
int argc;
char **argv;
{
    if(argc < 3){
	printf("usage: %s(s1,s2)\n",argv[0]);
	return(0);
    }
    return(strcmp(argv[1],argv[2]));
}

int do_strncmp(argc,argv)
int argc;
char **argv;
{
    if(argc < 4){
	printf("usage: %s(s1,s2,n)\n",argv[0]);
	return(0);
    }
    return(strncmp(argv[1],argv[2],atoi(argv[3])));
}

int do_strlen(argc,argv)
int argc;
char **argv;
{
    return(strlen(argv[1]));
}

char **do_arglist(argc,argv)
int argc;
char **argv;
{
int nargc;
char **nargv;

    if(argc < 1){
	printf("usage: %s string\n",argv[0]);
	return(NULLArgv());
    }
    StringToArgList(argv[1],&nargc,&nargv,0);
    return(nargv);
}

#endif
